/*
 * Decompiled with CFR 0.152.
 */
package jimena.analysis;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;
import jimena.binarybf.actinhibitf.ActivatorInhibitorFunction;
import jimena.binaryrn.Connection;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.libs.DoubleValue;

public class NetworkGenerator {
    public static RegulatoryNetwork constructERnetwork(int size, int connectionsWithoutInputLoops, int nonInputLoops, boolean addInputLoops, double act, int inputs) {
        RegulatoryNetwork n = null;
        while ((n = NetworkGenerator.constructERnetwork(size, connectionsWithoutInputLoops, nonInputLoops, addInputLoops, act)).numberOfInputs() != inputs) {
        }
        return n;
    }

    public static RegulatoryNetwork constructERnetwork(int size, int connectionsWithoutInputLoops, int nonInputLoops, boolean addInputLoops, double act) {
        int i;
        ArrayList<Boolean> activating;
        ArrayList<Integer> to;
        ArrayList<Integer> from;
        Random generator = new Random();
        int failsafe = 100000;
        do {
            if (--failsafe == 0) {
                return null;
            }
            from = new ArrayList<Integer>();
            to = new ArrayList<Integer>();
            activating = new ArrayList<Boolean>();
            i = 0;
            while (i < connectionsWithoutInputLoops) {
                int n2;
                int n1 = generator.nextInt(size);
                if (n1 == (n2 = generator.nextInt(size)) || NetworkGenerator.contains(from, to, n1, n2)) {
                    --i;
                } else {
                    from.add(n1);
                    to.add(n2);
                    activating.add(Math.random() < act);
                }
                ++i;
            }
        } while (!NetworkGenerator.isConnected(from, to, size));
        i = 0;
        while (i < nonInputLoops) {
            if (--failsafe == 0) {
                return null;
            }
            int n = generator.nextInt(size);
            if (NetworkGenerator.contains(from, to, n, n)) {
                --i;
            } else {
                from.add(n);
                to.add(n);
                activating.add(true);
            }
            ++i;
        }
        if (addInputLoops) {
            NetworkGenerator.addInputLoops(from, to, activating, size);
        }
        return NetworkGenerator.constructNetwork(from, to, activating, size);
    }

    public static void addInputLoops(ArrayList<Integer> from, ArrayList<Integer> to, ArrayList<Boolean> activating, int size) {
        int i = 0;
        while (i < size) {
            if (NetworkGenerator.isInput(to, i)) {
                from.add(i);
                to.add(i);
                activating.add(true);
            }
            ++i;
        }
    }

    public static RegulatoryNetwork constructSFnetwork(int size, int connectionsWithoutInputLoops, int nonInputLoops, boolean addInputLoops, double act, int inputs) {
        RegulatoryNetwork n = null;
        while ((n = NetworkGenerator.constructSFnetwork(size, connectionsWithoutInputLoops, nonInputLoops, addInputLoops, act)).numberOfInputs() != inputs) {
        }
        return n;
    }

    public static RegulatoryNetwork constructSFnetwork(int size, int connectionsWithoutAnyLoops, int nonInputLoops, boolean addInputLoops, double act) {
        int perStep = (int)Math.ceil((double)(connectionsWithoutAnyLoops - 1) / (double)size);
        Random generator = new Random();
        ArrayList<Integer> from = new ArrayList<Integer>();
        ArrayList<Integer> to = new ArrayList<Integer>();
        ArrayList<Boolean> activating = new ArrayList<Boolean>();
        from.add(0);
        to.add(1);
        activating.add(Math.random() < act);
        int deferred = 0;
        int failsafe = 100000;
        int i = 0;
        while (i < size) {
            int tries = 0;
            int c = 0;
            while (c < perStep + deferred) {
                int t;
                int f;
                boolean incoming;
                if (--failsafe == 0) {
                    return null;
                }
                int otherNode = Math.random() < 0.5 ? from.get(generator.nextInt(from.size())).intValue() : to.get(generator.nextInt(from.size())).intValue();
                boolean bl = incoming = Math.random() < 0.5;
                if (incoming) {
                    f = otherNode;
                    t = i;
                } else {
                    f = i;
                    t = otherNode;
                }
                if (!NetworkGenerator.contains(from, to, f, t) && f != t) {
                    from.add(f);
                    to.add(t);
                    activating.add(Math.random() < act);
                } else {
                    --c;
                }
                if (++tries >= 1000) {
                    deferred = perStep + deferred - (c + 1);
                    break;
                }
                if (c + 1 == perStep + deferred) {
                    deferred = 0;
                }
                ++c;
            }
            ++i;
        }
        while (from.size() > connectionsWithoutAnyLoops) {
            if (--failsafe == 0) {
                return null;
            }
            int deleted = generator.nextInt(from.size());
            if (!NetworkGenerator.noDisconnections(from, to, from.get(deleted), to.get(deleted), size)) continue;
            from.remove(deleted);
            to.remove(deleted);
            activating.remove(deleted);
        }
        i = 0;
        while (i < nonInputLoops) {
            if (--failsafe == 0) {
                return null;
            }
            int otherNode = Math.random() < 0.5 ? from.get(generator.nextInt(from.size())).intValue() : to.get(generator.nextInt(from.size())).intValue();
            if (!NetworkGenerator.contains(from, to, otherNode, otherNode) && !NetworkGenerator.isInput(to, otherNode)) {
                from.add(otherNode);
                to.add(otherNode);
                activating.add(true);
            } else {
                --i;
            }
            ++i;
        }
        if (addInputLoops) {
            i = 0;
            while (i < size) {
                if (NetworkGenerator.isInput(to, i)) {
                    from.add(i);
                    to.add(i);
                    activating.add(true);
                }
                ++i;
            }
        }
        return NetworkGenerator.constructNetwork(from, to, activating, size);
    }

    public static RegulatoryNetwork constructNetwork(ArrayList<Integer> from, ArrayList<Integer> to, ArrayList<Boolean> activating, int size) {
        NetworkNode[] nodes = new NetworkNode[size];
        DoubleValue timeIndex = new DoubleValue(0.0);
        int i = 0;
        while (i < size) {
            ArrayList<Integer> connections = new ArrayList<Integer>();
            ArrayList<Boolean> act = new ArrayList<Boolean>();
            int j = 0;
            while (j < to.size()) {
                if (to.get(j) == i) {
                    connections.add(from.get(j));
                    act.add(activating.get(j));
                }
                ++j;
            }
            boolean[] actarray = new boolean[act.size()];
            int j2 = 0;
            while (j2 < act.size()) {
                actarray[j2] = (Boolean)act.get(j2);
                ++j2;
            }
            Connection[] connection = new Connection[act.size()];
            int j3 = 0;
            while (j3 < act.size()) {
                connection[j3] = new Connection((Integer)connections.get(j3), new Point2D.Double[0]);
                ++j3;
            }
            ActivatorInhibitorFunction function = new ActivatorInhibitorFunction(actarray);
            nodes[i] = new NetworkNode("n" + String.valueOf(i), function, connection, new Rectangle2D.Double(), 0.0, timeIndex);
            ++i;
        }
        return new RegulatoryNetwork(nodes, timeIndex);
    }

    public static boolean contains(ArrayList<Integer> from, ArrayList<Integer> to, int f, int t) {
        int i = 0;
        while (i < from.size()) {
            if (from.get(i) == f && to.get(i) == t) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isConnected(ArrayList<Integer> from, ArrayList<Integer> to, int size) {
        boolean[] connected = new boolean[size];
        connected[0] = true;
        boolean change = true;
        while (change) {
            change = false;
            int i = 0;
            while (i < from.size()) {
                if (connected[from.get(i)] && !connected[to.get(i)]) {
                    connected[to.get((int)i).intValue()] = true;
                    change = true;
                }
                if (connected[to.get(i)] && !connected[from.get(i)]) {
                    connected[from.get((int)i).intValue()] = true;
                    change = true;
                }
                ++i;
            }
        }
        boolean[] blArray = connected;
        int n = connected.length;
        int n2 = 0;
        while (n2 < n) {
            boolean c = blArray[n2];
            if (!c) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean noDisconnections(ArrayList<Integer> from, ArrayList<Integer> to, int f, int t, int size) {
        ArrayList fromCopy = (ArrayList)from.clone();
        ArrayList toCopy = (ArrayList)to.clone();
        int i = 0;
        while (i < from.size()) {
            if (from.get(i) == f && to.get(i) == t) {
                fromCopy.remove(i);
                toCopy.remove(i);
            }
            ++i;
        }
        return NetworkGenerator.isConnected(fromCopy, toCopy, size);
    }

    public static boolean isInput(ArrayList<Integer> to, int node) {
        for (int i : to) {
            if (i != node) continue;
            return false;
        }
        return true;
    }
}

