/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.treebf;

import java.util.LinkedList;
import jimena.binarybf.treebf.TreeNode;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class InputNode
extends TreeNode {
    private static final long serialVersionUID = 5141676157409773471L;
    private int position;

    public InputNode(int position) {
        this.position = position;
    }

    public InputNode(int position, boolean disabled) {
        this.position = position;
        this.setDisabled(disabled);
    }

    @Override
    public double interpolateBooleCube(double[] inputs) {
        if (this.isDisabled()) {
            throw new ArithmeticException("A unary disabled node may not be evaluated.");
        }
        return inputs[this.position];
    }

    @Override
    public boolean eval(boolean[] inputs) {
        if (this.isDisabled()) {
            throw new ArithmeticException("A unary disabled node may not be evaluated.");
        }
        return inputs[this.position];
    }

    @Override
    public int getMinArity() {
        return this.position + 1;
    }

    @Override
    protected boolean isCyclic(LinkedList<TreeNode> predecessors) {
        return false;
    }

    @Override
    public TreeNode clone() {
        return new InputNode(this.position, this.isDisabled());
    }

    @Override
    protected BDD createBDD(BDD[] inputs, BDDFactory bddFactory) {
        if (this.isDisabled()) {
            throw new ArithmeticException("A unary disabled node may not be evaluated.");
        }
        return inputs[this.position];
    }

    @Override
    public String toString() {
        return String.valueOf(this.position);
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public void disableConnection(int position) {
        if (this.position == position) {
            this.setDisabled(true);
        }
    }

    @Override
    public String getFunctionString(String[] nodeNames, boolean odefyCompatible) {
        if (this.isDisabled()) {
            throw new ArithmeticException("A unary disabled node may not be evaluated.");
        }
        return nodeNames[this.position];
    }
}

