/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.treebf;

import java.util.ArrayList;
import java.util.List;
import jimena.binarybf.treebf.ANDBinaryNode;
import jimena.binarybf.treebf.ConstantNode;
import jimena.binarybf.treebf.NotNode;
import jimena.binarybf.treebf.ORBinaryNode;
import jimena.binarybf.treebf.TreeNode;

public class TreeNodeLib {
    public static TreeNode getActInhibitTree(List<TreeNode> activators, List<TreeNode> inhibitors) {
        if (activators == null || inhibitors == null) {
            throw new NullPointerException("Provide two empty arrays instead of null to create a constant-false tree");
        }
        TreeNode activatorSubtree = TreeNodeLib.getOrTree(activators);
        TreeNode inhibitorSubtree = TreeNodeLib.getAndTree(TreeNodeLib.getNegatedTrees(inhibitors));
        if (activators.size() == 0) {
            return inhibitorSubtree;
        }
        if (inhibitors.size() == 0) {
            return activatorSubtree;
        }
        return new ANDBinaryNode(activatorSubtree, inhibitorSubtree);
    }

    public static ArrayList<TreeNode> getNegatedTrees(List<TreeNode> treeNodes) {
        if (treeNodes == null) {
            throw new NullPointerException();
        }
        ArrayList<TreeNode> negatedNodes = new ArrayList<TreeNode>();
        for (TreeNode treeNode : treeNodes) {
            negatedNodes.add(new NotNode(treeNode));
        }
        return negatedNodes;
    }

    public static TreeNode getAndTree(List<TreeNode> treeNodes) {
        if (treeNodes == null) {
            throw new NullPointerException("Provide an empty array instead of null to create the constant true tree");
        }
        if (treeNodes.size() == 0) {
            return new ConstantNode(true);
        }
        TreeNode currentRoot = treeNodes.get(0);
        int i = 1;
        while (i < treeNodes.size()) {
            currentRoot = new ANDBinaryNode(currentRoot, treeNodes.get(i));
            ++i;
        }
        return currentRoot;
    }

    public static TreeNode getOrTree(List<TreeNode> treeNodes) {
        if (treeNodes == null) {
            throw new NullPointerException("Provide an empty array instead of null to create the constant false tree");
        }
        if (treeNodes.size() == 0) {
            return new ConstantNode(true);
        }
        TreeNode currentRoot = treeNodes.get(0);
        int i = 1;
        while (i < treeNodes.size()) {
            currentRoot = new ORBinaryNode(currentRoot, treeNodes.get(i));
            ++i;
        }
        return currentRoot;
    }
}

