/*
 * Decompiled with CFR 0.152.
 */
package jimena.binaryrn;

import java.awt.geom.Point2D;
import java.io.Serializable;

public class Connection
implements Serializable {
    private static final long serialVersionUID = -9117385978236315486L;
    private int source;
    private Point2D.Double pathOrigin;
    private Point2D.Double pathTarget;
    private Point2D.Double[] path;

    public Connection(int source, Point2D.Double[] path, Point2D.Double pathOrigin, Point2D.Double pathTarget) {
        if (path == null || pathOrigin == null || pathTarget == null) {
            throw new NullPointerException();
        }
        Point2D.Double[] doubleArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Double p = doubleArray[n2];
            if (p == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
        if (source < 0) {
            throw new IllegalArgumentException();
        }
        this.source = source;
        this.path = path;
        this.pathOrigin = pathOrigin;
        this.pathTarget = pathTarget;
    }

    public Connection(int source, Point2D.Double[] path) {
        this(source, path, new Point2D.Double(), new Point2D.Double());
    }

    public Connection(int source) {
        this(source, new Point2D.Double[0]);
    }

    public int getSource() {
        return this.source;
    }

    public Point2D.Double[] getPath() {
        return this.path;
    }

    public String toString() {
        return "Inp: " + this.source;
    }

    public Point2D.Double getPathOrigin() {
        return this.pathOrigin;
    }

    public void setPathOrigin(Point2D.Double pathOrigin) {
        this.pathOrigin = pathOrigin;
    }

    public Point2D.Double getPathTarget() {
        return this.pathTarget;
    }

    public void setPathTarget(Point2D.Double pathTarget) {
        this.pathTarget = pathTarget;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public Connection clone() {
        Point2D.Double[] copiedPath = new Point2D.Double[this.path.length];
        int i = 0;
        while (i < copiedPath.length) {
            copiedPath[i] = (Point2D.Double)this.path[i].clone();
            ++i;
        }
        return new Connection(this.source, copiedPath, (Point2D.Double)this.pathOrigin.clone(), (Point2D.Double)this.pathTarget.clone());
    }
}

