/*
 * Decompiled with CFR 0.152.
 */
package jimena.binaryrn;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import jimena.binarybf.actinhibitf.ActivatorInhibitorFunction;
import jimena.binaryrn.Connection;
import jimena.binaryrn.NetworkConnection;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetworkLib;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.calculationparameters.SimulationParameters;
import jimena.libs.BDDLib;
import jimena.libs.DoubleValue;
import jimena.libs.MathLib;
import jimena.libs.StandardNumberFormat;
import jimena.libs.StringLib;
import jimena.simulation.CalculationController;
import jimena.simulation.Simulator;
import jimena.simulation.StableSteadyState;
import jimena.simulationmethods.SimulationMethod;
import jimena.sssearcher.SSSearchResult;
import jimena.sssearcher.SSSearcher;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class RegulatoryNetwork
implements Serializable {
    private static final long serialVersionUID = -3637940236128103506L;
    private NetworkNode[] networkNodes = new NetworkNode[0];
    private transient HashSet<RegulatoryNetworkObserver> observers = new HashSet();
    private DoubleValue timeIndex = new DoubleValue(0.0);

    private static void checkParameters(double stabilityMaxDiff, double stabilityMinTime, int simulationsPerConnection, SimulationMethod method, double dt, double maxt) {
        if (stabilityMaxDiff < 0.0 || stabilityMinTime <= 0.0 || simulationsPerConnection <= 0 || dt <= 0.0 || maxt <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (method == null) {
            throw new NullPointerException();
        }
    }

    public RegulatoryNetwork() {
    }

    public RegulatoryNetwork(NetworkNode[] networkNodes, DoubleValue timeIndex) {
        if (networkNodes == null || timeIndex == null) {
            throw new NullPointerException();
        }
        this.networkNodes = networkNodes;
        this.observers = new HashSet();
        this.timeIndex = timeIndex;
    }

    public void addNullMutation(int node, int connection) {
        try {
            this.networkNodes[node].getConnections()[connection].toString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("The specified connection does not exist in the network.");
        }
        this.networkNodes[node].getFunction().disableConnection(connection);
    }

    public void addNullMutation(List<NetworkConnection> connections) {
        for (NetworkConnection connection : connections) {
            this.addNullMutation(connection);
        }
    }

    public void addNullMutation(NetworkConnection connection) {
        this.addNullMutation(connection.getNode(), connection.getPosition());
    }

    public void addObserver(RegulatoryNetworkObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers.add(observer);
    }

    public RegulatoryNetwork cloneClean() {
        DoubleValue timeIndex = new DoubleValue(0.0);
        NetworkNode[] copiedNetworkNodes = new NetworkNode[this.size()];
        int i = 0;
        while (i < copiedNetworkNodes.length) {
            copiedNetworkNodes[i] = this.networkNodes[i].clone(timeIndex, false);
            ++i;
        }
        return new RegulatoryNetwork(copiedNetworkNodes, timeIndex);
    }

    public StableSteadyState stableStateSearcher(double[] startValues, ConvergenceParameters parameters) {
        RegulatoryNetwork searchingNetwork = this.cloneClean();
        searchingNetwork.setValues(startValues);
        return new StableSteadyState(searchingNetwork, parameters);
    }

    public double cycleIndex(int node, boolean favorSmallCycles) {
        if (node < 0 || node > this.networkNodes.length) {
            throw new IllegalArgumentException("The specified node does not exist in the network.");
        }
        LinkedList<Integer> visitedNodes = new LinkedList<Integer>();
        visitedNodes.add(node);
        return this.cycleIndex(visitedNodes, node, favorSmallCycles);
    }

    private double cycleIndex(LinkedList<Integer> visitedNodes, int node, boolean favorSmallCycles) {
        double result = 0.0;
        for (Integer source : this.networkNodes[node].getConnectionSources()) {
            if (visitedNodes.peekFirst() == source) {
                if (favorSmallCycles) {
                    result += 1.0 / Math.pow(2.0, visitedNodes.size());
                    continue;
                }
                result += 1.0;
                continue;
            }
            if (visitedNodes.contains(source)) continue;
            visitedNodes.add(source);
            result += this.cycleIndex(visitedNodes, source, favorSmallCycles);
            visitedNodes.removeLast();
        }
        return result;
    }

    public synchronized ArrayList<byte[]> discreteStableSteadyStates() {
        BDDFactory bddFactory = BDDLib.getBDDFactory();
        bddFactory.setVarNum(this.size());
        BDD[] nodes = new BDD[this.size()];
        int i = 0;
        while (i < this.size()) {
            nodes[i] = bddFactory.ithVar(i);
            ++i;
        }
        BDD network = bddFactory.one();
        int i2 = 0;
        while (i2 < this.size()) {
            BDD[] inputs = new BDD[this.networkNodes[i2].getConnections().length];
            int j = 0;
            while (j < this.networkNodes[i2].getConnections().length) {
                inputs[j] = nodes[this.networkNodes[i2].getConnections()[j].getSource()];
                ++j;
            }
            BDD functionBDD = this.networkNodes[i2].getFunction().createBDD(inputs, bddFactory);
            functionBDD = nodes[i2].biimp(functionBDD);
            network.andWith(functionBDD);
            ++i2;
        }
        return MathLib.bddAllsatResultToArray(network.allsat());
    }

    public String exportSQUAD() {
        String result = new String();
        int i = 0;
        while (i < this.networkNodes.length) {
            result = String.valueOf(result) + this.exportSQUAD(i);
            ++i;
        }
        return result;
    }

    public String exportSQUAD(int node) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified node does not exist.");
        }
        String result = new String();
        if (this.networkNodes[node].getFunction() instanceof ActivatorInhibitorFunction) {
            boolean[] activators = ((ActivatorInhibitorFunction)this.networkNodes[node].getFunction()).getActivators();
            int i = 0;
            while (i < this.networkNodes[node].getConnections().length) {
                result = String.valueOf(result) + this.networkNodes[this.networkNodes[node].getConnections()[i].getSource()].getName() + (activators[i] ? " -> " : " -| ") + this.networkNodes[node].getName() + "\n";
                ++i;
            }
        } else {
            throw new IllegalArgumentException("The specified node is not an activator-inhibitor-node.");
        }
        return result;
    }

    public Connection getConnection(NetworkConnection conection) {
        return this.networkNodes[conection.getNode()].getConnections()[conection.getPosition()];
    }

    public TreeSet<Integer> getConnectionPositionsByName(int node, String name) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node was not found in the network.");
        }
        if (name == null) {
            throw new NullPointerException();
        }
        TreeSet<Integer> result = new TreeSet<Integer>();
        int i = 0;
        while (i < this.networkNodes[node].getConnections().length) {
            if (StringLib.equalsTrimmed(this.getConnectionSourceName(node, i), name)) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    public TreeSet<Integer> getConnectionPositionsByName(String target, String source) {
        return this.getConnectionPositionsByName(this.getNodeIndexByName(target), source);
    }

    public ArrayList<NetworkConnection> getConnections() {
        ArrayList<NetworkConnection> result = new ArrayList<NetworkConnection>();
        if (this.getFirstConnection() == null) {
            return result;
        }
        NetworkConnection nextConnection = this.getFirstConnection();
        while (nextConnection != null) {
            result.add(nextConnection);
            nextConnection = this.getNextConnection(nextConnection);
        }
        return result;
    }

    public String[] getConnectionsStrings() {
        if (this.getFirstConnection() == null) {
            return new String[0];
        }
        NetworkConnection nextConnection = this.getFirstConnection();
        String[] result = new String[this.getConnections().size()];
        int index = 0;
        while (nextConnection != null) {
            result[index] = this.getConnectionString(nextConnection);
            nextConnection = this.getNextConnection(nextConnection);
            ++index;
        }
        return result;
    }

    public ArrayList<NetworkConnection> getConnectionsBySource(int fromNode) {
        if (fromNode < 0 || fromNode >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node " + fromNode + " was not found in the network.");
        }
        ArrayList<NetworkConnection> result = new ArrayList<NetworkConnection>();
        if (this.getFirstConnection() == null) {
            return result;
        }
        NetworkConnection nextConnection = this.getFirstConnection();
        while (nextConnection != null) {
            if (this.networkNodes[nextConnection.getNode()].getConnections()[nextConnection.getPosition()].getSource() != fromNode) {
                nextConnection = this.getNextConnection(nextConnection);
                continue;
            }
            result.add(nextConnection);
            nextConnection = this.getNextConnection(nextConnection);
        }
        return result;
    }

    public ArrayList<NetworkConnection> getConnectionsBySourceAndTarget(int fromNode, int toNode) {
        ArrayList<NetworkConnection> result = new ArrayList<NetworkConnection>();
        ArrayList<NetworkConnection> from = this.getConnectionsBySource(fromNode);
        ArrayList<NetworkConnection> to = this.getConnectionsByTarget(toNode);
        block0: for (NetworkConnection connection : from) {
            for (NetworkConnection connection2 : to) {
                if (connection.getNode() != connection2.getNode() || connection.getPosition() != connection2.getPosition()) continue;
                result.add(connection);
                continue block0;
            }
        }
        return result;
    }

    public ArrayList<NetworkConnection> getConnectionsByTarget(int toNode) {
        if (toNode < 0 || toNode >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node was not found in the network.");
        }
        ArrayList<NetworkConnection> result = new ArrayList<NetworkConnection>();
        int i = 0;
        while (i < this.networkNodes[toNode].getConnections().length) {
            result.add(new NetworkConnection(toNode, i));
            ++i;
        }
        return result;
    }

    public int getConnectionSourceIndex(int node, int position) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node was not found in the network.");
        }
        if (node < 0 || position >= this.networkNodes[node].getConnections().length) {
            throw new IllegalArgumentException("The specified input was not found in the node.");
        }
        return this.networkNodes[node].getConnections()[position].getSource();
    }

    public int getConnectionSourceIndex(NetworkConnection connection) {
        return this.getConnectionSourceIndex(connection.getNode(), connection.getPosition());
    }

    public String getConnectionSourceName(int node, int position) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node was not found in the network.");
        }
        if (node < 0 || position >= this.networkNodes[node].getConnections().length) {
            throw new IllegalArgumentException("The specified connection was not found in the node.");
        }
        return this.networkNodes[this.getConnectionSourceIndex(node, position)].getName();
    }

    public String getConnectionSourceName(NetworkConnection connection) {
        return this.getConnectionSourceName(connection.getNode(), connection.getPosition());
    }

    public String getConnectionString(ArrayList<NetworkConnection> connections) {
        String result = "{ ";
        int i = 0;
        while (i < connections.size() - 1) {
            result = String.valueOf(result) + this.getConnectionString(connections.get(i)) + ", ";
            ++i;
        }
        if (connections.size() != 0) {
            result = String.valueOf(result) + this.getConnectionString(connections.get(connections.size() - 1));
        }
        return String.valueOf(result) + " }";
    }

    public String getConnectionString(NetworkConnection connection) {
        return this.getConnectionString(connection, "->");
    }

    public String getConnectionString(NetworkConnection connection, String sep) {
        return "\"" + this.networkNodes[this.networkNodes[connection.getNode()].getConnections()[connection.getPosition()].getSource()].getName() + "\"" + sep + "\"" + this.networkNodes[connection.getNode()].getName() + "\"";
    }

    public NetworkConnection getFirstConnection() {
        int i = 0;
        while (i < this.networkNodes.length) {
            if (this.networkNodes[i].getConnections().length != 0) {
                return new NetworkConnection(i, 0);
            }
            ++i;
        }
        return null;
    }

    public String getFunctionString(int node) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified node is not valid.");
        }
        String[] nodeNames = this.getNodeNames();
        String[] connectionNodeNames = new String[this.networkNodes[node].getConnections().length];
        int j = 0;
        while (j < this.networkNodes[node].getConnections().length) {
            connectionNodeNames[j] = nodeNames[this.networkNodes[node].getConnections()[j].getSource()];
            ++j;
        }
        return String.valueOf(this.networkNodes[node].getName()) + " = " + this.networkNodes[node].getFunction().getFunctionString(connectionNodeNames, false);
    }

    public String getFunctionStringOdefyCompatible(int node) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified node is not valid.");
        }
        String[] nodeNames = this.getNodeNames();
        String[] connectionNodeNames = new String[this.networkNodes[node].getConnections().length];
        int j = 0;
        while (j < this.networkNodes[node].getConnections().length) {
            connectionNodeNames[j] = nodeNames[this.networkNodes[node].getConnections()[j].getSource()];
            ++j;
        }
        return "'" + this.networkNodes[node].getName() + " = " + this.networkNodes[node].getFunction().getFunctionString(connectionNodeNames, true) + "'";
    }

    public NetworkNode[] getNetworkNodes() {
        return this.networkNodes;
    }

    public String getNetworkString() {
        String result = new String();
        int i = 0;
        while (i < this.networkNodes.length) {
            result = String.valueOf(result) + "\n" + this.getFunctionString(i);
            ++i;
        }
        return result;
    }

    public String getNetworkStringOdefyCompatible() {
        String result = "expr = {";
        int i = 0;
        while (i < this.networkNodes.length) {
            result = String.valueOf(result) + "\n" + this.getFunctionStringOdefyCompatible(i);
            if (i != this.networkNodes.length - 1) {
                result = String.valueOf(result) + ", ";
            }
            ++i;
        }
        result = String.valueOf(result) + "}";
        return result;
    }

    public NetworkConnection getNextConnection(int node, int position) {
        if (!this.isValidConnection(node, position)) {
            throw new IllegalArgumentException("The specified connection does not exist.(" + node + ", " + position + ")");
        }
        if (position + 1 >= this.networkNodes[node].getConnections().length) {
            int i = node + 1;
            while (i < this.networkNodes.length) {
                if (this.networkNodes[i].getConnections().length != 0) {
                    return new NetworkConnection(i, 0);
                }
                ++i;
            }
            return null;
        }
        return new NetworkConnection(node, position + 1);
    }

    public NetworkConnection getNextConnection(NetworkConnection connections) {
        return this.getNextConnection(connections.getNode(), connections.getPosition());
    }

    public NetworkConnection getNextConnectionWrap(int node, int position) {
        if (!this.isValidConnection(node, position)) {
            throw new IllegalArgumentException("The specified connection does not exist.(" + node + ", " + position + ")");
        }
        if (position + 1 >= this.networkNodes[node].getConnections().length) {
            int i = node + 1;
            while (i < this.networkNodes.length) {
                if (this.networkNodes[i].getConnections().length != 0) {
                    return new NetworkConnection(i, 0);
                }
                ++i;
            }
            return this.getFirstConnection();
        }
        return new NetworkConnection(node, position + 1);
    }

    public NetworkConnection getNextConnectionWrap(NetworkConnection connection) {
        return this.getNextConnectionWrap(connection.getNode(), connection.getPosition());
    }

    public NetworkNode getNodeByName(String name) {
        return this.networkNodes[this.getNodeIndexByName(name)];
    }

    public int getNodeIndexByName(String name) {
        int i = 0;
        while (i < this.networkNodes.length) {
            if (StringLib.equalsTrimmed(this.networkNodes[i].getName(), name)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Node " + name + " not found.");
    }

    public String[] getNodeNames() {
        String[] names = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            names[i] = this.networkNodes[i].getName();
            ++i;
        }
        return names;
    }

    public HashSet<RegulatoryNetworkObserver> getObservers() {
        return this.observers;
    }

    public DoubleValue getTimeIndex() {
        return this.timeIndex;
    }

    public double[] getValues() {
        double[] result = new double[this.size()];
        int i = 0;
        while (i < this.size()) {
            result[i] = this.networkNodes[i].getValue();
            ++i;
        }
        return result;
    }

    public double[] getValues(double[] target) {
        int i = 0;
        while (i < this.size()) {
            target[i] = this.networkNodes[i].getValue();
            ++i;
        }
        return target;
    }

    public boolean hasLoop(int node) {
        return this.getConnectionsBySourceAndTarget(node, node).size() != 0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isLoop(NetworkConnection connection) {
        return connection.getNode() == this.getConnectionSourceIndex(connection);
    }

    public boolean isValidConnection(int node, int position) {
        return node >= 0 && node < this.networkNodes.length && position >= 0 && position < this.networkNodes[node].getConnections().length;
    }

    public boolean isValidConnection(NetworkConnection connection) {
        return this.isValidConnection(connection.getNode(), connection.getPosition());
    }

    public void loadNetwork(RegulatoryNetwork storedNetwork) {
        this.networkNodes = storedNetwork.getNetworkNodes();
        this.timeIndex = storedNetwork.getTimeIndex();
        this.notifyObserversOfChangedNetwork();
    }

    public void loadYEdFile(File file) {
        this.timeIndex = new DoubleValue(0.0);
        try {
            this.networkNodes = RegulatoryNetworkLib.parseYEdFile(file, this.timeIndex);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.notifyObserversOfChangedNetwork();
    }

    public void log() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.log();
            ++n2;
        }
    }

    public void makeDiscrete() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.makeDiscrete();
            ++n2;
        }
    }

    public void notifyObserversOfChangedNetwork() {
        for (RegulatoryNetworkObserver observer : this.observers) {
            observer.notifyNetworkChanged();
        }
    }

    public void notifyObserversOfChangedValues() {
        for (RegulatoryNetworkObserver observer : this.observers) {
            observer.notifyValuesChanged();
        }
    }

    public int numberOfInputs() {
        int counter = 0;
        int i = 0;
        while (i < this.size()) {
            if (this.getConnectionsByTarget(i).size() == 0) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public int numberOfLoops() {
        int counter = 0;
        int i = 0;
        while (i < this.networkNodes.length) {
            int j = 0;
            while (j < this.networkNodes[i].getConnections().length) {
                if (this.networkNodes[i].getConnections()[j].getSource() == i) {
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        return counter;
    }

    public void printNetwork() {
        System.out.println(this.getNetworkStringOdefyCompatible());
    }

    public void printNetworkState() {
        int padding = StringLib.maxStringLength(this.getNodeNames());
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            System.out.println(String.valueOf(StringLib.padLeft(node.getName(), padding)) + ": " + node.getValue());
            ++n2;
        }
    }

    public void removeAllPerturbations() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.getPerturbations().clear();
            ++n2;
        }
    }

    public void removeObserver(RegulatoryNetworkObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers.remove(observer);
    }

    public void reset() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.reset();
            node.resetLog();
            ++n2;
        }
        this.timeIndex.setValue(0.0);
        this.notifyObserversOfChangedValues();
    }

    public void restore() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.getFunction().restore();
            ++n2;
        }
    }

    public void setNames(ArrayList<String> names) {
        this.setNames(names.toArray(new String[names.size()]));
    }

    public void setNames(String[] names) {
        if (names.length != this.networkNodes.length) {
            throw new IllegalArgumentException("The arrays must be of equal size.");
        }
        int i = 0;
        while (i < names.length) {
            if (names[i] == null) {
                throw new IllegalArgumentException("A node name may not be null.");
            }
            int j = i + 1;
            while (j < names.length) {
                if (names[i].equals(names[j])) {
                    throw new IllegalArgumentException("All node names must be different.");
                }
                ++j;
            }
            this.networkNodes[i].setName(names[i]);
            ++i;
        }
    }

    public void setNetworkNodes(NetworkNode[] networkNodes) {
        this.networkNodes = networkNodes;
    }

    public void setObservers(HashSet<RegulatoryNetworkObserver> observers) {
        if (observers == null) {
            throw new NullPointerException();
        }
        this.observers = observers;
    }

    public TreeSet<Integer> setOfAllNodeIndices() {
        TreeSet<Integer> allIndices = new TreeSet<Integer>();
        int i = 0;
        while (i < this.size()) {
            allIndices.add(i);
            ++i;
        }
        return allIndices;
    }

    public void setValues(double[] values) {
        int i = 0;
        while (i < values.length) {
            this.networkNodes[i].setValue(values[i]);
            ++i;
        }
    }

    public void simulate(SimulationMethod method, double dt, double maxT, double maxSpeed, double minSimulationTimeBetweenLogs, CalculationController calculationController) {
        this.simulate(new SimulationParameters(method, dt, maxT, calculationController), maxSpeed, minSimulationTimeBetweenLogs);
    }

    public void simulate(SimulationParameters parameters, double maxSpeed, double minSimulationTimeBetweenLogs) {
        Simulator simulator = new Simulator(parameters, this, maxSpeed, minSimulationTimeBetweenLogs);
        simulator.run();
    }

    public int size() {
        return this.networkNodes.length;
    }

    public void sortNetworkNodes() {
        boolean change = true;
        while (change) {
            change = false;
            int i = 0;
            while (i < this.size() - 1) {
                if (this.getNetworkNodes()[i + 1].getName().compareTo(this.getNetworkNodes()[i].getName()) < 0) {
                    change = true;
                    NetworkNode tempNode = this.getNetworkNodes()[i + 1];
                    this.getNetworkNodes()[i + 1] = this.getNetworkNodes()[i];
                    this.getNetworkNodes()[i] = tempNode;
                    int j = 0;
                    while (j < this.size()) {
                        int k = 0;
                        while (k < this.getNetworkNodes()[j].getConnections().length) {
                            if (this.getNetworkNodes()[j].getConnections()[k].getSource() == i) {
                                this.getNetworkNodes()[j].getConnections()[k].setSource(i + 1);
                            } else if (this.getNetworkNodes()[j].getConnections()[k].getSource() == i + 1) {
                                this.getNetworkNodes()[j].getConnections()[k].setSource(i);
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.notifyObserversOfChangedNetwork();
    }

    public double[] stableSteadyState(double[] startValues, ConvergenceParameters parameters) throws Exception {
        StableSteadyState stableSteadyState = this.stableStateSearcher(startValues, parameters);
        return stableSteadyState.call().getResult();
    }

    public ArrayList<double[]> stableSteadyStates(ConvergenceParameters parameters, long maxTime, SSSearcher ssSearcher) {
        return this.stableSteadyStatesWithBasins(parameters, maxTime, ssSearcher).getResults();
    }

    public ArrayList<double[]> stableSteadyStates(long numberOfStarts, ConvergenceParameters parameters, SSSearcher ssSearcher) {
        return ssSearcher.searchSSStates(this, numberOfStarts, parameters).getResults();
    }

    public SSSearchResult stableSteadyStatesWithBasins(ConvergenceParameters parameters, long maxTime, SSSearcher ssSearcher) {
        return ssSearcher.searchSSStates(this, parameters, maxTime);
    }

    public SSSearchResult stableSteadyStatesWithBasins(long numberOfStarts, ConvergenceParameters parameters, SSSearcher ssSearcher) {
        return ssSearcher.searchSSStates(this, numberOfStarts, parameters);
    }

    public int sumOfConnections() {
        int numberOfConnections = 0;
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            numberOfConnections += node.getConnections().length;
            ++n2;
        }
        return numberOfConnections;
    }

    public void switchConnections(NetworkConnection connection1, NetworkConnection connection3) {
        int temp = this.networkNodes[connection1.getNode()].getConnections()[connection1.getPosition()].getSource();
        this.networkNodes[connection1.getNode()].getConnections()[connection1.getPosition()].setSource(this.networkNodes[connection3.getNode()].getConnections()[connection3.getPosition()].getSource());
        this.networkNodes[connection3.getNode()].getConnections()[connection3.getPosition()].setSource(temp);
    }

    public void switchRandomConnections(boolean preserveLoops) {
        ArrayList<NetworkConnection> connections = this.getConnections();
        int numberOfLoops = this.numberOfLoops();
        while (true) {
            int rnd1 = (int)(Math.random() * (double)(connections.size() - 1));
            int rnd2 = (int)(Math.random() * (double)(connections.size() - 1));
            this.switchConnections(connections.get(rnd1), connections.get(rnd2));
            if (numberOfLoops == this.numberOfLoops() || !preserveLoops) break;
            this.switchConnections(connections.get(rnd1), connections.get(rnd2));
        }
    }

    public void switchRandomConnections(int repetitions, boolean preserveLoops) {
        int i = 0;
        while (i < repetitions) {
            this.switchRandomConnections(preserveLoops);
            ++i;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        double[] dArray = this.getValues();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double o = dArray[n2];
            result.append(String.valueOf(StandardNumberFormat.SHORTFIXEDNUMBERFORMAT.format(o)) + " | ");
            ++n2;
        }
        return result.toString();
    }
}

