/*
 * Decompiled with CFR 0.152.
 */
package jimena.binaryrn;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jimena.binarybf.actinhibitf.ActivatorInhibitorFunction;
import jimena.binarybf.treebf.ConstantNode;
import jimena.binarybf.treebf.InputNode;
import jimena.binarybf.treebf.NotNode;
import jimena.binarybf.treebf.TreeBooleanFunction;
import jimena.binarybf.treebf.TreeNode;
import jimena.binarybf.treebf.TreeNodeLib;
import jimena.binaryrn.Connection;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.TempNode;
import jimena.libs.DoubleValue;
import jimena.libs.PatternLib;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegulatoryNetworkLib {
    /*
     * WARNING - void declaration
     */
    public static NetworkNode[] parseYEdFile(File file, DoubleValue timeIndex) throws Exception {
        if (!file.exists()) {
            throw new IOException("The specified graphML file does not exist.");
        }
        if (timeIndex == null) {
            throw new NullPointerException();
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        doc.getDocumentElement().normalize();
        Element root = doc.getDocumentElement();
        Node graph = RegulatoryNetworkLib.getNamedChildNode(root, "graph");
        LinkedList<TempNode> tempNodesLinked = new LinkedList<TempNode>();
        int i = 0;
        while (i < graph.getChildNodes().getLength()) {
            Node graphelement = graph.getChildNodes().item(i);
            if (graphelement.getNodeName().equals("node")) {
                Node graphelementData = RegulatoryNetworkLib.getKeyedDataNode(graphelement, "d6").getChildNodes().item(1);
                if (graphelementData == null) {
                    graphelementData = RegulatoryNetworkLib.getKeyedDataNode(graphelement, "d7").getChildNodes().item(1);
                }
                String id = graphelement.getAttributes().getNamedItem("id").getNodeValue();
                Object label = RegulatoryNetworkLib.getNamedChildNode(graphelementData, "y:NodeLabel").getFirstChild().getTextContent();
                if (((String)label).matches("\\s*")) {
                    label = id;
                }
                Node positionNode = RegulatoryNetworkLib.getNamedChildNode(graphelementData, "y:Geometry");
                double x = Double.valueOf(positionNode.getAttributes().getNamedItem("x").getNodeValue());
                double y = Double.valueOf(positionNode.getAttributes().getNamedItem("y").getNodeValue());
                double h = Double.valueOf(positionNode.getAttributes().getNamedItem("height").getNodeValue());
                double w = Double.valueOf(positionNode.getAttributes().getNamedItem("width").getNodeValue());
                Rectangle2D.Double double_ = new Rectangle2D.Double(x, y, w, h);
                boolean isRealNode = RegulatoryNetworkLib.getGateType((String)label) == null;
                double initialValue = 0.0;
                try {
                    String initialValueString = RegulatoryNetworkLib.getKeyedDataNode(graphelement, "d5").getTextContent();
                    initialValue = Double.valueOf(initialValueString);
                }
                catch (NumberFormatException initialValueString) {
                }
                catch (NullPointerException initialValueString) {
                    // empty catch block
                }
                tempNodesLinked.add(new TempNode((String)label, id, double_, isRealNode, initialValue));
            }
            ++i;
        }
        ArrayList<TempNode> tempNodes = new ArrayList<TempNode>(tempNodesLinked);
        int i2 = 0;
        while (i2 < tempNodes.size()) {
            int j = 0;
            while (i2 < tempNodes.size()) {
                if (i2 != j && ((TempNode)tempNodes.get(i2)).isRealNode() && ((TempNode)tempNodes.get(i2)).getLabel().equals(((TempNode)tempNodes.get(j)).getLabel())) {
                    throw new IllegalArgumentException("Duplicate node found.");
                }
                ++i2;
            }
            ++i2;
        }
        HashMap<String, Integer> mapIdToNodeIndex = new HashMap<String, Integer>();
        int pos = 0;
        for (TempNode node : tempNodes) {
            mapIdToNodeIndex.put(node.getID(), pos);
            ++pos;
        }
        LinkedList[] linesLinked = new LinkedList[tempNodes.size()];
        LinkedList[] linesIsNegatedLinked = new LinkedList[tempNodes.size()];
        int i3 = 0;
        while (i3 < linesLinked.length) {
            linesIsNegatedLinked[i3] = new LinkedList();
            linesLinked[i3] = new LinkedList();
            ++i3;
        }
        int i4 = 0;
        while (i4 < graph.getChildNodes().getLength()) {
            Node graphelement = graph.getChildNodes().item(i4);
            if (graphelement.getNodeName().equals("edge")) {
                Node graphelementData = RegulatoryNetworkLib.getKeyedDataNode(graphelement, "d10").getChildNodes().item(1);
                if (graphelementData == null) {
                    graphelementData = RegulatoryNetworkLib.getKeyedDataNode(graphelement, "d11").getChildNodes().item(1);
                }
                int target = (Integer)mapIdToNodeIndex.get(graphelement.getAttributes().getNamedItem("target").getNodeValue());
                int source = (Integer)mapIdToNodeIndex.get(graphelement.getAttributes().getNamedItem("source").getNodeValue());
                LinkedList<Point2D.Double> pointsLinked = new LinkedList<Point2D.Double>();
                Node pointsNode = RegulatoryNetworkLib.getNamedChildNode(graphelementData, "y:Path");
                int j = 0;
                while (j < pointsNode.getChildNodes().getLength()) {
                    if (pointsNode.getChildNodes().item(j).getNodeName().equals("y:Point")) {
                        double x = Double.valueOf(pointsNode.getChildNodes().item(j).getAttributes().getNamedItem("x").getNodeValue());
                        double y = Double.valueOf(pointsNode.getChildNodes().item(j).getAttributes().getNamedItem("y").getNodeValue());
                        pointsLinked.add(new Point2D.Double(x, y));
                    }
                    ++j;
                }
                Point2D.Double[] points = new Point2D.Double[pointsLinked.size()];
                pointsLinked.toArray(points);
                double pathOriginX = Double.valueOf(pointsNode.getAttributes().getNamedItem("sx").getNodeValue());
                double pathOriginY = Double.valueOf(pointsNode.getAttributes().getNamedItem("sy").getNodeValue());
                Point2D.Double pathOrigin = new Point2D.Double(pathOriginX, pathOriginY);
                double pathTargetX = Double.valueOf(pointsNode.getAttributes().getNamedItem("tx").getNodeValue());
                double pathTargetY = Double.valueOf(pointsNode.getAttributes().getNamedItem("ty").getNodeValue());
                Point2D.Double pathTarget = new Point2D.Double(pathTargetX, pathTargetY);
                linesLinked[target].add(new Connection(source, points, pathOrigin, pathTarget));
                Node arrowsNode = RegulatoryNetworkLib.getNamedChildNode(graphelementData, "y:Arrows");
                if (arrowsNode.getAttributes().getNamedItem("target").getNodeValue().equals("standard")) {
                    linesIsNegatedLinked[target].add(false);
                } else {
                    linesIsNegatedLinked[target].add(true);
                }
            }
            ++i4;
        }
        Connection[][] lines = new Connection[tempNodes.size()][];
        Boolean[][] linesIsNegated = new Boolean[tempNodes.size()][];
        int i42 = 0;
        while (i42 < lines.length) {
            lines[i42] = new Connection[linesLinked[i42].size()];
            linesLinked[i42].toArray(lines[i42]);
            linesIsNegated[i42] = new Boolean[linesIsNegatedLinked[i42].size()];
            linesIsNegatedLinked[i42].toArray(linesIsNegated[i42]);
            ++i42;
        }
        HashMap<Integer, Integer> mapNodeIndexToRealNodeIndex = new HashMap<Integer, Integer>();
        pos = 0;
        int i5 = 0;
        while (i5 < tempNodes.size()) {
            if (((TempNode)tempNodes.get(i5)).isRealNode()) {
                mapNodeIndexToRealNodeIndex.put(i5, pos);
                ++pos;
            }
            ++i5;
        }
        LinkedList<NetworkNode> networkNodesLinked = new LinkedList<NetworkNode>();
        int i6 = 0;
        while (i6 < tempNodes.size()) {
            if (((TempNode)tempNodes.get(i6)).isRealNode()) {
                boolean actInhibitPossible = true;
                Connection[] connectionArray = lines[i6];
                int pathOriginX = connectionArray.length;
                int points = 0;
                while (points < pathOriginX) {
                    Connection input = connectionArray[points];
                    if (!((TempNode)tempNodes.get(input.getSource())).isRealNode()) {
                        actInhibitPossible = false;
                        break;
                    }
                    ++points;
                }
                if (actInhibitPossible) {
                    void var22_41;
                    boolean[] activators = new boolean[linesIsNegated[i6].length];
                    int j = 0;
                    while (j < activators.length) {
                        activators[j] = linesIsNegated[i6][j] == false;
                        ++j;
                    }
                    ActivatorInhibitorFunction function = new ActivatorInhibitorFunction(activators);
                    Connection[] inputsArray = new Connection[lines[i6].length];
                    boolean bl = false;
                    while (var22_41 < inputsArray.length) {
                        Point2D.Double[] path = lines[i6][var22_41].getSource() == i6 ? RegulatoryNetworkLib.cyclePath(tempNodes.get(i6).getRectangle()) : lines[i6][var22_41].getPath();
                        inputsArray[var22_41] = new Connection((Integer)mapNodeIndexToRealNodeIndex.get(lines[i6][var22_41].getSource()), path, lines[i6][var22_41].getPathOrigin(), lines[i6][var22_41].getPathTarget());
                        ++var22_41;
                    }
                    networkNodesLinked.add(new NetworkNode(tempNodes.get(i6).getLabel(), function, inputsArray, tempNodes.get(i6).getRectangle(), tempNodes.get(i6).getInitialValue(), timeIndex));
                } else {
                    if (RegulatoryNetworkLib.isCyclic(new LinkedList<Integer>(), tempNodes, lines, i6)) {
                        throw new IllegalArgumentException("A cycle was found in a boolean subtree of the input graph.");
                    }
                    TreeSet<Integer> inputNodesSet = RegulatoryNetworkLib.getAllConnections(tempNodes, lines, i6);
                    HashMap<Integer, Integer> mapNodeToInputIndex = new HashMap<Integer, Integer>();
                    pos = 0;
                    for (Integer node : inputNodesSet) {
                        mapNodeToInputIndex.put(node, pos);
                        ++pos;
                    }
                    Connection[] inputsArray = new Connection[inputNodesSet.size()];
                    pos = 0;
                    for (Integer n : inputNodesSet) {
                        if (i6 == n) {
                            inputsArray[pos] = new Connection((Integer)mapNodeIndexToRealNodeIndex.get(n), RegulatoryNetworkLib.cyclePath(tempNodes.get(i6).getRectangle()));
                        } else {
                            Connection realNodeInput = null;
                            Connection[] connectionArray2 = lines[i6];
                            int n2 = connectionArray2.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                Connection input = connectionArray2[n3];
                                if (input.getSource() == n.intValue()) {
                                    realNodeInput = input;
                                }
                                ++n3;
                            }
                            inputsArray[pos] = realNodeInput == null ? new Connection((Integer)mapNodeIndexToRealNodeIndex.get(n), new Point2D.Double[0]) : new Connection((Integer)mapNodeIndexToRealNodeIndex.get(n), realNodeInput.getPath(), realNodeInput.getPathOrigin(), realNodeInput.getPathTarget());
                        }
                        ++pos;
                    }
                    TreeNode treeNode = RegulatoryNetworkLib.getTree(mapNodeToInputIndex, tempNodes, lines, linesIsNegated, i6, true);
                    networkNodesLinked.add(new NetworkNode(tempNodes.get(i6).getLabel(), new TreeBooleanFunction(treeNode), inputsArray, tempNodes.get(i6).getRectangle(), tempNodes.get(i6).getInitialValue(), timeIndex));
                }
            }
            ++i6;
        }
        NetworkNode[] networkNodes = new NetworkNode[networkNodesLinked.size()];
        networkNodesLinked.toArray(networkNodes);
        return networkNodes;
    }

    public static Point2D.Double[] cyclePath(Rectangle2D.Double rectangle) {
        Point2D.Double[] path = new Point2D.Double[]{new Point2D.Double(rectangle.getX() - 30.0, rectangle.getY() + rectangle.getHeight() / 2.0 - 20.0), new Point2D.Double(rectangle.getX() - 30.0, rectangle.getY() + rectangle.getHeight() / 2.0 + 20.0)};
        return path;
    }

    private static LogicGateType getGateType(String label) {
        if (PatternLib.PADDEDENTIREANDPATTERN.matcher(label).matches()) {
            return LogicGateType.AND;
        }
        if (PatternLib.PADDEDENTIREORPATTERN.matcher(label).matches()) {
            return LogicGateType.OR;
        }
        if (PatternLib.PADDEDENTIRENOTPATTERN.matcher(label).matches()) {
            return LogicGateType.NOT;
        }
        return null;
    }

    private static TreeNode getTree(HashMap<Integer, Integer> mapNodeToInputIndex, ArrayList<TempNode> tempNodes, Connection[][] lines, Boolean[][] linesIsNegated, int node, boolean firstStep) {
        if (firstStep) {
            LinkedList<TreeNode> activators = new LinkedList<TreeNode>();
            LinkedList<TreeNode> inhibitor = new LinkedList<TreeNode>();
            int i = 0;
            while (i < lines[node].length) {
                if (!linesIsNegated[node][i].booleanValue()) {
                    activators.add(RegulatoryNetworkLib.getTree(mapNodeToInputIndex, tempNodes, lines, linesIsNegated, lines[node][i].getSource(), false));
                } else {
                    inhibitor.add(RegulatoryNetworkLib.getTree(mapNodeToInputIndex, tempNodes, lines, linesIsNegated, lines[node][i].getSource(), false));
                }
                ++i;
            }
            return TreeNodeLib.getActInhibitTree(activators, inhibitor);
        }
        if (!tempNodes.get(node).isRealNode()) {
            LinkedList<TreeNode> inputTrees = new LinkedList<TreeNode>();
            int i = 0;
            while (i < lines[node].length) {
                if (!linesIsNegated[node][i].booleanValue()) {
                    inputTrees.add(RegulatoryNetworkLib.getTree(mapNodeToInputIndex, tempNodes, lines, linesIsNegated, lines[node][i].getSource(), false));
                } else {
                    inputTrees.add(new NotNode(RegulatoryNetworkLib.getTree(mapNodeToInputIndex, tempNodes, lines, linesIsNegated, lines[node][i].getSource(), false)));
                }
                ++i;
            }
            switch (RegulatoryNetworkLib.getGateType(tempNodes.get(node).getLabel())) {
                case AND: {
                    return TreeNodeLib.getAndTree(inputTrees);
                }
                case OR: {
                    return TreeNodeLib.getOrTree(inputTrees);
                }
                case NOT: {
                    if (inputTrees.size() == 0) {
                        return new ConstantNode(false);
                    }
                    if (inputTrees.size() > 1) {
                        throw new IllegalArgumentException("A NOT node with multiple inputs was found.");
                    }
                    return new NotNode(inputTrees.get(0));
                }
            }
            throw new IllegalArgumentException("The type of a logic gate could not be determined.");
        }
        return new InputNode(mapNodeToInputIndex.get(node));
    }

    private static boolean isCyclic(LinkedList<Integer> predecessors, ArrayList<TempNode> tempNodes, Connection[][] lines, int node) {
        if (predecessors.contains(node)) {
            return true;
        }
        boolean result = false;
        predecessors.add(node);
        Connection[] connectionArray = lines[node];
        int n = connectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connection input = connectionArray[n2];
            if (!tempNodes.get(input.getSource()).isRealNode()) {
                result = result || RegulatoryNetworkLib.isCyclic(predecessors, tempNodes, lines, input.getSource());
            }
            ++n2;
        }
        predecessors.removeLast();
        return result;
    }

    private static TreeSet<Integer> getAllConnections(ArrayList<TempNode> tempNodes, Connection[][] lines, int node) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        Connection[] connectionArray = lines[node];
        int n = connectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray[n2];
            if (tempNodes.get(connection.getSource()).isRealNode()) {
                result.add(connection.getSource());
            } else {
                result.addAll(RegulatoryNetworkLib.getAllConnections(tempNodes, lines, connection.getSource()));
            }
            ++n2;
        }
        return result;
    }

    private static Node getNamedChildNode(Node node, String name) {
        int i = 0;
        while (i < node.getChildNodes().getLength()) {
            if (node.getChildNodes().item(i).getNodeName().equals(name)) {
                return node.getChildNodes().item(i);
            }
            ++i;
        }
        return null;
    }

    private static Node getKeyedDataNode(Node node, String key) {
        int i = 0;
        while (i < node.getChildNodes().getLength()) {
            if (node.getChildNodes().item(i).getNodeName().equals("data") && node.getChildNodes().item(i).getAttributes().getNamedItem("key").getNodeValue().equals(key)) {
                return node.getChildNodes().item(i);
            }
            ++i;
        }
        return null;
    }

    private static enum LogicGateType {
        AND,
        OR,
        NOT;

    }
}

