/*
 * Decompiled with CFR 0.152.
 */
package jimena.calculationparameters;

import jimena.simulation.CalculationController;
import jimena.simulationmethods.SimulationMethod;

public class SimulationParameters {
    protected SimulationMethod method;
    protected double dt;
    protected double maxT;
    protected CalculationController calculationController;

    public SimulationParameters(SimulationMethod method, double dt, double maxT, CalculationController calculationController) {
        this.setMethod(method);
        this.setDt(dt);
        this.setMaxT(maxT);
        this.setCalculationController(calculationController);
    }

    public SimulationMethod getMethod() {
        if (this.method == null) {
            throw new NullPointerException();
        }
        return this.method;
    }

    public void setMethod(SimulationMethod method) {
        this.method = method;
    }

    public double getDt() {
        return this.dt;
    }

    public void setDt(double dt) {
        if (dt <= 0.0) {
            throw new IllegalArgumentException("The step width may not be less than 0.");
        }
        this.dt = dt;
    }

    public double getMaxT() {
        return this.maxT;
    }

    public void setMaxT(double maxT) {
        if (maxT <= 0.0) {
            throw new IllegalArgumentException("The simulated time value may not be less than 0.");
        }
        this.maxT = maxT;
    }

    public CalculationController getCalculationController() {
        return this.calculationController;
    }

    public void setCalculationController(CalculationController calculationController) {
        this.calculationController = calculationController;
    }

    public SimulationParameters cloneWithoutController() {
        return new SimulationParameters(this.method.clone(), this.dt, this.maxT, null);
    }
}

