/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.charts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.gui.charts.ChartsPanel;
import jimena.gui.charts.NodeList;
import jimena.gui.main.HasActivatableNodes;
import jimena.libs.TxtFileChooser;

public class ChartsWindow
extends JFrame
implements HasActivatableNodes {
    private static final long serialVersionUID = 4806615342528853734L;
    private NodeList nodeList;

    public ChartsWindow(RegulatoryNetwork network) {
        super("Charts Window");
        this.setIconImage(new ImageIcon("images" + File.separator + "chart16.png").getImage());
        JPanel panel = new JPanel(new BorderLayout());
        JPanel nodesListPanel = new JPanel(new BorderLayout());
        this.nodeList = new NodeList(network);
        JScrollPane nodesScrollPane = new JScrollPane(this.nodeList){
            private static final long serialVersionUID = -628832940977979418L;

            @Override
            public boolean isValidateRoot() {
                return false;
            }
        };
        nodesListPanel.add((Component)nodesScrollPane, "Center");
        JButton exportButton = new JButton("Export Selected", new ImageIcon("images" + File.separator + "save16.png"));
        exportButton.setToolTipText("Exports the data to a text-file.");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StringBuilder result = new StringBuilder();
                NetworkNode[] nodes = ChartsWindow.this.nodeList.getSelectedNodes();
                if (nodes.length == 0) {
                    JOptionPane.showMessageDialog(null, "Please select some nodes in the chartes window. ", "No nodes selected", 0);
                    return;
                }
                result.append("time\t");
                int i = 0;
                while (i < nodes.length) {
                    result.append(String.valueOf(nodes[i].getName()) + "\t");
                    ++i;
                }
                result.append("\n");
                int j = 0;
                while (j < nodes[0].getLog().size()) {
                    result.append(String.valueOf(nodes[0].getLog().get(j).getX()) + "\t");
                    int i2 = 0;
                    while (i2 < nodes.length) {
                        result.append(nodes[i2].getLog().get(j).getY());
                        if (i2 != nodes.length - 1) {
                            result.append("\t");
                        }
                        ++i2;
                    }
                    if (j != nodes[0].getLog().size() - 1) {
                        result.append("\n");
                    }
                    ++j;
                }
                TxtFileChooser.writeToTextFile(result.toString(), ChartsWindow.this);
            }
        });
        nodesListPanel.add((Component)exportButton, "South");
        panel.add((Component)nodesListPanel, "East");
        ChartsPanel chartsPanel = new ChartsPanel(network, this.nodeList);
        panel.add((Component)chartsPanel, "Center");
        this.setContentPane(panel);
        this.setMinimumSize(new Dimension(600, 400));
    }

    @Override
    public void activateNode(int nodeIndex) {
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        int[] nArray = this.nodeList.getSelectedIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer index = nArray[n2];
            selectedIndices.add(index);
            ++n2;
        }
        if (selectedIndices.contains(nodeIndex)) {
            selectedIndices.remove((Object)nodeIndex);
        } else {
            selectedIndices.add(nodeIndex);
        }
        int[] arraySelectedIndices = new int[selectedIndices.size()];
        int i = 0;
        while (i < selectedIndices.size()) {
            arraySelectedIndices[i] = (Integer)selectedIndices.get(i);
            ++i;
        }
        this.nodeList.setSelectedIndices(arraySelectedIndices);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }
}

