/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.charts;

import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.binaryrn.RegulatoryNetworkObserver;

public class NodeList
extends JList<NetworkNode>
implements RegulatoryNetworkObserver {
    private static final long serialVersionUID = -901705554970335446L;
    private RegulatoryNetwork network;

    public NodeList(RegulatoryNetwork network) {
        this.network = network;
        network.addObserver(this);
        this.reloadList();
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NodeList.this.network.notifyObserversOfChangedValues();
            }
        });
    }

    private void reloadList() {
        this.setListData(this.network.getNetworkNodes());
        this.revalidate();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension((int)Math.max(120.0, this.getPreferredSize().getWidth()), (int)this.getPreferredSize().getHeight());
    }

    public NetworkNode[] getSelectedNodes() {
        NetworkNode[] selectedNodes = new NetworkNode[this.getSelectedValuesList().size()];
        int i = 0;
        while (i < this.getSelectedValuesList().size()) {
            selectedNodes[i] = (NetworkNode)this.getSelectedValuesList().get(i);
            ++i;
        }
        return selectedNodes;
    }

    @Override
    public void notifyNetworkChanged() {
        this.reloadList();
    }

    @Override
    public void notifyValuesChanged() {
    }

    public RegulatoryNetwork getNetwork() {
        return this.network;
    }
}

