/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.guilib;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

public class DataTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4633388478606224862L;
    private ArrayList<Object[]> data;
    private String[] titles;
    private Class<?> type;
    private String[] horizontal;

    protected DataTableModel(ArrayList<Object[]> data, String[] titles, Class<?> type, String[] horizontal) {
        if (data == null || titles == null) {
            throw new NullPointerException();
        }
        if (horizontal != null) {
            if (data.size() != horizontal.length - 1) {
                throw new IllegalArgumentException("The data for the table model is not rectangular.");
            }
            for (Object[] objects : data) {
                if (objects.length == titles.length) continue;
                throw new IllegalArgumentException("The data for the table model is not rectangular.");
            }
        } else {
            for (Object[] objects : data) {
                if (objects.length == titles.length) continue;
                throw new IllegalArgumentException("The data for the table model is not rectangular.");
            }
        }
        Iterator<Object[]> iterator = data.iterator();
        while (iterator.hasNext()) {
            Object[] objects;
            Object[] objectArray = objects = iterator.next();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                try {
                    type.cast(object);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Not all data given to the output window has the given type.");
                }
                ++n2;
            }
        }
        this.data = data;
        this.titles = titles;
        this.type = type;
        this.horizontal = horizontal;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.horizontal != null) {
            if (columnIndex == 0) {
                return String.class;
            }
            return this.type;
        }
        return this.type;
    }

    @Override
    public int getColumnCount() {
        if (this.horizontal != null) {
            return this.data.size() + 1;
        }
        return this.titles.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.horizontal != null) {
            return this.horizontal[columnIndex];
        }
        return this.titles[columnIndex];
    }

    @Override
    public int getRowCount() {
        if (this.horizontal != null) {
            return this.titles.length;
        }
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.horizontal != null) {
            if (columnIndex == 0) {
                return this.titles[rowIndex];
            }
            return this.data.get(columnIndex - 1)[rowIndex];
        }
        return this.data.get(rowIndex)[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

