/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.simulationmethods.ContinuousSimulationMethod;
import jimena.simulationmethods.SimulationMethod;

public class SQUADMethod
extends ContinuousSimulationMethod {
    @Override
    public double getDerivativeValueInternal(RegulatoryNetwork network, int nodeIndex, double[] values) {
        if (network.getNetworkNodes()[nodeIndex].getCustomFunction() != null) {
            return network.getNetworkNodes()[nodeIndex].getCustomFunction().eval(this.getNamedInputs(network, values));
        }
        NetworkNode node = network.getNetworkNodes()[nodeIndex];
        BinaryBooleanFunction function = node.getFunction();
        double interpol = function.interpolateSQUAD(this.getInputs(network, nodeIndex, values), node.getSQUADWeights());
        double h = node.getSQUADSteepness();
        double g = node.getSQUADDecay();
        double e1 = node.getExpHalfSQUADSteepness();
        double e2 = Math.exp(-h * (interpol - 0.5));
        return (-e1 + e2) / ((1.0 - e1) * (1.0 + e2)) - g * values[nodeIndex];
    }

    @Override
    public String toString() {
        return "SQUAD";
    }

    @Override
    public SimulationMethod clone() {
        return new SQUADMethod();
    }
}

