/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import java.util.HashMap;
import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;

public abstract class SimulationMethod {
    private static final double STATESTABILITYINDEXDT = 1.0E-5;

    protected abstract void stepValuesOnly(RegulatoryNetwork var1, double var2);

    public void stepUpdateNetwork(RegulatoryNetwork network, double dt) {
        this.stepValuesOnly(network, dt);
        network.getTimeIndex().addValue(dt);
    }

    public double stateStabilityIndex(RegulatoryNetwork network) {
        double[] state = network.getValues();
        this.stepValuesOnly(network, 1.0E-5);
        double result = 0.0;
        int i = 0;
        while (i < network.size()) {
            result += (state[i] - network.getNetworkNodes()[i].getValue()) * (state[i] - network.getNetworkNodes()[i].getValue()) / 1.0E-5 / 1.0E-5;
            ++i;
        }
        network.setValues(state);
        return result /= (double)network.size();
    }

    protected final boolean[] getBooleanInputs(RegulatoryNetwork network, int nodeIndex) {
        NetworkNode node = network.getNetworkNodes()[nodeIndex];
        BinaryBooleanFunction function = node.getFunction();
        boolean[] inputs = new boolean[function.getArity()];
        int i = 0;
        while (i < inputs.length) {
            inputs[i] = !(network.getNetworkNodes()[node.getConnections()[i].getSource()].getValue() < 0.5);
            ++i;
        }
        return inputs;
    }

    protected final double[] getInputs(RegulatoryNetwork network, int nodeIndex, double[] values) {
        NetworkNode node = network.getNetworkNodes()[nodeIndex];
        BinaryBooleanFunction function = node.getFunction();
        double[] inputs = new double[function.getArity()];
        int i = 0;
        while (i < inputs.length) {
            inputs[i] = values[node.getConnections()[i].getSource()];
            ++i;
        }
        return inputs;
    }

    protected final HashMap<String, Double> getNamedInputs(RegulatoryNetwork network, double[] values) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        int i = 0;
        while (i < network.size()) {
            result.put(network.getNetworkNodes()[i].getName(), values[i]);
            ++i;
        }
        return result;
    }

    public abstract String toString();

    public abstract boolean isContinuous();

    public abstract SimulationMethod clone();
}

