/*
 * Decompiled with CFR 0.152.
 */
package jimena.solver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jimena.gui.main.Main;
import jimena.solver.Node;
import jimena.solver.NodeTableModel;

public class SolverFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private File modelFile = null;
    private HashMap<Integer, Node> nodeMap = new HashMap();
    private TableModel steadyStateModel = null;
    private JTable posCtlT;
    private JTable negCtlT;
    private JTable steadyStateTable1;
    private JTable steadyStateTable2;
    float alpha = 1.0f;
    float beta = 10.0f;
    float gamma = 1.0f;
    float h = 10.0f;
    float timeInterval = Float.parseFloat(Main.textDt.getText());
    float timeHorizon = Float.parseFloat(Main.textmaxt.getText());
    float alphaW = 0.1f;
    private JTextField valueAlpha;
    private JTextField valueBeta;
    private JTextField valueGamma;
    private JTextField valueInterval;
    private JTextField valuelHorizon;
    private JTextField valueAlphaW;
    private JTextField valueH;
    private HashMap<String, Integer> ctlN;
    private HashMap<String, Integer> ctlP;

    public SolverFrame() {
        super("Switch Analyzer - ver. " + Main.ver);
        this.setIconImage(new ImageIcon("images" + File.separator + "chart16.png").getImage());
        this.setMinimumSize(new Dimension(700, 450));
        this.setPreferredSize(new Dimension(1024, 768));
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
    }

    public SolverFrame(String steadyStateString, TableModel steadyStateModel, File modelFile) throws NumberFormatException, IOException {
        this();
        this.modelFile = modelFile;
        this.steadyStateModel = steadyStateModel;
        this.parseSteadyState();
        this.parseModelFile();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setOpaque(true);
        this.steadyStateTable1 = new JTable(steadyStateModel);
        this.steadyStateTable1.setAutoResizeMode(0);
        int i = 0;
        while (i < this.steadyStateTable1.getColumnCount()) {
            this.steadyStateTable1.getColumnModel().getColumn(i).setPreferredWidth(60);
            this.steadyStateTable1.getColumnModel().getColumn(i).setMinWidth(40);
            this.steadyStateTable1.getColumnModel().getColumn(i).setMaxWidth(120);
            ++i;
        }
        JScrollPane steadyStateSP1 = new JScrollPane(this.steadyStateTable1);
        steadyStateSP1.setViewportView(this.steadyStateTable1);
        steadyStateSP1.setPreferredSize(new Dimension(1024, 100));
        steadyStateSP1.setVerticalScrollBarPolicy(20);
        steadyStateSP1.setHorizontalScrollBarPolicy(30);
        this.steadyStateTable1.setSelectionMode(0);
        steadyStateSP1.setBorder(BorderFactory.createTitledBorder("Initial state"));
        p.add(steadyStateSP1);
        this.steadyStateTable2 = new JTable(steadyStateModel);
        this.steadyStateTable2.setAutoResizeMode(0);
        this.steadyStateTable2.setSelectionMode(0);
        int i2 = 0;
        while (i2 < this.steadyStateTable2.getColumnCount()) {
            this.steadyStateTable2.getColumnModel().getColumn(i2).setPreferredWidth(60);
            this.steadyStateTable2.getColumnModel().getColumn(i2).setMinWidth(40);
            this.steadyStateTable2.getColumnModel().getColumn(i2).setMaxWidth(120);
            ++i2;
        }
        JScrollPane steadyStateSP2 = new JScrollPane(this.steadyStateTable2);
        steadyStateSP2.setPreferredSize(new Dimension(1024, 100));
        steadyStateSP2.setVerticalScrollBarPolicy(20);
        steadyStateSP2.setHorizontalScrollBarPolicy(30);
        steadyStateSP2.setBorder(BorderFactory.createTitledBorder("Target state"));
        p.add(steadyStateSP2);
        JTextArea t2 = new JTextArea();
        t2.setWrapStyleWord(true);
        t2.setText(this.getNetworkSummary());
        t2.setEditable(false);
        t2.setBackground(new Color(225, 225, 255));
        JScrollPane ts2 = new JScrollPane(t2);
        ts2.setPreferredSize(new Dimension(800, 80));
        ts2.setVerticalScrollBarPolicy(20);
        ts2.setBorder(BorderFactory.createTitledBorder("Summary of the network"));
        p.add(ts2);
        Vector<String> colNames = new Vector<String>();
        colNames.add("Node");
        Vector nodesV = new Vector();
        for (Node i3 : this.nodeMap.values()) {
            Vector<String> r = new Vector<String>();
            r.add(i3.getName());
            nodesV.add(r);
        }
        NodeTableModel nodeM = new NodeTableModel(nodesV, (Vector)colNames);
        this.posCtlT = new JTable(nodeM);
        TableRowSorter<NodeTableModel> sorterP = new TableRowSorter<NodeTableModel>(nodeM);
        this.posCtlT.setRowSorter(sorterP);
        this.posCtlT.getRowSorter().toggleSortOrder(0);
        JScrollPane posCtlSP = new JScrollPane(this.posCtlT);
        posCtlSP.setPreferredSize(new Dimension(500, 310));
        JPanel posCtlP = new JPanel();
        posCtlP.setLayout(new BorderLayout());
        JToolBar posCtlTB = new JToolBar("Positive regulation", 0);
        JLabel posCtlLbl = new JLabel("Positive regulation");
        posCtlLbl.setForeground(Color.RED.darker());
        posCtlTB.add(posCtlLbl);
        JButton unSelAllBtn1 = new JButton("UnselectAll");
        unSelAllBtn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolverFrame.this.posCtlT.clearSelection();
            }
        });
        posCtlTB.add(unSelAllBtn1);
        posCtlP.add((Component)posCtlTB, "North");
        posCtlP.add((Component)posCtlSP, "Center");
        this.negCtlT = new JTable(nodeM);
        TableRowSorter<NodeTableModel> sorterN = new TableRowSorter<NodeTableModel>(nodeM);
        this.negCtlT.setRowSorter(sorterN);
        this.negCtlT.getRowSorter().toggleSortOrder(0);
        JScrollPane negCtlSP = new JScrollPane(this.negCtlT);
        negCtlSP.setPreferredSize(new Dimension(500, 310));
        JToolBar negCtlTB = new JToolBar("Negative regulation", 0);
        JLabel negCtlLbl = new JLabel("Negative regulation");
        negCtlLbl.setForeground(Color.BLUE.darker());
        negCtlTB.add(negCtlLbl);
        JButton unSelAllBtn2 = new JButton("UnselectAll");
        unSelAllBtn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolverFrame.this.negCtlT.clearSelection();
            }
        });
        negCtlTB.add(unSelAllBtn2);
        JPanel negCtlP = new JPanel();
        negCtlP.setLayout(new BorderLayout());
        negCtlP.add((Component)negCtlTB, "North");
        negCtlP.add((Component)negCtlSP, "Center");
        JSplitPane regP = new JSplitPane(1);
        regP.add((Component)posCtlP, "left");
        regP.add((Component)negCtlP, "right");
        regP.setDividerLocation(0.5);
        JPanel regVP = new JPanel();
        regVP.add((Component)regP, "Center");
        TitledBorder regulationBorder = BorderFactory.createTitledBorder("Regulations (press ctl to select)");
        regVP.setBorder(regulationBorder);
        p.add(regVP);
        p.add(this.createToolBar());
        this.getContentPane().add("Center", p);
        this.setLocationByPlatform(true);
        this.pack();
    }

    private void parseSteadyState() {
    }

    private String getNetworkSummary() {
        String content = "ModelFile: " + this.modelFile.getName() + "\n";
        for (Integer i : this.nodeMap.keySet()) {
            content = String.valueOf(content) + "Node " + i + " : " + this.nodeMap.get(i).getName() + "\n";
            for (Integer j : this.nodeMap.get(i).getAct()) {
                content = String.valueOf(content) + "\tActivate -> " + j + " : " + this.nodeMap.get(j).getName() + "\n";
            }
            for (Integer j : this.nodeMap.get(i).getInh()) {
                content = String.valueOf(content) + "\tInhibit  -| " + j + " : " + this.nodeMap.get(j).getName() + "\n";
            }
            for (Integer j : this.nodeMap.get(i).getActBy()) {
                content = String.valueOf(content) + "\tActivated by <- " + j + " : " + this.nodeMap.get(j).getName() + "\n";
            }
            for (Integer j : this.nodeMap.get(i).getInhBy()) {
                content = String.valueOf(content) + "\tInhibited by <- " + j + " : " + this.nodeMap.get(j).getName() + "\n";
            }
        }
        return content;
    }

    private void parseModelFile() throws NumberFormatException, IOException {
        String ls1;
        BufferedReader br = null;
        if (this.modelFile == null) {
            return;
        }
        br = new BufferedReader(new FileReader(this.modelFile));
        Integer target = null;
        Integer source = null;
        Integer nodeId = null;
        String nodeLabel = null;
        while ((ls1 = br.readLine()) != null) {
            Matcher m1 = Pattern.compile("<node\\sid=\\\"n(\\d+)\\\">").matcher(ls1);
            if (m1.find()) {
                nodeId = Integer.parseInt(m1.group(1)) + 1;
                continue;
            }
            Matcher m2 = Pattern.compile("\\s*<y:NodeLabel.+?>(.+)?<y:LabelModel>").matcher(ls1);
            if (m2.find()) {
                nodeLabel = m2.group(1);
                if (this.nodeMap.containsKey(nodeId)) continue;
                this.nodeMap.put(nodeId, new Node(nodeId, nodeLabel));
                continue;
            }
            Matcher m3 = Pattern.compile("<edge\\sid=\"e(\\d+)\"\\ssource=\"n(\\d+?)\"\\starget=\"n(\\d+?)\">").matcher(ls1);
            if (m3.find()) {
                source = Integer.parseInt(m3.group(2)) + 1;
                target = Integer.parseInt(m3.group(3)) + 1;
                continue;
            }
            Matcher m4 = Pattern.compile("<y:Arrows\\ssource=\"\\w+?\"\\starget=\"(\\w+?)\"\\/>").matcher(ls1);
            if (!m4.find()) continue;
            if (m4.group(1).equals("standard")) {
                this.nodeMap.get(target).addActBy(source);
                this.nodeMap.get(source).addAct(target);
                continue;
            }
            if (!m4.group(1).equals("t_shape")) continue;
            this.nodeMap.get(target).addInhBy(source);
            this.nodeMap.get(source).addInh(target);
        }
        br.close();
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new GridBagLayout());
        toolbar.setRollover(true);
        toolbar.setMaximumSize(new Dimension(1024, 25));
        toolbar.setFloatable(false);
        JLabel labelMethod = new JLabel("Analyzer:");
        toolbar.add((Component)labelMethod, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        String[] method = new String[]{"Matlab"};
        JComboBox<String> methodBox = new JComboBox<String>(method);
        methodBox.setPreferredSize(new Dimension(100, 20));
        toolbar.add(methodBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel labelMFile = new JLabel("Model:");
        toolbar.add((Component)labelMFile, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JTextField modelF = new JTextField(this.modelFile.getName());
        modelF.setSize(250, 20);
        modelF.setPreferredSize(new Dimension(300, 20));
        modelF.setEditable(false);
        toolbar.add((Component)modelF, new GridBagConstraints(3, 0, 3, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel labelInterval = new JLabel("Interval:");
        toolbar.add((Component)labelInterval, new GridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.valueInterval = new JTextField(Float.toString(this.timeInterval));
        this.valueInterval.setSize(60, 20);
        this.valueInterval.setPreferredSize(new Dimension(100, 20));
        this.valueInterval.setEditable(true);
        toolbar.add((Component)this.valueInterval, new GridBagConstraints(7, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel labelHorizon = new JLabel("Horizon:");
        toolbar.add((Component)labelHorizon, new GridBagConstraints(8, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.valuelHorizon = new JTextField(Float.toString(this.timeHorizon));
        this.valuelHorizon.setSize(60, 20);
        this.valuelHorizon.setPreferredSize(new Dimension(100, 20));
        this.valuelHorizon.setEditable(true);
        toolbar.add((Component)this.valuelHorizon, new GridBagConstraints(9, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel labelAlpha = new JLabel("Alpha:");
        toolbar.add(labelAlpha);
        toolbar.add((Component)labelAlpha, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.valueAlpha = new JTextField(Float.toString(this.alpha));
        this.valueAlpha.setSize(60, 20);
        this.valueAlpha.setPreferredSize(new Dimension(100, 20));
        this.valueAlpha.setEditable(true);
        toolbar.add((Component)this.valueAlpha, new GridBagConstraints(1, 1, 1, 1, 2.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel labelBeta = new JLabel("Beta:");
        toolbar.add(labelBeta);
        toolbar.add((Component)labelBeta, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.valueBeta = new JTextField(Float.toString(this.beta));
        this.valueBeta.setSize(60, 20);
        this.valueBeta.setPreferredSize(new Dimension(100, 20));
        this.valueBeta.setEditable(true);
        toolbar.add((Component)this.valueBeta, new GridBagConstraints(3, 1, 1, 1, 2.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel labelGamma = new JLabel("Gamma:");
        toolbar.add(labelGamma);
        toolbar.add((Component)labelGamma, new GridBagConstraints(4, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.valueGamma = new JTextField(Float.toString(this.gamma));
        this.valueGamma.setSize(60, 20);
        this.valueGamma.setPreferredSize(new Dimension(100, 20));
        this.valueGamma.setEditable(true);
        toolbar.add((Component)this.valueGamma, new GridBagConstraints(5, 1, 1, 1, 2.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel labelH = new JLabel("H:");
        toolbar.add(labelH);
        toolbar.add((Component)labelH, new GridBagConstraints(6, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.valueH = new JTextField(Float.toString(this.h));
        this.valueH.setSize(60, 20);
        this.valueH.setPreferredSize(new Dimension(100, 20));
        this.valueH.setEditable(true);
        toolbar.add((Component)this.valueH, new GridBagConstraints(7, 1, 1, 1, 2.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel labelAlphaW = new JLabel("AlphaW:");
        toolbar.add((Component)labelAlphaW, new GridBagConstraints(8, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.valueAlphaW = new JTextField(Float.toString(this.alphaW));
        this.valueAlphaW.setSize(60, 20);
        this.valueAlphaW.setPreferredSize(new Dimension(100, 20));
        this.valueAlphaW.setEditable(true);
        toolbar.add((Component)this.valueAlphaW, new GridBagConstraints(9, 1, 1, 2, 1.0, 1.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton generateScriptBtn = new JButton("Generate");
        generateScriptBtn.addActionListener(this);
        generateScriptBtn.setIcon(new ImageIcon("images" + File.separator + "chart16.png"));
        generateScriptBtn.setForeground(Color.MAGENTA.darker());
        toolbar.add((Component)generateScriptBtn, new GridBagConstraints(10, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        return toolbar;
    }

    public String matlab_header(int numNodes, int numControls, float timeInterval, float timeHorizon, float alphaM, String initStateS, String targetStateS, String onlyFn) {
        String a = "function [  ] = " + onlyFn + "()\n";
        BufferedReader br2 = null;
        try {
            br2 = new BufferedReader(new FileReader("matlab" + File.separator + "matlabsolver_header.txt"));
            String l = "";
            while ((l = br2.readLine()) != null) {
                a = String.valueOf(a) + l + "\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        a = String.valueOf(a) + "\ntol1=10^-1;\ntol2=10^-6;\ntol3=10^-4;\nT_int=10^-1;\nmax_Num=4;\nmax_iter=10000;\ncombi_method=1;\nlocal_optimization_method=1;\n\n";
        a = String.valueOf(a) + "OCP=struct('numNodes'," + numNodes + ",'numControls'," + numControls + ",'timeInterval'," + timeInterval + ",'timeHorizon'," + timeHorizon + ",'alpha'," + this.alphaW + ",'initialState',[" + initStateS + "]);\n\n";
        a = String.valueOf(a) + "xd=get_xd([" + targetStateS + "], OCP);\n";
        return a;
    }

    public String matlab_footer() {
        String a = "";
        BufferedReader br2 = null;
        try {
            br2 = new BufferedReader(new FileReader("matlab" + File.separator + "matlabsolver_footer.txt"));
            String l = "";
            while ((l = br2.readLine()) != null) {
                a = String.valueOf(a) + l + "\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return a;
    }

    private String generateFormular(Float alpha, Float beta, Float gamma, Float h) {
        int i1;
        String content = "";
        this.ctlP = new HashMap();
        this.ctlN = new HashMap();
        int n = 0;
        int[] nArray = this.posCtlT.getSelectedRows();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            i1 = nArray[n3];
            this.ctlP.put(this.posCtlT.getValueAt(i1, 0).toString(), ++n);
            ++n3;
        }
        nArray = this.negCtlT.getSelectedRows();
        n2 = nArray.length;
        n3 = 0;
        while (n3 < n2) {
            i1 = nArray[n3];
            this.ctlN.put(this.negCtlT.getValueAt(i1, 0).toString(), ++n);
            ++n3;
        }
        for (Integer i : this.nodeMap.keySet()) {
            String output_j = "";
            System.out.println("Node " + i + " : " + this.nodeMap.get(i).getName());
            String nodeX = "x(" + i + ")";
            String omega = "";
            if (this.nodeMap.get(i).getActBy().size() > 0) {
                float alphasum = 0.0f;
                String actsum = "";
                boolean alreadyinput = false;
                for (Integer j : this.nodeMap.get(i).getActBy()) {
                    System.out.println("\tActivated by " + j + ":" + this.nodeMap.get(j).getName());
                    alphasum += alpha.floatValue();
                    if (alreadyinput) {
                        actsum = String.valueOf(actsum) + '+';
                    }
                    actsum = String.valueOf(actsum) + (alpha.floatValue() == 1.0f ? "" : String.valueOf(Float.toString(alpha.floatValue())) + "*") + "x(" + Integer.toString(j) + ")";
                    alreadyinput = true;
                }
                omega = "(" + Float.toString(1.0f + alphasum) + "/" + Float.toString(alphasum) + ")*((" + actsum + ")/(1+" + actsum + "))";
            }
            if (this.nodeMap.get(i).getInhBy().size() > 0) {
                boolean alreadyinput = false;
                float betasum = 0.0f;
                String inhsum = "";
                for (Integer j : this.nodeMap.get(i).getInhBy()) {
                    System.out.println("\tInhed by " + j + ":" + this.nodeMap.get(j).getName());
                    betasum += beta.floatValue();
                    if (alreadyinput) {
                        inhsum = String.valueOf(inhsum) + '+';
                    }
                    inhsum = String.valueOf(inhsum) + (beta.floatValue() == 1.0f ? "" : String.valueOf(Float.toString(beta.floatValue())) + "*") + "x(" + Integer.toString(j) + ")";
                    alreadyinput = true;
                }
                if (!omega.isEmpty()) {
                    omega = String.valueOf(omega) + "*";
                }
                omega = String.valueOf(omega) + "(1-(" + Float.toString(1.0f + betasum) + "/" + Float.toString(betasum) + ")*((" + inhsum + ")/(1+" + inhsum + "))" + ")";
            }
            output_j = this.nodeMap.get(i).getActBy().size() > 0 || this.nodeMap.get(i).getInhBy().size() > 0 ? String.valueOf(output_j) + "@(x,u)((-exp(" + 0.5 * (double)h.floatValue() + ")+exp(-" + h + "*((" + omega + ")-0.5)))/((1-exp(" + 0.5 * (double)h.floatValue() + "))*(1+exp(-" + h + "*((" + omega + ")-0.5)))))-" + (gamma.floatValue() == 1.0f ? nodeX : gamma + "*" + nodeX) : String.valueOf(output_j) + "@(x,u)-" + gamma + "*" + nodeX;
            System.out.print("Positive regulation: ");
            int[] nArray2 = this.posCtlT.getSelectedRows();
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                int i12 = nArray2[n5];
                System.out.print(this.posCtlT.getValueAt(i12, 0) + "\t");
                ++n5;
            }
            System.out.println();
            System.out.print("Negative regulation: ");
            nArray2 = this.negCtlT.getSelectedRows();
            n4 = nArray2.length;
            n5 = 0;
            while (n5 < n4) {
                int i13 = nArray2[n5];
                System.out.print(this.negCtlT.getValueAt(i13, 0) + "\t");
                ++n5;
            }
            System.out.println();
            if (this.ctlP.containsKey(this.nodeMap.get(i).getName())) {
                output_j = String.valueOf(output_j) + "+u(" + this.ctlP.get(this.nodeMap.get(i).getName()) + ")*(1-x(" + i + "))";
            }
            if (this.ctlN.containsKey(this.nodeMap.get(i).getName())) {
                output_j = String.valueOf(output_j) + "-u(" + this.ctlN.get(this.nodeMap.get(i).getName()) + ")*x(" + i + ")";
            }
            if (!content.isEmpty()) {
                content = String.valueOf(content) + ",...\n";
            }
            content = String.valueOf(content) + output_j;
        }
        content = "f= {" + content + "};\n";
        return content;
    }

    private String getCommentNodes() {
        String content = "% Node_list \n";
        for (Integer i : this.nodeMap.keySet()) {
            content = String.valueOf(content) + "% Node " + i + " : " + this.nodeMap.get(i).getName() + "\n";
        }
        content = String.valueOf(content) + "%\n% Regulation_list\n";
        for (String n : this.ctlP.keySet()) {
            content = String.valueOf(content) + "% Pos " + this.ctlP.get(n).toString() + " : " + n + "\n";
        }
        for (String n : this.ctlN.keySet()) {
            content = String.valueOf(content) + "% Neg " + this.ctlN.get(n).toString() + " : " + n + "\n";
        }
        return content;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int initR = this.steadyStateTable1.getSelectedRow();
        int targetR = this.steadyStateTable2.getSelectedRow();
        if (this.steadyStateTable1.getSelectedColumnCount() == 0 || this.steadyStateTable2.getSelectedColumnCount() == 0) {
            JOptionPane.showMessageDialog(this, "Please specify one initial steady state and desired target state in the tables");
            return;
        }
        HashMap<String, Object> sst1 = new HashMap<String, Object>();
        int i = 0;
        while (i < this.steadyStateTable1.getColumnCount()) {
            sst1.put(this.steadyStateTable1.getColumnName(i), this.steadyStateTable1.getValueAt(initR, i));
            ++i;
        }
        String initStateS = "";
        for (Integer i2 : this.nodeMap.keySet()) {
            if (!initStateS.isEmpty()) {
                initStateS = String.valueOf(initStateS) + ',';
            }
            initStateS = String.valueOf(initStateS) + sst1.get(this.nodeMap.get(i2).getName());
        }
        HashMap<String, Object> sst2 = new HashMap<String, Object>();
        int i3 = 0;
        while (i3 < this.steadyStateTable2.getColumnCount()) {
            sst2.put(this.steadyStateTable2.getColumnName(i3), this.steadyStateTable2.getValueAt(targetR, i3));
            ++i3;
        }
        String targetStateS = "";
        for (Integer i4 : this.nodeMap.keySet()) {
            if (!targetStateS.isEmpty()) {
                targetStateS = String.valueOf(targetStateS) + ',';
            }
            targetStateS = String.valueOf(targetStateS) + sst2.get(this.nodeMap.get(i4).getName());
        }
        JFileChooser fc = new JFileChooser();
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = fc.getSelectedFile();
            if (!selectedFile.toString().endsWith(".m")) {
                selectedFile = new File(String.valueOf(selectedFile.toString()) + ".m");
            }
            String onlyFn = selectedFile.getName().substring(0, selectedFile.getName().lastIndexOf(46));
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(selectedFile));
                bw.write(this.matlab_header(this.nodeMap.size(), this.posCtlT.getSelectedRowCount() + this.negCtlT.getSelectedRowCount(), Float.parseFloat(this.valueInterval.getText()), Float.parseFloat(this.valuelHorizon.getText()), Float.parseFloat(this.valueAlphaW.getText()), initStateS, targetStateS, onlyFn));
                bw.write(this.generateFormular(Float.valueOf(Float.parseFloat(this.valueAlpha.getText())), Float.valueOf(Float.parseFloat(this.valueBeta.getText())), Float.valueOf(Float.parseFloat(this.valueGamma.getText())), Float.valueOf(Float.parseFloat(this.valueH.getText()))));
                bw.write(this.matlab_footer());
                bw.write(this.getCommentNodes());
                bw.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

