/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;

public class CALFactory
extends BDDFactory {
    private static CALFactory INSTANCE;
    private static long zero;
    private static long one;
    public static final String REVISION = "$Revision: 1.6 $";

    static {
        String libname = "cal";
        try {
            System.loadLibrary(libname);
        }
        catch (UnsatisfiedLinkError x) {
            libname = System.mapLibraryName(libname);
            String currentdir = CALFactory.getProperty("user.dir", ".");
            String sep = CALFactory.getProperty("file.separator", "/");
            System.load(String.valueOf(currentdir) + sep + libname);
        }
        CALFactory.registerNatives();
    }

    public static BDDFactory init(int nodenum, int cachesize) {
        CALFactory f = new CALFactory();
        f.initialize(nodenum / 256, cachesize);
        return f;
    }

    private static native void registerNatives();

    private CALFactory() {
    }

    @Override
    public BDD zero() {
        return new CALBDD(zero);
    }

    @Override
    public BDD one() {
        return new CALBDD(one);
    }

    @Override
    protected void initialize(int nodenum, int cachesize) {
        if (INSTANCE != null) {
            throw new InternalError("Error: CALFactory already initialized.");
        }
        INSTANCE = this;
        CALFactory.initialize0(nodenum, cachesize);
    }

    private static native void initialize0(int var0, int var1);

    @Override
    public boolean isInitialized() {
        return CALFactory.isInitialized0();
    }

    private static native boolean isInitialized0();

    @Override
    public void done() {
        INSTANCE = null;
        CALFactory.done0();
    }

    private static native void done0();

    @Override
    public void setError(int code) {
    }

    @Override
    public void clearError() {
    }

    @Override
    public int setMaxNodeNum(int size) {
        System.err.println("Warning: setMaxNodeNum() not yet implemented");
        return 1000000;
    }

    @Override
    public double setMinFreeNodes(double x) {
        System.err.println("Warning: setMinFreeNodes() not yet implemented");
        return 0.0;
    }

    @Override
    public int setMaxIncrease(int x) {
        System.err.println("Warning: setMaxIncrease() not yet implemented");
        return 50000;
    }

    @Override
    public double setCacheRatio(double x) {
        System.err.println("Warning: setCacheRatio() not yet implemented");
        return 0.0;
    }

    @Override
    public int varNum() {
        return CALFactory.varNum0();
    }

    private static native int varNum0();

    @Override
    public int setVarNum(int num) {
        return CALFactory.setVarNum0(num);
    }

    private static native int setVarNum0(int var0);

    @Override
    public int duplicateVar(int var) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BDD ithVar(int var) {
        long id = CALFactory.ithVar0(var);
        return new CALBDD(id);
    }

    private static native long ithVar0(int var0);

    @Override
    public BDD nithVar(int var) {
        BDD b = this.ithVar(var);
        BDD c = b.not();
        b.free();
        return c;
    }

    @Override
    public void swapVar(int v1, int v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BDDPairing makePair() {
        return new CALBDDPairing();
    }

    @Override
    public void printAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printTable(BDD b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int level2Var(int level) {
        return CALFactory.level2Var0(level);
    }

    private static native int level2Var0(int var0);

    @Override
    public int var2Level(int var) {
        return CALFactory.var2Level0(var);
    }

    private static native int var2Level0(int var0);

    @Override
    public void reorder(BDDFactory.ReorderMethod m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void autoReorder(BDDFactory.ReorderMethod method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void autoReorder(BDDFactory.ReorderMethod method, int max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BDDFactory.ReorderMethod getReorderMethod() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getReorderTimes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableReorder() {
        System.err.println("Warning: disableReorder() not yet implemented");
    }

    @Override
    public void enableReorder() {
        System.err.println("Warning: enableReorder() not yet implemented");
    }

    @Override
    public int reorderVerbose(int v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVarOrder(int[] neworder) {
        CALFactory.setVarOrder0(neworder);
    }

    private static native void setVarOrder0(int[] var0);

    @Override
    public void addVarBlock(BDD var, boolean fixed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addVarBlock(int first, int last, boolean fixed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void varBlockAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearVarBlocks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printOrder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nodeCount(Collection r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNodeTableSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCacheSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNodeNum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int reorderGain() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printStat() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected BDDDomain createDomain(int a, BigInteger b) {
        return new CALBDDDomain(a, b);
    }

    @Override
    protected BDDBitVector createBitVector(int a) {
        return new CALBDDBitVector(a);
    }

    @Override
    public double setIncreaseFactor(double x) {
        System.err.println("Warning: setIncreaseFactor() not yet implemented");
        return 0.0;
    }

    @Override
    public int setNodeTableSize(int n) {
        System.err.println("Warning: setNodeTableSize() not yet implemented");
        return 0;
    }

    @Override
    public int setCacheSize(int n) {
        System.err.println("Warning: setCacheSize() not yet implemented");
        return 0;
    }

    @Override
    public String getVersion() {
        return "CAL " + REVISION.substring(11, REVISION.length() - 2);
    }

    private static class CALBDD
    extends BDD {
        private long _ddnode_ptr;
        static final long INVALID_BDD = -1L;
        static final boolean USE_FINALIZER = false;

        private CALBDD(long ddnode) {
            this._ddnode_ptr = ddnode;
            CALBDD.addRef(ddnode);
        }

        @Override
        public BDDFactory getFactory() {
            return INSTANCE;
        }

        @Override
        public boolean isZero() {
            return this._ddnode_ptr == zero;
        }

        @Override
        public boolean isOne() {
            return this._ddnode_ptr == one;
        }

        @Override
        public int var() {
            return CALBDD.var0(this._ddnode_ptr);
        }

        private static native int var0(long var0);

        @Override
        public BDD high() {
            long b = CALBDD.high0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long high0(long var0);

        @Override
        public BDD low() {
            long b = CALBDD.low0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long low0(long var0);

        @Override
        public BDD id() {
            return new CALBDD(this._ddnode_ptr);
        }

        @Override
        public BDD not() {
            long b = CALBDD.not0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long not0(long var0);

        @Override
        public BDD ite(BDD thenBDD, BDD elseBDD) {
            CALBDD c = (CALBDD)thenBDD;
            CALBDD d = (CALBDD)elseBDD;
            long b = CALBDD.ite0(this._ddnode_ptr, c._ddnode_ptr, d._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long ite0(long var0, long var2, long var4);

        @Override
        public BDD relprod(BDD that, BDD var) {
            CALBDD c = (CALBDD)that;
            CALBDD d = (CALBDD)var;
            long b = CALBDD.relprod0(this._ddnode_ptr, c._ddnode_ptr, d._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long relprod0(long var0, long var2, long var4);

        @Override
        public BDD compose(BDD that, int var) {
            CALBDD c = (CALBDD)that;
            long b = CALBDD.compose0(this._ddnode_ptr, c._ddnode_ptr, var);
            return new CALBDD(b);
        }

        private static native long compose0(long var0, long var2, int var4);

        @Override
        public BDD constrain(BDD that) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BDD exist(BDD var) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BDD forAll(BDD var) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BDD unique(BDD var) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BDD restrict(BDD var) {
            CALBDD c = (CALBDD)var;
            long b = CALBDD.restrict0(this._ddnode_ptr, c._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long restrict0(long var0, long var2);

        @Override
        public BDD restrictWith(BDD var) {
            CALBDD c = (CALBDD)var;
            long b = CALBDD.restrict0(this._ddnode_ptr, c._ddnode_ptr);
            CALBDD.addRef(b);
            CALBDD.delRef(this._ddnode_ptr);
            if (this != c) {
                CALBDD.delRef(c._ddnode_ptr);
                c._ddnode_ptr = -1L;
            }
            this._ddnode_ptr = b;
            return this;
        }

        @Override
        public BDD simplify(BDD d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BDD support() {
            long b = CALBDD.support0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long support0(long var0);

        @Override
        public BDD apply(BDD that, BDDFactory.BDDOp opr) {
            CALBDD c = (CALBDD)that;
            long b = CALBDD.apply0(this._ddnode_ptr, c._ddnode_ptr, opr.id);
            return new CALBDD(b);
        }

        private static native long apply0(long var0, long var2, int var4);

        @Override
        public BDD applyWith(BDD that, BDDFactory.BDDOp opr) {
            CALBDD c = (CALBDD)that;
            long b = CALBDD.apply0(this._ddnode_ptr, c._ddnode_ptr, opr.id);
            CALBDD.addRef(b);
            CALBDD.delRef(this._ddnode_ptr);
            if (this != c) {
                CALBDD.delRef(c._ddnode_ptr);
                c._ddnode_ptr = -1L;
            }
            this._ddnode_ptr = b;
            return this;
        }

        @Override
        public BDD applyAll(BDD that, BDDFactory.BDDOp opr, BDD var) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BDD applyEx(BDD that, BDDFactory.BDDOp opr, BDD var) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BDD applyUni(BDD that, BDDFactory.BDDOp opr, BDD var) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BDD satOne() {
            long b = CALBDD.satOne0(this._ddnode_ptr);
            return new CALBDD(b);
        }

        private static native long satOne0(long var0);

        @Override
        public BDD fullSatOne() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BDD satOne(BDD var, boolean pol) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List allsat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nodeCount() {
            return CALBDD.nodeCount0(this._ddnode_ptr);
        }

        private static native int nodeCount0(long var0);

        @Override
        public double pathCount() {
            return CALBDD.pathCount0(this._ddnode_ptr);
        }

        private static native double pathCount0(long var0);

        @Override
        public double satCount() {
            return CALBDD.satCount0(this._ddnode_ptr);
        }

        private static native double satCount0(long var0);

        @Override
        public int[] varProfile() {
            throw new UnsupportedOperationException();
        }

        private static native void addRef(long var0);

        private static native void delRef(long var0);

        @Override
        public void free() {
            CALBDD.delRef(this._ddnode_ptr);
            this._ddnode_ptr = -1L;
        }

        @Override
        public BDD veccompose(BDDPairing pair) {
            CALBDDPairing p = (CALBDDPairing)pair;
            long b = CALBDD.veccompose0(this._ddnode_ptr, p._ptr);
            return new CALBDD(b);
        }

        private static native long veccompose0(long var0, long var2);

        @Override
        public BDD replace(BDDPairing pair) {
            CALBDDPairing p = (CALBDDPairing)pair;
            long b = CALBDD.replace0(this._ddnode_ptr, p._ptr);
            return new CALBDD(b);
        }

        private static native long replace0(long var0, long var2);

        @Override
        public BDD replaceWith(BDDPairing pair) {
            CALBDDPairing p = (CALBDDPairing)pair;
            long b = CALBDD.replace0(this._ddnode_ptr, p._ptr);
            CALBDD.addRef(b);
            CALBDD.delRef(this._ddnode_ptr);
            this._ddnode_ptr = b;
            return this;
        }

        @Override
        public boolean equals(BDD that) {
            return this._ddnode_ptr == ((CALBDD)that)._ddnode_ptr;
        }

        @Override
        public int hashCode() {
            return (int)this._ddnode_ptr;
        }
    }

    private static class CALBDDBitVector
    extends BDDBitVector {
        private CALBDDBitVector(int a) {
            super(a);
        }

        @Override
        public BDDFactory getFactory() {
            return INSTANCE;
        }
    }

    private static class CALBDDDomain
    extends BDDDomain {
        private CALBDDDomain(int index, BigInteger range) {
            super(index, range);
        }

        @Override
        public BDDFactory getFactory() {
            return INSTANCE;
        }
    }

    private static class CALBDDPairing
    extends BDDPairing {
        long _ptr = CALBDDPairing.alloc();

        private CALBDDPairing() {
        }

        private static native long alloc();

        @Override
        public void set(int oldvar, int newvar) {
            CALBDDPairing.set0(this._ptr, oldvar, newvar);
        }

        private static native void set0(long var0, int var2, int var3);

        @Override
        public void set(int oldvar, BDD newvar) {
            CALBDD c = (CALBDD)newvar;
            CALBDDPairing.set2(this._ptr, oldvar, c._ddnode_ptr);
        }

        private static native void set2(long var0, int var2, long var3);

        @Override
        public void reset() {
            CALBDDPairing.reset0(this._ptr);
        }

        private static native void reset0(long var0);

        private static native void free0(long var0);
    }
}

