/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.StringTokenizer;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDFactory;

public class TryVarOrder {
    static Object bdd = null;
    Object bddoperation = null;
    BDDFactory.BDDOp op;
    String filename0;
    String filename1;
    String filename2;
    String filename3;
    long DELAY_TIME = 20000L;
    long bestCalcTime;
    String bestOrder;
    int nodeTableSize;
    int cacheSize;
    int maxIncrease;
    File f0;
    File f1;
    File f2;
    File f3;

    static ClassLoader makeClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    void initBDDFactory(String s) {
        try {
            ClassLoader cl = this.bddoperation != null ? this.bddoperation.getClass().getClassLoader() : TryVarOrder.makeClassLoader();
            Class<?> c = cl.loadClass("net.sf.javabdd.BDDFactory");
            Method m = c.getMethod("init", String.class, Integer.TYPE, Integer.TYPE);
            bdd = m.invoke(null, s, new Integer(this.nodeTableSize), new Integer(this.cacheSize));
            m = c.getMethod("setMaxIncrease", Integer.TYPE);
            m.invoke(bdd, new Integer(this.maxIncrease));
            BufferedReader in = null;
            try {
                try {
                    String s2;
                    in = new BufferedReader(new FileReader(this.filename0));
                    while ((s2 = in.readLine()) != null) {
                        if (s2.equals("")) {
                            break;
                        }
                        StringTokenizer st = new StringTokenizer(s2);
                        String name = st.nextToken();
                        long size = Long.parseLong(st.nextToken()) - 1L;
                        TryVarOrder.makeDomain(c, name, BigInteger.valueOf(size).bitLength());
                    }
                }
                catch (IOException iOException) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception x) {
            System.err.println("Exception occurred while initializing BDD factory: " + x.getLocalizedMessage());
            x.printStackTrace();
        }
    }

    void destroyBDDFactory() {
        if (bdd != null) {
            Class<?> c = bdd.getClass();
            try {
                Method m = c.getMethod("done", new Class[0]);
                m.invoke(bdd, new Object[0]);
            }
            catch (Exception x) {
                System.err.println("Exception occurred while destroying BDD factory: " + x.getLocalizedMessage());
                x.printStackTrace();
            }
            bdd = null;
        }
    }

    void setBDDError(int code) {
        Class<?> c = bdd.getClass();
        try {
            Method m = c.getMethod("setError", Integer.TYPE);
            m.invoke(bdd, new Integer(code));
        }
        catch (Exception x) {
            System.err.println("Exception occurred while setting error for BDD factory: " + x.getLocalizedMessage());
            x.printStackTrace();
        }
    }

    static void makeDomain(Class c, String name, int bits) throws Exception {
        Method m = c.getMethod("extDomain", long[].class);
        Object[] ds = (Object[])m.invoke(null, new Object[]{new long[]{1L << bits}});
        c = c.getClassLoader().loadClass("net.sf.javabdd.BDDDomain");
        m = c.getMethod("setName", String.class);
        m.invoke(ds[0], name);
    }

    void initBDDOperation() throws Exception {
        ClassLoader cl = bdd != null ? bdd.getClass().getClassLoader() : TryVarOrder.makeClassLoader();
        Class<?> bddop_class = cl.loadClass("net.sf.javabdd.TryVarOrder$BDDOperation");
        Constructor<?> c = bddop_class.getConstructor(new Class[0]);
        this.bddoperation = c.newInstance(null);
        Method m = bddop_class.getMethod("setOp", Integer.TYPE);
        m.invoke(this.bddoperation, new Integer(this.op.id));
        m = bddop_class.getMethod("setFilenames", String.class, String.class, String.class);
        m.invoke(this.bddoperation, this.filename1, this.filename2, this.filename3);
    }

    void setVarOrder(boolean reverse, String varOrderToTry) throws Exception {
        Class<?> bddop_class = this.bddoperation.getClass();
        Method m = bddop_class.getMethod("setVarOrder", Boolean.TYPE, String.class);
        m.invoke(this.bddoperation, reverse, varOrderToTry);
    }

    void load() throws Exception {
        Class<?> bddop_class = this.bddoperation.getClass();
        Method m = bddop_class.getMethod("load", new Class[0]);
        m.invoke(this.bddoperation, new Object[0]);
    }

    long doIt() throws Exception {
        Class<?> bddop_class = this.bddoperation.getClass();
        Method m = bddop_class.getMethod("doIt", new Class[0]);
        Long result = (Long)m.invoke(this.bddoperation, new Object[0]);
        return result;
    }

    void free() throws Exception {
        Class<?> bddop_class = this.bddoperation.getClass();
        Method m = bddop_class.getMethod("free", new Class[0]);
        m.invoke(this.bddoperation, new Object[0]);
    }

    public TryVarOrder(int nodeTableSize, int cacheSize, int maxIncrease, long bestTime, long delayTime) {
        this.bestCalcTime = bestTime;
        this.nodeTableSize = nodeTableSize;
        this.cacheSize = cacheSize;
        this.maxIncrease = maxIncrease;
        this.DELAY_TIME = delayTime;
    }

    public void init(BDD b1, BDD b2, BDD dom, BDDFactory.BDDOp op) throws IOException {
        this.op = op;
        this.f0 = File.createTempFile("fbo", "a");
        this.filename0 = this.f0.getAbsolutePath();
        this.f0.deleteOnExit();
        this.f1 = File.createTempFile("fbo", "b");
        this.filename1 = this.f1.getAbsolutePath();
        this.f1.deleteOnExit();
        this.f2 = File.createTempFile("fbo", "c");
        this.filename2 = this.f2.getAbsolutePath();
        this.f2.deleteOnExit();
        this.f3 = File.createTempFile("fbo", "d");
        this.filename3 = this.f3.getAbsolutePath();
        this.f3.deleteOnExit();
        this.writeBDDConfig(b1.getFactory(), this.filename0);
        b1.getFactory().save(this.filename1, b1);
        b2.getFactory().save(this.filename2, b2);
        dom.getFactory().save(this.filename3, dom);
        try {
            this.initBDDOperation();
        }
        catch (Exception x) {
            System.err.println("Exception occurred while initializing: " + x.getLocalizedMessage());
            x.printStackTrace();
        }
    }

    public void cleanup() {
        try {
            this.f0.delete();
            this.f1.delete();
            this.f2.delete();
            this.f3.delete();
            this.free();
        }
        catch (Exception x) {
            System.err.println("Exception occurred while cleaning up: " + x.getLocalizedMessage());
            x.printStackTrace();
        }
    }

    public void writeBDDConfig(BDDFactory bdd2, String fileName) throws IOException {
        try (BufferedWriter dos = null;){
            dos = new BufferedWriter(new FileWriter(fileName));
            int i = 0;
            while (i < bdd2.numberOfDomains()) {
                BDDDomain d = bdd2.getDomain(i);
                dos.write(String.valueOf(d.getName()) + " " + d.size() + "\n");
                ++i;
            }
        }
    }

    public long tryOrder(String factory, boolean reverse, String varOrder) {
        if (bdd == null) {
            this.initBDDFactory(factory);
        }
        TryThread t = new TryThread(reverse, varOrder);
        t.start();
        try {
            t.join(this.DELAY_TIME);
            if (t.initTime >= 0L) {
                t.join(this.bestCalcTime);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t.isAlive()) {
            this.setBDDError(1);
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.print("Free memory: " + Runtime.getRuntime().freeMemory());
            this.destroyBDDFactory();
            System.gc();
            System.out.println(" bytes -> " + Runtime.getRuntime().freeMemory() + " bytes");
        }
        if (t.computeTime < 0L) {
            if (t.initTime < 0L) {
                System.out.println("BDD factory took too long to initialize, aborted.");
            } else {
                System.out.println("Took too long to compute, aborted.");
            }
        } else if (t.computeTime < this.bestCalcTime) {
            this.bestOrder = varOrder;
            this.bestCalcTime = t.computeTime;
        }
        return t.computeTime;
    }

    public String getBestOrder() {
        return this.bestOrder;
    }

    public long getBestTime() {
        return this.bestCalcTime;
    }

    public static class BDDOperation {
        BDDFactory.BDDOp op;
        String filename1;
        String filename2;
        String filename3;
        BDD b1 = null;
        BDD b2 = null;
        BDD b3 = null;

        public BDDOperation() {
        }

        public BDDOperation(int op, String f1, String f2, String f3) {
            this.setOp(op);
            this.setFilenames(f1, f2, f3);
        }

        public void setOp(int op) {
            switch (op) {
                case 0: {
                    this.op = BDDFactory.and;
                    break;
                }
                case 1: {
                    this.op = BDDFactory.xor;
                    break;
                }
                case 2: {
                    this.op = BDDFactory.or;
                    break;
                }
                case 3: {
                    this.op = BDDFactory.nand;
                    break;
                }
                case 4: {
                    this.op = BDDFactory.nor;
                    break;
                }
                case 5: {
                    this.op = BDDFactory.imp;
                    break;
                }
                case 6: {
                    this.op = BDDFactory.biimp;
                    break;
                }
                case 7: {
                    this.op = BDDFactory.diff;
                    break;
                }
                case 8: {
                    this.op = BDDFactory.less;
                    break;
                }
                case 9: {
                    this.op = BDDFactory.invimp;
                    break;
                }
                default: {
                    throw new InternalError("Invalid op: " + op);
                }
            }
        }

        public void setFilenames(String f1, String f2, String f3) {
            this.filename1 = f1;
            this.filename2 = f2;
            this.filename3 = f3;
        }

        public void setVarOrder(boolean reverse, String varOrderToTry) {
            BDDFactory f = (BDDFactory)bdd;
            int[] varorder = f.makeVarOrdering(reverse, varOrderToTry);
            f.setVarOrder(varorder);
        }

        public void load() throws IOException {
            BDDFactory f = (BDDFactory)bdd;
            if (this.b1 == null) {
                this.b1 = f.load(this.filename1);
                this.b2 = f.load(this.filename2);
                this.b3 = f.load(this.filename3);
            }
        }

        public long doIt() {
            long t = System.currentTimeMillis();
            BDD result = this.b1.applyEx(this.b2, this.op, this.b3);
            long time = System.currentTimeMillis() - t;
            result.free();
            return time;
        }

        public void free() {
            this.b1.free();
            this.b1 = null;
            this.b2.free();
            this.b2 = null;
            this.b3.free();
            this.b3 = null;
        }
    }

    public class TryThread
    extends Thread {
        boolean reverse;
        String varOrderToTry;
        long initTime = -1L;
        long computeTime = -1L;

        TryThread(boolean r, String v) {
            this.reverse = r;
            this.varOrderToTry = v;
        }

        @Override
        public void run() {
            try {
                long time = System.currentTimeMillis();
                TryVarOrder.this.setVarOrder(this.reverse, this.varOrderToTry);
                TryVarOrder.this.load();
                this.initTime = time - System.currentTimeMillis();
                this.computeTime = TryVarOrder.this.doIt();
                TryVarOrder.this.free();
                System.out.println("Ordering: " + this.varOrderToTry + " time: " + time);
            }
            catch (Exception x) {
                System.err.println("Exception occurred while trying order: " + x.getLocalizedMessage());
                x.printStackTrace();
            }
        }
    }
}

