/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class Streams {
    private Streams() {
    }

    public static InputStream inputStream(Reader reader) {
        return new ReaderInputStream(reader);
    }

    public static OutputStream outputStream(Writer writer) {
        return new WriterOutputStream(writer);
    }

    public static void copy(Reader reader, Writer writer, int n) throws IOException {
        Streams.copy(new ReaderInputStream(reader), new WriterOutputStream(writer), n);
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        Streams.copy(new ReaderInputStream(reader), new WriterOutputStream(writer));
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        Streams.copy(inputStream, outputStream, 1024);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
        byte[] byArray = new byte[n];
        do {
            if ((n2 = bufferedInputStream.read(byArray, 0, n)) <= 0) continue;
            bufferedOutputStream.write(byArray, 0, n2);
        } while (n2 != -1);
        bufferedOutputStream.flush();
    }

    public static int eat(InputStream inputStream) throws IOException {
        EaterOutputStream eaterOutputStream = new EaterOutputStream();
        Streams.copy(inputStream, eaterOutputStream);
        return eaterOutputStream.getEaten();
    }

    private static class EaterOutputStream
    extends OutputStream {
        private int eaten = 0;

        private EaterOutputStream() {
        }

        public void write(int n) throws IOException {
            ++this.eaten;
        }

        public int getEaten() {
            return this.eaten;
        }
    }

    private static class WriterOutputStream
    extends OutputStream {
        private Writer myWriter;

        public WriterOutputStream(Writer writer) {
            this.myWriter = writer;
        }

        public void write(int n) throws IOException {
            this.myWriter.write(n);
        }

        public void flush() throws IOException {
            this.myWriter.flush();
        }

        public void close() throws IOException {
            this.myWriter.close();
        }
    }

    private static class ReaderInputStream
    extends InputStream {
        private Reader myReader;

        public ReaderInputStream(Reader reader) {
            this.myReader = reader;
        }

        public int read() throws IOException {
            return this.myReader.read();
        }

        public void close() throws IOException {
            this.myReader.close();
        }
    }
}

