/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.lang;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class NestedException
extends Exception
implements Serializable {
    public static final int UNKNOWN = -1;
    private Throwable myAssociatedException = null;
    private int myErrorCode = -1;
    private String myMoreInformation = null;

    public NestedException(String string) {
        this(string, 0);
    }

    public NestedException(String string, int n) {
        this(null, string, n);
    }

    public NestedException(int n) {
        this("" + n, n);
    }

    public NestedException(Throwable throwable, String string, int n) {
        super(string);
        this.myAssociatedException = throwable;
        this.myErrorCode = this.getRangeMin() + n;
    }

    public NestedException(Throwable throwable) {
        this(throwable, 0);
    }

    public NestedException(Throwable throwable, String string) {
        this(throwable, string, 0);
    }

    public NestedException(Throwable throwable, int n) {
        this(throwable, throwable.getLocalizedMessage(), n);
    }

    public int getRangeMin() {
        return 0;
    }

    public Throwable getNestedError() {
        return this.myAssociatedException;
    }

    public Throwable getOriginalError() {
        if (null == this.getNestedError()) {
            return this;
        }
        if (this.myAssociatedException instanceof NestedException) {
            return ((NestedException)this.myAssociatedException).getOriginalError();
        }
        return this.myAssociatedException;
    }

    public Enumeration nestedErrors() {
        return new NestedErrorEnumeration(this);
    }

    public final int getErrorCode() {
        return this.myErrorCode;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(new OutputStreamWriter(printStream)));
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (null == this.getNestedError()) {
            super.printStackTrace(printWriter);
        } else {
            this.getNestedError().printStackTrace(printWriter);
        }
        printWriter.println(this.getClass().getName() + " (Error Code=" + this.getErrorCode() + ") : " + this.getMessage());
        printWriter.flush();
    }

    public final void setMoreInfo(String string) {
        this.myMoreInformation = string;
    }

    public final String getMoreInfo() {
        return this.myMoreInformation;
    }

    private static class NestedErrorEnumeration
    implements Enumeration {
        Throwable myNextException = null;

        public NestedErrorEnumeration(Throwable throwable) {
            this.myNextException = throwable;
        }

        public boolean hasMoreElements() {
            return null != this.myNextException;
        }

        public Object nextElement() throws NoSuchElementException {
            if (null == this.myNextException) {
                throw new NoSuchElementException();
            }
            Throwable throwable = this.myNextException;
            this.myNextException = throwable instanceof NestedException ? ((NestedException)this.myNextException).getNestedError() : null;
            return throwable;
        }
    }
}

