/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.net.mail;

import com.tlabs.net.mail.MailSupportException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.UID;
import javax.activation.DataSource;

class OctetStreamDataSource
implements DataSource {
    private String myContentType = "application/octet-stream";
    private Object myContent = null;

    protected OctetStreamDataSource() throws MailSupportException {
    }

    public OctetStreamDataSource(byte[] byArray) throws MailSupportException {
        this();
        this.setContent(byArray);
    }

    public OctetStreamDataSource(String string) throws MailSupportException {
        this();
        this.setContent(string);
    }

    public OctetStreamDataSource(InputStream inputStream) throws MailSupportException {
        this();
        this.setContent(inputStream);
    }

    public String getContentType() {
        return this.myContentType;
    }

    protected final void setContentType(String string) {
        this.myContentType = string;
    }

    public final InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream((byte[])this.myContent);
    }

    public String getName() {
        return new UID() + ".dat";
    }

    public final Object getObject() {
        return this.myContent;
    }

    protected final void setContent(byte[] byArray) throws MailSupportException {
        this.myContent = byArray;
    }

    protected final void setContent(String string) throws MailSupportException {
        this.setContent(string.getBytes());
    }

    protected final void setContent(InputStream inputStream) throws MailSupportException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[inputStream.available()];
            bufferedInputStream.read(byArray, 0, byArray.length);
            bufferedInputStream.close();
            this.myContent = byArray;
        }
        catch (IOException iOException) {
            throw new MailSupportException(iOException.getLocalizedMessage());
        }
    }

    public final OutputStream getOutputStream() throws IOException {
        throw new IOException("Read-only DataSource");
    }
}

