/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.servlet;

import com.tlabs.servlet.HttpServletRequestHandler;
import com.tlabs.util.EnumerationAdapter;
import com.tlabs.util.debug.Debug;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExtensibleHttpServlet
extends HttpServlet {
    private static final String INIT_DEBUG_PROPERTIES = "log4j.properties";
    private List myHandlerList = new LinkedList();
    private boolean myHandlersChainable = false;

    public synchronized void setHandlersChainable(boolean bl) {
        this.myHandlersChainable = bl;
    }

    public boolean getHandlersChainable() {
        return this.myHandlersChainable;
    }

    public synchronized void addHandler(HttpServletRequestHandler httpServletRequestHandler) throws ServletException {
        httpServletRequestHandler.init(this.getServletConfig());
        this.myHandlerList.add(httpServletRequestHandler);
        this.log("Added handler \"" + httpServletRequestHandler.getName() + "\" (" + httpServletRequestHandler + ")");
    }

    public synchronized void removeHandler(HttpServletRequestHandler httpServletRequestHandler) {
        this.myHandlerList.remove(httpServletRequestHandler);
        httpServletRequestHandler.destroy();
        this.log("Removed handler \"" + httpServletRequestHandler.getName() + "\" (" + httpServletRequestHandler + ")");
    }

    protected final Enumeration handlers() {
        return new EnumerationAdapter(this.myHandlerList.listIterator());
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initDebug(servletConfig);
        this.initHandlers(servletConfig);
    }

    public synchronized void destroy() {
        for (int i = 0; i < this.myHandlerList.size(); ++i) {
            this.removeHandler((HttpServletRequestHandler)this.myHandlerList.get(i));
        }
        super.destroy();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl = false;
        boolean bl2 = this.getHandlersChainable();
        for (int i = 0; i < this.myHandlerList.size(); ++i) {
            HttpServletRequestHandler httpServletRequestHandler = (HttpServletRequestHandler)this.myHandlerList.get(i);
            if (httpServletRequestHandler.accept(httpServletRequest)) {
                bl = true;
                try {
                    httpServletRequestHandler.handleRequest(httpServletRequest, httpServletResponse);
                }
                catch (IOException iOException) {
                    this.log(iOException);
                    throw iOException;
                }
                catch (ServletException servletException) {
                    this.log((Exception)((Object)servletException));
                    throw servletException;
                }
            }
            if (!bl2 && bl) break;
        }
        if (!bl) {
            httpServletResponse.setStatus(400);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected final void log(Exception exception) {
        this.log(ExtensibleHttpServlet.getStackTrace(exception));
    }

    protected static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        return stringWriter.toString();
    }

    private void initDebug(ServletConfig servletConfig) throws ServletException {
        String string = servletConfig.getInitParameter(INIT_DEBUG_PROPERTIES);
        if (null == string) {
            this.log("log4j.properties - parameter not set - using default for logging");
            Debug.configure();
        } else {
            try {
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
                ((InputStream)fileInputStream).close();
                Debug.configure(properties);
            }
            catch (IOException iOException) {
                this.log(iOException.getLocalizedMessage());
                this.log("log4j.properties - cannot load logging parameters (" + string + ") - using default");
                Debug.configure();
            }
        }
    }

    private void initHandlers(ServletConfig servletConfig) throws ServletException {
        for (int i = 0; i < this.myHandlerList.size(); ++i) {
            ((HttpServletRequestHandler)this.myHandlerList.get(i)).init(servletConfig);
        }
    }
}

