/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;

public class SwingTools {
    private SwingTools() {
        throw new Error("SwingTools only contain static methods and cannot be instantiated.");
    }

    public static Frame getParentFrame(Component component) {
        if (null == component) {
            return null;
        }
        Container container = component.getParent();
        if (null == container) {
            return component instanceof Frame ? (Frame)component : null;
        }
        return SwingTools.getParentFrame(component.getParent());
    }

    public static void centerOnParent(Component component) {
        if (null == component.getParent()) {
            SwingTools.centerOnScreen(component);
            return;
        }
        SwingTools.centerOnComponent(component, component.getParent());
    }

    public static void centerOnScreen(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        component.setLocation(point);
    }

    public static void centerOnComponent(Component component, Component component2) {
        if (null == component) {
            return;
        }
        if (null == component2) {
            SwingTools.centerOnScreen(component);
            return;
        }
        Dimension dimension = component2.getSize();
        Dimension dimension2 = component.getSize();
        Point point = component2.getLocation();
        Point point2 = new Point(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
        component.setLocation(point2);
    }

    public static void setAllEnabled(Container container, boolean bl) {
        if (null == container) {
            return;
        }
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
            if (!(componentArray[i] instanceof Container)) continue;
            SwingTools.setAllEnabled((Container)componentArray[i], bl);
        }
    }
}

