/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.swing;

import com.tlabs.swing.TableMap;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends TableMap {
    private int[] indexes;
    private int sortingColumn;
    private boolean ascending = true;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TableSorter() {
        this.indexes = new int[0];
        this.sortingColumn = -1;
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
        this.sortingColumn = -1;
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        Object object;
        String string;
        Class<?> clazz = this.model.getColumnClass(n3);
        TableModel tableModel = this.model;
        Object object2 = tableModel.getValueAt(n, n3);
        Object object3 = tableModel.getValueAt(n2, n3);
        if (object2 == null && object3 == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object3 == null) {
            return 1;
        }
        if (clazz.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = TableSorter.class$("java.lang.Number")) : class$java$lang$Number)) {
            Number number;
            double d;
            Number number2 = (Number)tableModel.getValueAt(n, n3);
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)tableModel.getValueAt(n2, n3)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (clazz == (class$java$util$Date == null ? (class$java$util$Date = TableSorter.class$("java.util.Date")) : class$java$util$Date)) {
            Date date;
            long l;
            Date date2 = (Date)tableModel.getValueAt(n, n3);
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)tableModel.getValueAt(n2, n3)).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = TableSorter.class$("java.lang.String")) : class$java$lang$String)) {
            String string2;
            String string3 = (String)tableModel.getValueAt(n, n3);
            int n4 = string3.compareTo(string2 = (String)tableModel.getValueAt(n2, n3));
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TableSorter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)tableModel.getValueAt(n, n3);
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)tableModel.getValueAt(n2, n3)).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        Object object4 = tableModel.getValueAt(n, n3);
        String string4 = object4.toString();
        int n5 = string4.compareTo(string = (object = tableModel.getValueAt(n2, n3)).toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int n, int n2) {
        int n3 = this.compareRowsByColumn(n, n2, this.sortingColumn);
        if (n3 != 0) {
            return this.ascending ? n3 : -n3;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        this.sort(this);
        super.tableChanged(tableModelEvent);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            for (int i = n; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    public Object getValueAt(int n, int n2) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        this.model.setValueAt(object, this.indexes[n], n2);
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortingColumn = n;
        this.sort(this);
        this.repaintHeaderCorrectly();
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(final JTable jTable) {
        jTable.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                int n = jTable.convertColumnIndexToModel(tableColumnModel.getColumnIndexAtX(mouseEvent.getX()));
                if (mouseEvent.getClickCount() == 1 && n > -1) {
                    boolean bl;
                    int n2 = mouseEvent.getModifiers() & 1;
                    boolean bl2 = bl = n2 == 0;
                    if (n == TableSorter.this.sortingColumn) {
                        bl = !TableSorter.this.ascending;
                    }
                    TableSorter.this.sortByColumn(n, bl);
                }
            }
        };
        jTable.getTableHeader().addMouseListener(mouseAdapter);
    }

    public String getColumnName(int n) {
        String string = super.getColumnName(n);
        if (n != this.sortingColumn) {
            return string;
        }
        return this.ascending ? string + " v" : string + " ^";
    }

    public void repaintHeaderCorrectly() {
        this.fireTableRowsUpdated(-1, -1);
    }

    public int getNewRowIndex(int n) {
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] != n) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public int getOriginalRowIndex(int n) {
        return this.indexes[n];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

