/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class Interval
implements Cloneable {
    private static Comparator _startComparator = new StartComparator();
    private static Comparator _endComparator = new EndComparator();
    private long _start;
    private long _end;

    public Interval(long l, long l2) {
        if (l2 <= l) {
            throw new IllegalArgumentException(this.getClass().getName() + "-> End <= Start");
        }
        this._start = l;
        this._end = l2;
    }

    public boolean intersects(Interval interval) {
        return this.inter(interval) != null;
    }

    public boolean contains(long l) {
        return l >= this._start && l <= this._end;
    }

    public boolean contains(Interval interval) {
        return interval.getStart() >= this._start && interval.getEnd() <= this._end;
    }

    public long getStart() {
        return this._start;
    }

    public long getEnd() {
        return this._end;
    }

    public Interval inter(Interval interval) {
        long l;
        long l2 = Math.max(this._start, interval.getStart());
        if (l2 >= (l = Math.min(this._end, interval.getEnd()))) {
            return null;
        }
        return new Interval(l2, l);
    }

    public Vector union(Interval interval) {
        Vector<Object> vector = new Vector<Object>(2);
        if (this.equals(interval)) {
            vector.add(this.clone());
        } else if (this.intersects(interval)) {
            if (this.contains(interval)) {
                vector.add(this.clone());
            } else if (interval.contains(this)) {
                vector.add(interval.clone());
            } else {
                long l = Math.min(this._start, interval.getStart());
                long l2 = Math.max(this._end, interval.getEnd());
                vector.addElement(new Interval(l, l2));
            }
        } else {
            vector.add(this.clone());
            vector.add(interval.clone());
        }
        vector.trimToSize();
        Collections.sort(vector, this.getStartComparator());
        return vector;
    }

    public Comparator getStartComparator() {
        return _startComparator;
    }

    public Comparator getEndComparator() {
        return _endComparator;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (!(object instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)object;
        return this.getStart() == interval.getStart() && this.getEnd() == interval.getEnd();
    }

    public Object clone() {
        try {
            return (Interval)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getLocalizedMessage());
        }
    }

    private static class EndComparator
    implements Comparator {
        private EndComparator() {
        }

        public int compare(Object object, Object object2) {
            Interval interval = (Interval)object;
            Interval interval2 = (Interval)object2;
            if (interval.getEnd() == interval2.getEnd()) {
                return 0;
            }
            if (interval.getEnd() < interval2.getEnd()) {
                return -1;
            }
            return 1;
        }
    }

    private static class StartComparator
    implements Comparator {
        private StartComparator() {
        }

        public int compare(Object object, Object object2) {
            Interval interval = (Interval)object;
            Interval interval2 = (Interval)object2;
            if (interval.getStart() == interval2.getStart()) {
                return 0;
            }
            if (interval.getStart() < interval2.getStart()) {
                return -1;
            }
            return 1;
        }
    }
}

