/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import com.tlabs.util.Observer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

class ObserverEventFiring
implements Runnable {
    private List _observers;
    private EventObject _event;
    private String _methodName = null;

    public ObserverEventFiring(EventObject eventObject, Vector vector, String string) {
        this._event = eventObject;
        this._observers = (Vector)vector.clone();
        this._methodName = string;
    }

    public void run() {
        this.fireEvent();
    }

    public void fireEvent() {
        Iterator iterator = this._observers.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                if (null == this._methodName) {
                    ((Observer)e).eventPerformed(this._event);
                    continue;
                }
                Class[] classArray = new Class[]{this._event.getClass()};
                Method method = e.getClass().getMethod(this._methodName, classArray);
                Object[] objectArray = new EventObject[]{this._event};
                try {
                    method.invoke(e, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace(System.out);
                    System.out.println(this.getClass().getName() + ".fireEvent() : " + invocationTargetException.getMessage());
                    System.out.println("Exception happened in \"" + this._methodName + "\"");
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                System.out.println(this.getClass().getName() + ".fireEvent() : " + exception.getMessage());
                System.out.println("No such method or wrong Class \"" + this._methodName + "\"");
                System.out.println("Event dropped !");
            }
        }
    }

    public static void fireEventNow(EventObject eventObject, Vector vector) {
        ObserverEventFiring.fireEventNow(eventObject, vector, null);
    }

    public static void fireEventLater(EventObject eventObject, Vector vector) {
        ObserverEventFiring.fireEventLater(eventObject, vector, null);
    }

    public static void fireEventNow(EventObject eventObject, Vector vector, String string) {
        new ObserverEventFiring(eventObject, vector, string).fireEvent();
    }

    public static void fireEventLater(EventObject eventObject, Vector vector, String string) {
        new ObserverEventFiring(eventObject, vector, string).run();
    }
}

