/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.Timer;

public final class ProcessRunner {
    private boolean _isRunning = false;
    private StringWriter _outWriter;
    private StringWriter _errWriter;
    private Thread _processThread = null;
    private Process _process = null;

    public String runProcess(String[] stringArray) {
        return this.runProcess(stringArray, -1, -1);
    }

    public synchronized String runProcess(String[] stringArray, int n, int n2) {
        int n3;
        String string = new String("");
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            string = string + stringArray[n3] + " ";
        }
        string = string.trim();
        System.out.println(this.getClass().getName() + "Run Process (lines=" + n + "/timeout=" + n2 + ")");
        System.out.println("(Run)=>" + string);
        this._outWriter = new StringWriter();
        this._errWriter = new StringWriter();
        if (-1 != n2) {
            TimerWatch timerWatch = new TimerWatch(n2);
        }
        this._processThread = Thread.currentThread();
        try {
            n3 = this.execute(string, n);
            String string2 = this._errWriter.toString();
            if (null == string2 || string2.length() == 0) {
                string2 = this._outWriter.toString();
            }
            return string2;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return iOException.getMessage();
        }
    }

    public void stopProcess() {
        if (null != this._processThread && this._processThread.isAlive()) {
            System.out.println("Interrupting process");
            this._processThread.interrupt();
        }
        if (null != this._process) {
            this._process.destroy();
        }
    }

    private boolean isRunning() {
        return this._isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int execute(String string, int n) throws IOException {
        this._process = Runtime.getRuntime().exec(string);
        this._isRunning = true;
        StreamPump streamPump = null;
        StreamPump streamPump2 = null;
        try {
            try {
                streamPump = new StreamPump(new InputStreamReader(this._process.getErrorStream()), this._errWriter, n);
                streamPump2 = new StreamPump(new InputStreamReader(this._process.getInputStream()), this._outWriter, n);
                this._process.waitFor();
                streamPump2.join();
                streamPump.join();
                System.out.println(this.getClass().getName() + " : Process finished normally");
            }
            catch (InterruptedException interruptedException) {
                System.out.println(this.getClass().getName() + " : Interrupted Process");
                Object var7_6 = null;
                streamPump.close();
                streamPump2.close();
                this._processThread = null;
                this._isRunning = false;
                this._process = null;
            }
            Object var7_5 = null;
            streamPump.close();
            streamPump2.close();
            this._processThread = null;
            this._isRunning = false;
            this._process = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            streamPump.close();
            streamPump2.close();
            this._processThread = null;
            this._isRunning = false;
            this._process = null;
            throw throwable;
        }
        return null == this._process ? -1 : this._process.exitValue();
    }

    class StreamPump
    implements Runnable {
        private int _maxLinesCount = -1;
        private int _currentLinesCount = 0;
        private String _linesSeparator = System.getProperty("line.separator");
        private Reader _fromReader;
        private Writer _toWriter;
        private Thread _thread;

        public StreamPump(Reader reader, Writer writer, int n) {
            this._fromReader = reader;
            this._toWriter = writer;
            this._maxLinesCount = n;
            this._thread = new Thread(this);
            this._thread.start();
        }

        public void run() {
            while (this._thread != null) {
                try {
                    int n = this._fromReader.read();
                    if (-1 == n) {
                        this.close();
                        continue;
                    }
                    this._toWriter.write((char)n);
                    if (n == this._linesSeparator.charAt(0)) {
                        System.out.print(".");
                        System.out.flush();
                        ++this._currentLinesCount;
                    }
                    this._toWriter.flush();
                    if (-1 == this._maxLinesCount || this._currentLinesCount != this._maxLinesCount) continue;
                    this._thread = null;
                    System.out.println("(Run)Lines limit reached - Interrupting");
                    ProcessRunner.this.stopProcess();
                }
                catch (IOException iOException) {
                    this._thread = null;
                }
            }
        }

        public synchronized void close() {
            this._thread = null;
        }

        protected void join() {
            if (null != this._thread) {
                try {
                    this._thread.join();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(this.getClass().getName() + ".join() : interrupted");
                }
            }
        }
    }

    class TimerWatch
    implements ActionListener {
        private Timer _timer;

        public TimerWatch(int n) {
            if (n < 1000) {
                System.out.println(ProcessRunner.this.getClass().getName() + "Timeout set up to a second (too low)");
                n = 1000;
            }
            this._timer = new Timer(n, this);
            this._timer.setRepeats(false);
        }

        public void start() {
            if (!this._timer.isRunning()) {
                this._timer.start();
            }
        }

        public void stop() {
            if (this._timer.isRunning()) {
                this._timer.stop();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ProcessRunner.this.isRunning()) {
                System.out.println("(Run) Timeout Elapsed - Interrupting.");
                ProcessRunner.this.stopProcess();
            }
        }
    }
}

