/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class PropertyObject
implements Serializable {
    public static final String COMMENT_STRING = "#";
    public static final String KEY_VALUE_SEPARATOR = "=";
    private Hashtable _properties = new Hashtable();
    private transient PropertyChangeSupport _propertySupport = new PropertyChangeSupport(this);

    public void setDefaultProperties() {
    }

    public final Enumeration propertyNames() {
        return this._properties.keys();
    }

    public final Enumeration properties() {
        return this._properties.elements();
    }

    public final Object getProperty(String string) {
        return this._properties.get(string);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this._propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this._propertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public final void setProperty(String string, Object object) {
        if (null == string) {
            throw new IllegalArgumentException(this + ".setProperty() : Invalid propertyName (NULL)");
        }
        Object v = this._properties.remove(string);
        if (null != object) {
            this._properties.put(string, object);
        }
        if (object != v) {
            this._propertySupport.firePropertyChange(string, v, object);
        }
    }

    public final void removeProperty(String string) {
        this.setProperty(string, null);
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public void load(Reader reader) throws IOException {
        String string;
        String string2 = (String)this.getProperty(COMMENT_STRING);
        if (null != string2 && string2.length() == 0) {
            string2 = null;
        }
        if (null != (string = (String)this.getProperty(KEY_VALUE_SEPARATOR)) && string.length() == 0) {
            string = null;
        }
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            int n;
            if (null != string2 && (null == string2 || string3.startsWith(string2))) continue;
            int n2 = n = null == string ? -1 : string3.indexOf(string);
            if (-1 == n) {
                this.setProperty(string3, string3);
                continue;
            }
            if (n == string3.length() - 1) {
                this.setProperty(string3, "");
                continue;
            }
            this.setProperty(string3.substring(0, n), string3.substring(n + 1));
        }
    }

    protected final Map getInternalMap() {
        return this._properties;
    }

    protected void clearProperties() {
        this._properties.clear();
    }

    protected void finalize() throws Throwable {
        this._properties.clear();
        this._properties = null;
        this._propertySupport = null;
        super.finalize();
    }
}

