/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import com.tlabs.util.ResourceManager;
import com.tlabs.util.ResourceParser;
import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class Resource
implements Map {
    private ResourceManager _resourceManager = new ResourceManager();
    protected static Resource singleton = null;
    static /* synthetic */ Class class$com$tlabs$util$Resource;

    protected Resource() {
        this._resourceManager.addParser(new CommaSeparatedPropertyParser());
        this._resourceManager.addParser(new PropertiesParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getInstance() {
        if (null == singleton) {
            Class clazz = class$com$tlabs$util$Resource == null ? (class$com$tlabs$util$Resource = Resource.class$("com.tlabs.util.Resource")) : class$com$tlabs$util$Resource;
            synchronized (clazz) {
                if (null == singleton) {
                    singleton = Resource.newInstance();
                }
            }
        }
        return singleton;
    }

    public static Resource newInstance() {
        return new Resource();
    }

    public static Resource newInstance(ResourceBundle resourceBundle) {
        Resource resource = Resource.newInstance();
        resource.add(resourceBundle);
        return resource;
    }

    public static Resource newInstance(String string) {
        Resource resource = Resource.newInstance();
        resource.add(string);
        return resource;
    }

    public static Resource newInstance(InputStream inputStream) {
        Resource resource = Resource.newInstance();
        resource.add(inputStream);
        return resource;
    }

    public static Resource newInstance(URL uRL) {
        Resource resource = Resource.newInstance();
        resource.add(uRL);
        return resource;
    }

    public final Properties toProperties() {
        Properties properties = new Properties();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = this.get(e);
            if (null == object) continue;
            properties.put(e.toString(), object.toString());
        }
        return properties;
    }

    public final boolean add(ResourceBundle resourceBundle) {
        return this._resourceManager.add(resourceBundle, false);
    }

    public final boolean add(InputStream inputStream) {
        return this._resourceManager.add(inputStream, false);
    }

    public final boolean add(File file) {
        return this.add(file, false);
    }

    public final boolean add(File file, boolean bl) {
        return this._resourceManager.add(file, bl);
    }

    public final boolean add(Properties properties) {
        this._resourceManager.getInternalMap().putAll(properties);
        return properties.size() > 0;
    }

    public final boolean add(URL uRL, boolean bl) {
        return this._resourceManager.add(uRL, bl);
    }

    public final boolean add(URL uRL) {
        return this.add(uRL, false);
    }

    public final boolean add(String string) {
        return this.add(string, false);
    }

    public final boolean add(String string, boolean bl) {
        return this._resourceManager.add(string, bl);
    }

    public final String getString(String string, String string2) throws ClassCastException {
        String string3 = null;
        try {
            string3 = (String)this.get(string);
        }
        catch (MissingResourceException missingResourceException) {
            string3 = null;
        }
        return null == string3 ? string2 : string3;
    }

    public final String getString(String string) throws ClassCastException {
        return this.getString(string, string);
    }

    public final String formatString(String string, Object object) throws ClassCastException {
        Object[] objectArray = new Object[]{object};
        return this.formatString(string, objectArray);
    }

    public final String formatString(String string, Object object, String string2) throws ClassCastException {
        Object[] objectArray = new Object[]{object};
        return this.formatString(string, objectArray, string2);
    }

    public final String formatString(String string, Object[] objectArray) throws ClassCastException {
        return this.formatString(string, objectArray, string);
    }

    public final String formatString(String string, Object[] objectArray, String string2) throws ClassCastException {
        String string3 = this.getString(string, string2);
        if (null == objectArray) {
            return string3;
        }
        return null == string3 ? null : MessageFormat.format(string3, objectArray);
    }

    public final Integer getInt(String string) {
        try {
            return (Integer)this.get(string);
        }
        catch (ClassCastException classCastException) {
            String string2 = this.getString(string);
            if (string2.equals(string)) {
                return null;
            }
            try {
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    public final Long getLong(String string) {
        try {
            return (Long)this.get(string);
        }
        catch (ClassCastException classCastException) {
            String string2 = this.getString(string);
            if (string2.equals(string)) {
                return null;
            }
            try {
                return Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    public static final String getString(ResourceBundle resourceBundle, String string) throws ClassCastException {
        String string2 = (String)resourceBundle.getObject(string);
        return null == string2 ? string : string2;
    }

    public static final Integer getInt(ResourceBundle resourceBundle, String string) {
        try {
            return (Integer)resourceBundle.getObject(string);
        }
        catch (ClassCastException classCastException) {
            try {
                return new Integer((String)resourceBundle.getObject(string));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    public final String[] getStringArray(String string, String string2) {
        Object object = this.get(string);
        if (null == object) {
            return new String[0];
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (!(object instanceof String)) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        this.put(string, stringArray);
        return stringArray;
    }

    public final Image getImage(String string, Applet applet) {
        return null == applet ? null : applet.getImage(this.getClass().getResource(string));
    }

    public final Image[] getImages(String string, Applet applet) {
        if (null == applet) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        URL uRL = this.getClass().getResource(string + n);
        if (null == uRL) {
            return null;
        }
        ArrayList<Image> arrayList = new ArrayList<Image>();
        MediaTracker mediaTracker = new MediaTracker(applet);
        while (uRL != null) {
            Image image = applet.getImage(uRL);
            if (null != image) {
                mediaTracker.addImage(image, n2);
                arrayList.add(image);
                ++n2;
            }
            uRL = this.getClass().getResource(string + ++n);
        }
        if (n2 > 0) {
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                return new Image[0];
            }
        }
        return arrayList.toArray(new Image[0]);
    }

    public final URL getURL(String string) {
        URL uRL;
        block8: {
            uRL = null;
            Object object = this.get(string);
            if (object != null) {
                try {
                    uRL = (URL)object;
                }
                catch (ClassCastException classCastException) {
                    if (!(object instanceof String)) break block8;
                    String string2 = (String)object;
                    try {
                        uRL = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            uRL = new URL("file", "localhost", string2);
                            File file = new File(uRL.getFile());
                            if (!file.exists()) {
                                uRL = null;
                            }
                        }
                        catch (MalformedURLException malformedURLException2) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return uRL;
    }

    public final ImageIcon getIcon(String string) {
        URL uRL = this.getURL(string);
        if (null == uRL) {
            String string2 = this.getString(string, string);
            uRL = this.getClass().getResource(string2);
            if (null == uRL) {
                uRL = this.getClass().getClassLoader().getResource(string2);
            }
            if (null == uRL) {
                this.getClass().getClassLoader();
                uRL = ClassLoader.getSystemResource(string2);
            }
        }
        if (null == uRL) {
            return null;
        }
        return new ImageIcon(uRL);
    }

    public final Set keySubset(Object object, Comparator comparator) {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (comparator.compare(object, e) != 0) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public final Set objectSubset(Object object, Comparator comparator) {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (comparator.compare(object, e) != 0) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public final Properties propertiesKeySubset(Object object, Comparator comparator) {
        Properties properties = new Properties();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (comparator.compare(object, e) != 0) continue;
            properties.put(e, this.get(e));
        }
        return properties;
    }

    public final Properties propertiesSubsetStartingWith(String string) {
        return this.propertiesKeySubset(string, new StringCollector());
    }

    public void mergeAll(Map map) {
        this.keySet().addAll(map.keySet());
    }

    public void clear() {
        this._resourceManager.getInternalMap().clear();
    }

    public boolean containsKey(Object object) {
        return this._resourceManager.getInternalMap().containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this._resourceManager.getInternalMap().containsValue(object);
    }

    public Set entrySet() {
        return this._resourceManager.getInternalMap().entrySet();
    }

    public boolean equals(Object object) {
        return ((Object)this._resourceManager.getInternalMap()).equals(object);
    }

    public Object get(Object object) {
        return this._resourceManager.getInternalMap().get(object);
    }

    public int hashCode() {
        return ((Object)this._resourceManager.getInternalMap()).hashCode();
    }

    public boolean isEmpty() {
        return this._resourceManager.getInternalMap().isEmpty();
    }

    public Set keySet() {
        return this._resourceManager.getInternalMap().keySet();
    }

    public final Enumeration keys() {
        return this._resourceManager.keys();
    }

    public Object put(Object object, Object object2) {
        return this._resourceManager.getInternalMap().put(object, object2);
    }

    public void putAll(Map map) {
        this._resourceManager.getInternalMap().putAll(map);
    }

    public Object remove(Object object) {
        return this._resourceManager.getInternalMap().remove(object);
    }

    public int size() {
        return this._resourceManager.getInternalMap().size();
    }

    public Collection values() {
        return this._resourceManager.getInternalMap().values();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StringCollector
    implements Comparator {
        StringCollector() {
        }

        public int compare(Object object, Object object2) {
            if (!object.getClass().isInstance(object2)) {
                return -1;
            }
            if (!(object instanceof String)) {
                return -1;
            }
            String string = (String)object;
            String string2 = (String)object2;
            return string.startsWith(string2) || string2.startsWith(string) ? 0 : 1;
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }
    }

    class PropertiesParser
    implements ResourceParser {
        PropertiesParser() {
        }

        public Hashtable parseResource(InputStream inputStream) throws IOException {
            Properties properties = new Properties();
            properties.load(inputStream);
            return properties;
        }
    }

    class CommaSeparatedPropertyParser
    implements ResourceParser {
        private static final String COMMA = ",";
        private static final String EQUALS = "=";
        private static final String HASH = "#";

        CommaSeparatedPropertyParser() {
        }

        public Hashtable parseResource(InputStream inputStream) throws IOException {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            while (null != (string = bufferedReader.readLine())) {
                if (string.trim().startsWith(HASH)) continue;
                int n = string.indexOf(EQUALS);
                if (-1 == n) {
                    n = string.indexOf(COMMA);
                }
                if (-1 == n) {
                    hashtable.put(string.trim(), "");
                    continue;
                }
                hashtable.put(string.substring(0, n).trim(), string.substring(n + 1, string.length()).trim());
            }
            return hashtable;
        }
    }
}

