/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import com.tlabs.util.SchedulerTask;
import com.tlabs.util.Timer;
import com.tlabs.util.TimerTask;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Scheduler {
    private Timer myTimer = null;
    private Vector myTasks;
    private boolean myIsDaemon;

    public Scheduler() {
        this(false);
    }

    public Scheduler(boolean bl) {
        this.myIsDaemon = bl;
        this.myTasks = new Vector();
    }

    public final synchronized void clear() {
        Iterator iterator = this.myTasks.iterator();
        while (iterator.hasNext()) {
            ((SchedulerTask)iterator.next()).cancel();
            iterator.remove();
        }
        this.myTasks.clear();
    }

    public final synchronized void dispose() {
        this.clear();
        if (null != this.myTimer) {
            this.myTimer.cancel();
            this.myTimer = null;
        }
    }

    public void addTask(SchedulerTask schedulerTask) throws IllegalArgumentException {
        long l = schedulerTask.getInitialDate().getTime() - new Date().getTime();
        long l2 = l = l < 0L ? 0L : l;
        if (schedulerTask.isCancelled()) {
            schedulerTask.reset();
        }
        if (schedulerTask.getRepeatCount() == 1L) {
            this.getTimer().schedule((TimerTask)schedulerTask, l);
        } else if (schedulerTask.isFixedRepeatRate()) {
            this.getTimer().scheduleAtFixedRate((TimerTask)schedulerTask, l, schedulerTask.getRepeatDelay());
        } else {
            this.getTimer().schedule((TimerTask)schedulerTask, l, schedulerTask.getRepeatDelay());
        }
        this.myTasks.add(schedulerTask);
    }

    public boolean removeTask(SchedulerTask schedulerTask) {
        if (this.myTasks.remove(schedulerTask)) {
            schedulerTask.cancel();
            return true;
        }
        return false;
    }

    public boolean containsTask(SchedulerTask schedulerTask) {
        return this.myTasks.contains(schedulerTask);
    }

    public int getTaskCount() {
        return this.myTasks.size();
    }

    public final Enumeration tasks() {
        return this.myTasks.elements();
    }

    public final Enumeration completedTasks() {
        return new TaskEnumerationAdapter(this.tasks()){

            public boolean accept(SchedulerTask schedulerTask) {
                return schedulerTask.isCompleted();
            }
        };
    }

    public final Enumeration pendingTasks() {
        return new TaskEnumerationAdapter(this.tasks()){

            public boolean accept(SchedulerTask schedulerTask) {
                return !schedulerTask.isCompleted();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer getTimer() {
        if (null == this.myTimer) {
            Scheduler scheduler = this;
            synchronized (scheduler) {
                if (null == this.myTimer) {
                    this.myTimer = new Timer(this.myIsDaemon);
                }
            }
        }
        return this.myTimer;
    }

    private static abstract class TaskEnumerationAdapter
    implements Enumeration {
        private Enumeration myBackingEnumeration;
        private SchedulerTask myNextTask;

        public TaskEnumerationAdapter(Enumeration enumeration) {
            this.myBackingEnumeration = enumeration;
            this.myNextTask = this.nextElementImpl();
        }

        public abstract boolean accept(SchedulerTask var1);

        public boolean hasMoreElements() {
            return null != this.myNextTask;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            SchedulerTask schedulerTask = this.myNextTask;
            this.myNextTask = this.nextElementImpl();
            return schedulerTask;
        }

        private SchedulerTask nextElementImpl() {
            SchedulerTask schedulerTask = null;
            if (this.myBackingEnumeration.hasMoreElements() && !this.accept(schedulerTask = (SchedulerTask)this.myBackingEnumeration.nextElement())) {
                schedulerTask = this.nextElementImpl();
            }
            return schedulerTask;
        }
    }
}

