/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util.debug.log4j;

import com.tlabs.util.debug.DebugFactory;
import com.tlabs.util.debug.log4j.Log;
import com.tlabs.util.debug.log4j.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public final class Log4jDebug
implements DebugFactory {
    private static DebugFactory mySingleton = null;
    private Map myEnabledFlags = new Hashtable();
    static /* synthetic */ Class class$com$tlabs$util$debug$log4j$Log4jDebug;

    private Log4jDebug() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugFactory getInstance() {
        if (null == mySingleton) {
            Class clazz = class$com$tlabs$util$debug$log4j$Log4jDebug == null ? (class$com$tlabs$util$debug$log4j$Log4jDebug = Log4jDebug.class$("com.tlabs.util.debug.log4j.Log4jDebug")) : class$com$tlabs$util$debug$log4j$Log4jDebug;
            synchronized (clazz) {
                if (null == mySingleton) {
                    mySingleton = new Log4jDebug();
                }
            }
        }
        return mySingleton;
    }

    public final void configure(String string) {
        this.reset();
        if (null == string) {
            BasicConfigurator.configure();
        } else {
            PropertyConfigurator.configure((String)string);
        }
        this.setCategoryEnabledFlags();
    }

    public final void configure(Properties properties) {
        this.reset();
        if (null == properties) {
            BasicConfigurator.configure();
        } else {
            String string = properties.getProperty("debug.file", null);
            if (null == string) {
                PropertyConfigurator.configure((Properties)properties);
            } else {
                PropertyConfigurator.configure((String)string);
            }
        }
        this.setCategoryEnabledFlags();
    }

    public final void log(String string, int n) {
        Log.log(null, string, null, Log4jDebug.getLog4JSeverity(n));
    }

    public final void log(String string, String string2, int n) {
        Log.log(string, string2, null, Log4jDebug.getLog4JSeverity(n));
    }

    public final void log(Throwable throwable, int n) {
        Log.log(null, null, throwable, Log4jDebug.getLog4JSeverity(n));
    }

    public final void log(String string, Throwable throwable, int n) {
        Log.log(string, null, throwable, Log4jDebug.getLog4JSeverity(n));
    }

    public final void log(String string, String string2, Throwable throwable, int n) {
        Log.log(string, string2, throwable, Log4jDebug.getLog4JSeverity(n));
    }

    public void trace(String string) {
        Trace.trace(string);
    }

    public void trace(String string, String string2) {
        Trace.trace(string, string2);
    }

    public void trace(Throwable throwable) {
        Trace.trace(throwable);
    }

    public void trace(String string, Throwable throwable) {
        Trace.trace(string, throwable);
    }

    public final void trace(String string, String string2, Throwable throwable) {
        Trace.trace(string, string2, throwable);
    }

    public void methodEnter(String string) {
        Trace.methodEnter(string);
    }

    public void methodEnter(String string, String string2) {
        Trace.methodEnter(string, string2);
    }

    public void methodExit(String string) {
        Trace.methodExit(string);
    }

    public void methodExit(String string, String string2) {
        Trace.methodExit(string, string2);
    }

    public final void flagAsRelease() {
    }

    public boolean enabled(String string) {
        Boolean bl = (Boolean)this.myEnabledFlags.get(string);
        return null == bl ? false : bl;
    }

    private void reset() {
        BasicConfigurator.resetConfiguration();
    }

    private void setCategoryEnabledFlags() {
        this.myEnabledFlags.clear();
        Enumeration enumeration = Category.getCurrentCategories();
        while (enumeration.hasMoreElements()) {
            Category category = (Category)enumeration.nextElement();
            this.myEnabledFlags.put(category.getName(), new Boolean(true));
        }
    }

    private static Priority getLog4JSeverity(int n) {
        switch (n) {
            case 4: {
                return Priority.FATAL;
            }
            case 3: {
                return Priority.ERROR;
            }
            case 2: {
                return Priority.WARN;
            }
            case 1: {
                return Priority.INFO;
            }
            case 0: {
                return Priority.DEBUG;
            }
        }
        return Priority.WARN;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

