/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import org.bounce.text.xml.XMLContext;
import org.bounce.text.xml.XMLScanner;

class XMLViewUtilities {
    private static Segment lineBuffer = null;

    XMLViewUtilities() {
    }

    static int drawUnselectedText(View view, XMLScanner scanner, XMLContext context, Graphics g, int x, int y, int start, int end) throws BadLocationException {
        Document doc = view.getDocument();
        Style lastStyle = null;
        int mark = start;
        while (start < end) {
            XMLViewUtilities.updateScanner(scanner, doc, start);
            int p = Math.min(scanner.getEndOffset(), end);
            p = p <= start ? end : p;
            Style style = context.getStyle(scanner.token);
            if (style != lastStyle && lastStyle != null) {
                g.setColor(context.getForeground(lastStyle));
                g.setFont(g.getFont().deriveFont(context.getFontStyle(lastStyle)));
                Segment text = XMLViewUtilities.getLineBuffer();
                doc.getText(mark, start - mark, text);
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)((Object)view), mark);
                mark = start;
            }
            lastStyle = style;
            start = p;
        }
        g.setColor(context.getForeground(lastStyle));
        g.setFont(g.getFont().deriveFont(context.getFontStyle(lastStyle)));
        Segment text = XMLViewUtilities.getLineBuffer();
        doc.getText(mark, end - mark, text);
        x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)((Object)view), mark);
        return x;
    }

    static int drawSelectedText(View view, XMLScanner scanner, XMLContext context, Graphics g, int x, int y, int start, int end) throws BadLocationException {
        Document doc = view.getDocument();
        Style lastStyle = null;
        int mark = start;
        g.setColor(Color.black);
        while (start < end) {
            XMLViewUtilities.updateScanner(scanner, doc, start);
            int p = Math.min(scanner.getEndOffset(), end);
            p = p <= start ? end : p;
            Style style = context.getStyle(scanner.token);
            if (style != lastStyle && lastStyle != null) {
                g.setFont(g.getFont().deriveFont(context.getFontStyle(lastStyle)));
                Segment text = XMLViewUtilities.getLineBuffer();
                doc.getText(mark, start - mark, text);
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)((Object)view), mark);
                mark = start;
            }
            lastStyle = style;
            start = p;
        }
        g.setFont(g.getFont().deriveFont(context.getFontStyle(lastStyle)));
        Segment text = XMLViewUtilities.getLineBuffer();
        doc.getText(mark, end - mark, text);
        x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)((Object)view), mark);
        return x;
    }

    private static void updateScanner(XMLScanner scanner, Document doc, int p) {
        try {
            if (!scanner.isValid()) {
                scanner.setRange(XMLViewUtilities.getTagEnd(doc, p), doc.getLength());
                scanner.setValid(true);
            }
            while (scanner.getEndOffset() <= p) {
                scanner.scan();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static int getTagEnd(Document doc, int p) {
        int elementEnd = 0;
        if (p > 0) {
            try {
                int index = 0;
                String s = doc.getText(0, p);
                int commentStart = s.lastIndexOf("<!--");
                int commentEnd = s.lastIndexOf("-->");
                index = commentStart > 0 && commentStart > commentEnd ? s.lastIndexOf(">", commentStart) : s.lastIndexOf(">");
                if (index != -1) {
                    elementEnd = index;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return elementEnd;
    }

    private static Segment getLineBuffer() {
        if (lineBuffer == null) {
            lineBuffer = new Segment();
        }
        return lineBuffer;
    }
}

