/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.io;

import de.javasoft.io.FileOperationEvent;
import de.javasoft.io.FileOperationListener;
import de.javasoft.io.FileProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    static /* synthetic */ Class class$0;

    public static boolean delete(File file, boolean recursive, FileOperationListener listener) {
        File[] files;
        boolean abort = false;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory() && recursive) {
                    boolean bl = abort = !FileUtils.delete(files[i], recursive, listener);
                    if (abort) {
                        return !abort;
                    }
                } else {
                    if (listener != null) {
                        boolean bl = abort = !listener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, files[i], 3));
                    }
                    if (abort) {
                        return !abort;
                    }
                    files[i].delete();
                }
                ++i;
            }
        }
        if (listener != null) {
            boolean bl = abort = !listener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, file, 3));
        }
        if (abort) {
            return !abort;
        }
        file.delete();
        return !abort;
    }

    public static boolean copy(File source, File destination, boolean preserveTimestamp, boolean move, FileOperationListener listener) throws FileNotFoundException, IOException {
        boolean abort = false;
        if (listener != null) {
            boolean bl = abort = !listener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, source, 2));
        }
        if (abort) {
            return !abort;
        }
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(destination);
        byte[] buffer = new byte[65536];
        int i = 0;
        while ((i = fis.read(buffer)) != -1) {
            fos.write(buffer, 0, i);
        }
        fos.close();
        fis.close();
        if (preserveTimestamp) {
            destination.setLastModified(source.lastModified());
        }
        if (move) {
            boolean bl = abort = !listener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, source, 3));
            if (abort) {
                return !abort;
            }
            source.delete();
        }
        return !abort;
    }

    public static boolean copy(File source, File destination, boolean recursive, boolean replaceAll, boolean move, FileOperationListener listener) throws IOException {
        File[] files;
        boolean abort = false;
        if (!source.exists()) {
            throw new IOException("Source directory not found: " + source.getAbsolutePath());
        }
        if (source.isDirectory() && (files = source.listFiles()) != null) {
            if (!destination.exists()) {
                if (listener != null) {
                    boolean bl = abort = !listener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, destination, 1));
                }
                if (abort) {
                    return !abort;
                }
                destination.mkdir();
            }
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory() && recursive) {
                    File destinationFolder = new File(destination, files[i].getName());
                    boolean bl = abort = !FileUtils.copy(files[i], destinationFolder, recursive, replaceAll, move, listener);
                    if (abort) {
                        return !abort;
                    }
                } else if (files[i].isFile()) {
                    File destinationFile = new File(destination, files[i].getName());
                    if (replaceAll || !destinationFile.exists() || destinationFile.lastModified() < source.lastModified()) {
                        boolean bl = abort = !FileUtils.copy(files[i], destinationFile, true, move, listener);
                        if (abort) {
                            return !abort;
                        }
                    }
                }
                ++i;
            }
        } else if (replaceAll || !destination.exists() || destination.lastModified() < source.lastModified()) {
            boolean bl = abort = !FileUtils.copy(source, destination, true, move, listener);
            if (abort) {
                return !abort;
            }
        }
        if (source.isDirectory() && recursive && move) {
            abort = !FileUtils.delete(source, false, listener);
        }
        return !abort;
    }

    public static boolean determineProperties(FileProperties props, File file, boolean recursive, FileOperationListener listener) throws IOException {
        File[] files;
        boolean abort = false;
        if (!file.exists()) {
            throw new IOException("File not found: " + file.getAbsolutePath());
        }
        if (props.location == null) {
            props.location = file.getParent();
        }
        if (file.isDirectory() && recursive && (files = file.listFiles()) != null && files.length > 0) {
            ++props.directories;
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory() && recursive) {
                    boolean bl = abort = !FileUtils.determineProperties(props, files[i], recursive, listener);
                    if (abort) {
                        return !abort;
                    }
                } else if (files[i].isFile()) {
                    ++props.files;
                    props.size += files[i].length();
                    if (listener != null) {
                        boolean bl = abort = !listener.processFileOperationEvent(new FileOperationEvent(props, file, 4));
                    }
                    if (abort) {
                        return !abort;
                    }
                }
                ++i;
            }
        } else {
            if (file.isDirectory()) {
                ++props.directories;
            } else {
                ++props.files;
                props.size += file.length();
            }
            props.lastModified = file.lastModified();
            if (listener != null) {
                abort = !listener.processFileOperationEvent(new FileOperationEvent(props, file, 4));
            }
        }
        return !abort;
    }
}

