/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.StyleFactory;
import de.javasoft.plaf.synthetica.SyntheticaDefaultTreeCellRenderer;
import de.javasoft.plaf.synthetica.SyntheticaHeaderRenderer;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.CheckBoxStyle;
import de.javasoft.plaf.synthetica.styles.FormattedTextFieldStyle;
import de.javasoft.plaf.synthetica.styles.LabelStyle;
import de.javasoft.plaf.synthetica.styles.ListStyle;
import de.javasoft.plaf.synthetica.styles.MenuItemStyle;
import de.javasoft.plaf.synthetica.styles.MenuStyle;
import de.javasoft.plaf.synthetica.styles.PopupMenuStyle;
import de.javasoft.plaf.synthetica.styles.RadioButtonStyle;
import de.javasoft.plaf.synthetica.styles.ScrollPaneStyle;
import de.javasoft.plaf.synthetica.styles.TabbedPaneStyle;
import de.javasoft.plaf.synthetica.styles.TableStyle;
import de.javasoft.plaf.synthetica.styles.TextFieldStyle;
import de.javasoft.plaf.synthetica.styles.ToolBarSeparatorStyle;
import de.javasoft.plaf.synthetica.styles.ToolBarStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeCellRenderer;
import sun.swing.plaf.synth.DefaultSynthStyle;

public class StyleFactory
extends SynthStyleFactory {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    private SynthStyleFactory synthStyleFactory = null;
    private ComponentPropertyStore componentPropertyStore;
    private boolean prepareMetalLAFSwitch = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public StyleFactory(SynthStyleFactory synthStyleFactory) {
        this.synthStyleFactory = synthStyleFactory;
        this.componentPropertyStore = new ComponentPropertyStore();
    }

    void uninitialize() {
        this.componentPropertyStore.enabled = false;
        this.restoreAllComponentProperties();
        this.componentPropertyStore.stop();
    }

    public ComponentPropertyStore getComponentPropertyStore() {
        return this.componentPropertyStore;
    }

    public synchronized SynthStyle getStyle(JComponent c, Region region) {
        String name = c.getName();
        SynthStyle style = null;
        if (name != null && (region.equals(Region.TABBED_PANE_CONTENT) || region.equals(Region.TABBED_PANE_TAB) || region.equals(Region.TABBED_PANE_TAB_AREA))) {
            PropertyChangeListener l;
            PropertyChangeListener[] listeners;
            PropertyChangeListener[] propertyChangeListenerArray = listeners = c.getPropertyChangeListeners();
            int n = 0;
            int n2 = propertyChangeListenerArray.length;
            while (n < n2) {
                l = propertyChangeListenerArray[n];
                c.removePropertyChangeListener(l);
                ++n;
            }
            c.setName(String.valueOf(region.getName()) + "." + name);
            style = this.getStyle(c, region, this.synthStyleFactory.getStyle(c, region));
            c.setName(name);
            propertyChangeListenerArray = listeners;
            n = 0;
            n2 = propertyChangeListenerArray.length;
            while (n < n2) {
                l = propertyChangeListenerArray[n];
                c.addPropertyChangeListener(l);
                ++n;
            }
        } else {
            style = this.getStyle(c, region, this.synthStyleFactory.getStyle(c, region));
        }
        return style;
    }

    private SynthStyle getStyle(JComponent c, Region region, SynthStyle style) {
        String name = c.getName();
        if (SyntheticaLookAndFeel.getFontName() != null) {
            Font synthFont = ((DefaultSynthStyle)style).getStateInfo(0).getFont();
            FontUIResource font = new FontUIResource(SyntheticaLookAndFeel.getFontName(), synthFont.getStyle(), SyntheticaLookAndFeel.getFontSize());
            if (!SyntheticaLookAndFeel.getBoolean("Synthetica.font.disabled", c)) {
                ((DefaultSynthStyle)style).getStateInfo(0).setFont(font);
            }
        } else if (SyntheticaLookAndFeel.getFontName() == null) {
            Font font = ((DefaultSynthStyle)style).getStateInfo(0).getFont();
            if (font == null) {
                font = new FontUIResource("Tahoma", 0, 11);
            }
            SyntheticaLookAndFeel.setFont(font.getName(), font.getSize());
        }
        if (region == Region.ARROW_BUTTON) {
            int width;
            this.componentPropertyStore.storeComponentProperty(c, "OPAQUE");
            if (name != null && name.startsWith("Spinner.") && (width = SyntheticaLookAndFeel.getInt("Synthetica.spinner.arrowButton.width", c)) > 0) {
                c.setPreferredSize(new Dimension(width, c.getPreferredSize().height));
            }
        } else if (region == Region.BUTTON) {
            this.componentPropertyStore.storeComponentProperty(c, "BUTTON_MARGIN");
        } else if (region == Region.INTERNAL_FRAME_TITLE_PANE) {
            this.componentPropertyStore.storeComponentProperty(c, "PROPERTY_CHANGE_LISTENERS");
            if (!this.eventListenerExists(c.getPropertyChangeListeners())) {
                c.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("ancestor".equals(evt.getPropertyName())) {
                            JComponent c = (JComponent)evt.getSource();
                            Component[] components = c.getComponents();
                            int i = 0;
                            while (i < components.length) {
                                Component comp = components[i];
                                if (comp instanceof JButton) {
                                    String name = comp.getName();
                                    boolean addListener = true;
                                    MouseListener[] listeners = comp.getMouseListeners();
                                    int j = 0;
                                    while (j < listeners.length) {
                                        if (listeners[j].getClass().getName().contains("synthetica")) {
                                            addListener = false;
                                            break;
                                        }
                                        ++j;
                                    }
                                    if (addListener) {
                                        StyleFactory.this.componentPropertyStore.storeComponentProperty(comp, "MOUSE_LISTENERS");
                                        comp.addMouseListener(new MouseAdapter(this, c, name){
                                            final /* synthetic */ 2 this$1;
                                            private final /* synthetic */ JComponent val$c;
                                            private final /* synthetic */ String val$name;
                                            {
                                                this.this$1 = var1_1;
                                                this.val$c = jComponent;
                                                this.val$name = string;
                                            }

                                            public void mouseEntered(MouseEvent evt) {
                                                this.val$c.putClientProperty("Synthetica.MOUSE_OVER", this.val$name);
                                            }

                                            public void mouseExited(MouseEvent evt) {
                                                this.val$c.putClientProperty("Synthetica.MOUSE_OVER", null);
                                            }

                                            public void mouseReleased(MouseEvent evt) {
                                                if (this.val$c.getClientProperty("Synthetica.MOUSE_OVER") == null) {
                                                    return;
                                                }
                                                new Thread(this, evt){
                                                    final /* synthetic */ 3 this$2;
                                                    private final /* synthetic */ MouseEvent val$evt;
                                                    {
                                                        this.this$2 = var1_1;
                                                        this.val$evt = mouseEvent;
                                                    }

                                                    public void run() {
                                                        try {
                                                            4.sleep(100L);
                                                        }
                                                        catch (InterruptedException interruptedException) {
                                                            // empty catch block
                                                        }
                                                        JButton b = (JButton)this.val$evt.getSource();
                                                        b.dispatchEvent(new MouseEvent(b, 505, this.val$evt.getWhen(), this.val$evt.getModifiers(), this.val$evt.getX(), this.val$evt.getY(), this.val$evt.getClickCount(), this.val$evt.isPopupTrigger()));
                                                    }
                                                }.start();
                                            }
                                        });
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                });
            }
        } else if (region == Region.CHECK_BOX) {
            this.componentPropertyStore.storeComponentProperty(c, "MOUSE_LISTENERS");
            final JCheckBox cb = (JCheckBox)c;
            if (!this.eventListenerExists(c.getMouseListeners())) {
                c.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent arg0) {
                        cb.putClientProperty("Synthetica.MOUSE_OVER", true);
                    }

                    public void mouseExited(MouseEvent arg0) {
                        cb.putClientProperty("Synthetica.MOUSE_OVER", false);
                    }
                });
            }
            style = new CheckBoxStyle(style);
        } else if (region == Region.COMBO_BOX) {
            if (!SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
                this.disableOpaque(c);
            }
        } else if (region == Region.EDITOR_PANE) {
            if (!SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
                this.disableOpaque(c);
            }
        } else if (region == Region.FORMATTED_TEXT_FIELD) {
            style = new FormattedTextFieldStyle(style);
            if (!SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
                this.disableOpaque(c);
            }
        } else if (region == Region.INTERNAL_FRAME) {
            this.disableOpaque(c);
            this.componentPropertyStore.storeComponentProperty(c, "PROPERTY_CHANGE_LISTENERS");
            if (!this.eventListenerExists(c.getPropertyChangeListeners())) {
                c.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("frameIcon")) {
                            JInternalFrame frame = (JInternalFrame)evt.getSource();
                            try {
                                Component[] comps = frame.getComponents();
                                BasicInternalFrameTitlePane titlePane = null;
                                int i = 0;
                                while (i < comps.length) {
                                    if ("InternalFrame.northPane".equals(comps[i].getName())) {
                                        titlePane = (BasicInternalFrameTitlePane)comps[i];
                                        break;
                                    }
                                    ++i;
                                }
                                if (titlePane != null) {
                                    Class<?> clazz = Class.forName("javax.swing.plaf.synth.SynthInternalFrameTitlePane");
                                    Field field = clazz.getDeclaredField("menuButton");
                                    field.setAccessible(true);
                                    JButton button = null;
                                    button = (JButton)field.get(titlePane);
                                    button.setIcon(frame.getFrameIcon());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        } else if (region == Region.LABEL) {
            style = LabelStyle.getStyle(style, c, region);
        } else if (region == Region.LIST) {
            style = ListStyle.getStyle(style, c, region);
        } else if (region == Region.PASSWORD_FIELD) {
            if (!SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
                this.disableOpaque(c);
            }
        } else if (region == Region.SPINNER) {
            if (!SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
                this.disableOpaque(c);
            }
            if (JAVA5 && !this.eventListenerExists(c.getPropertyChangeListeners())) {
                this.componentPropertyStore.storeComponentProperty(c, "PROPERTY_CHANGE_LISTENERS");
                c.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("ToolTipText".equals(evt.getPropertyName())) {
                            StyleFactory.this.updateToolTipTextForChildren((JComponent)evt.getSource());
                        }
                    }
                });
            }
        } else if (region == Region.SCROLL_PANE) {
            style = ScrollPaneStyle.getStyle(style, c, region);
            JScrollPane sp = (JScrollPane)c;
            if (sp.getViewport() != null && sp.getViewport().getView() instanceof JTextComponent) {
                this.disableOpaque(c);
            }
        } else if (region == Region.SPLIT_PANE_DIVIDER) {
            if (SyntheticaLookAndFeel.getBoolean("Syntetica.splitPane.centerOneTouchButtons", c)) {
                if (!this.eventListenerExists(c.getComponentListeners())) {
                    this.componentPropertyStore.storeComponentProperty(c, "COMPONENT_LISTENERS");
                    c.addComponentListener(new ComponentAdapter(){

                        public void componentResized(ComponentEvent evt) {
                            ((JSplitPane)evt.getSource()).updateUI();
                            super.componentResized(evt);
                        }
                    });
                }
                if (!this.eventListenerExists(c.getPropertyChangeListeners())) {
                    this.componentPropertyStore.storeComponentProperty(c, "PROPERTY_CHANGE_LISTENERS");
                    c.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            if ("orientation".equals(evt.getPropertyName())) {
                                ((JSplitPane)evt.getSource()).updateUI();
                            }
                        }
                    });
                }
            }
        } else if (region == Region.MENU) {
            this.componentPropertyStore.storeComponentProperty(c, "OPAQUE");
            final DefaultSynthStyle fStyle = (DefaultSynthStyle)style;
            final JMenu menu = (JMenu)c;
            final MouseAdapter listener = new MouseAdapter(){

                public void mouseEntered(MouseEvent evt) {
                    JMenu m = (JMenu)evt.getSource();
                    m.putClientProperty("Synthetica.MOUSE_OVER", Boolean.TRUE);
                    Color c = fStyle.getColor(m, Region.MENU, 512, ColorType.TEXT_FOREGROUND);
                    m.setForeground(new Color(c.getRGB()));
                    m.repaint();
                }

                public void mouseExited(MouseEvent evt) {
                    JMenu m = (JMenu)evt.getSource();
                    m.putClientProperty("Synthetica.MOUSE_OVER", Boolean.FALSE);
                    Color c = fStyle.getColor(m, Region.MENU, 1024, ColorType.TEXT_FOREGROUND);
                    m.setForeground(c);
                    m.repaint();
                }
            };
            if (menu.isEnabled() && !this.eventListenerExists(menu.getMouseListeners())) {
                this.componentPropertyStore.storeComponentProperty(c, "MOUSE_LISTENERS");
                menu.addMouseListener(listener);
            } else if (!this.eventListenerExists(c.getPropertyChangeListeners())) {
                this.componentPropertyStore.storeComponentProperty(c, "PROPERTY_CHANGE_LISTENERS");
                c.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("ancestor")) {
                            if (!menu.isEnabled() || !menu.isTopLevelMenu()) {
                                return;
                            }
                            StyleFactory.this.componentPropertyStore.storeComponentProperty(menu, "MOUSE_LISTENERS");
                            menu.addMouseListener(listener);
                        }
                    }
                });
            }
            style = MenuStyle.getStyle(style, c, region);
        } else if (region == Region.MENU_ITEM) {
            style = MenuItemStyle.getStyle(style, c, region);
        } else if (region == Region.RADIO_BUTTON_MENU_ITEM) {
            style = MenuItemStyle.getStyle(style, c, region);
        } else if (region == Region.CHECK_BOX_MENU_ITEM) {
            style = MenuItemStyle.getStyle(style, c, region);
        } else if (region == Region.TABLE) {
            JTable table = (JTable)c;
            if (table.getDefaultRenderer(Icon.class) == null) {
                table.setDefaultRenderer(Icon.class, table.getDefaultRenderer(ImageIcon.class));
            }
            style = TableStyle.getStyle(style, c, region);
        } else if (region == Region.TABLE_HEADER) {
            JTableHeader header;
            TableCellRenderer renderer;
            if (c instanceof JTableHeader && (renderer = (header = (JTableHeader)c).getDefaultRenderer()) instanceof UIResource && !(renderer instanceof SyntheticaHeaderRenderer) && !SyntheticaLookAndFeel.getBoolean("Synthetica.table.useSynthHeaderRenderer", c)) {
                header.setDefaultRenderer(new SyntheticaHeaderRenderer());
            }
        } else if (region == Region.TABBED_PANE_TAB) {
            JTabbedPane tabbedPane;
            style = TabbedPaneStyle.getStyle(style, c, region);
            if (!this.eventListenerExists(c.getMouseMotionListeners())) {
                this.componentPropertyStore.storeComponentProperty(c, "MOUSE_MOTION_LISTENERS");
                c.addMouseMotionListener(new MouseMotionAdapter(){

                    public void mouseMoved(MouseEvent evt) {
                        JTabbedPane tp = (JTabbedPane)evt.getSource();
                        Integer iHover = (Integer)tp.getClientProperty("Synthetica.MOUSE_OVER");
                        int hover = iHover == null ? -1 : iHover;
                        int newHover = -1;
                        int tabCount = tp.getTabCount();
                        int i = 0;
                        while (i < tabCount) {
                            if (tp.getBoundsAt(i).contains(evt.getPoint())) {
                                newHover = i;
                                break;
                            }
                            ++i;
                        }
                        if (hover != newHover) {
                            tp.putClientProperty("Synthetica.MOUSE_OVER", newHover);
                            if (hover >= 0 && tp.getTabCount() > hover) {
                                tp.repaint(tp.getBoundsAt(hover));
                            }
                            if (newHover >= 0) {
                                tp.repaint(tp.getBoundsAt(newHover));
                            }
                        }
                    }
                });
            }
            if (!this.eventListenerExists(c.getMouseListeners())) {
                this.componentPropertyStore.storeComponentProperty(c, "MOUSE_LISTENERS");
                c.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent evt) {
                        JTabbedPane tp = (JTabbedPane)evt.getSource();
                        tp.dispatchEvent(new MouseEvent(tp, 503, evt.getWhen(), evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger()));
                    }

                    public void mouseExited(MouseEvent evt) {
                        int hover;
                        JTabbedPane tp = (JTabbedPane)evt.getSource();
                        Integer iHover = (Integer)tp.getClientProperty("Synthetica.MOUSE_OVER");
                        int n = hover = iHover == null ? -1 : iHover;
                        if (hover != -1) {
                            tp.putClientProperty("Synthetica.MOUSE_OVER", -1);
                            tp.repaint();
                        }
                    }
                });
            }
            if (!this.eventListenerExists((tabbedPane = (JTabbedPane)c).getContainerListeners())) {
                this.componentPropertyStore.storeComponentProperty(c, "CONTAINER_LISTENERS");
                this.storeContainerComponentProperties(tabbedPane, "OPAQUE");
                tabbedPane.addContainerListener(new ContainerListener(){

                    public void componentAdded(ContainerEvent e) {
                        StyleFactory.this.storeContainerComponentProperties(e.getContainer(), "OPAQUE");
                    }

                    public void componentRemoved(ContainerEvent e) {
                    }
                });
            }
        } else if (region == Region.TEXT_AREA) {
            if (!SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
                this.disableOpaque(c);
            }
        } else if (region == Region.TEXT_FIELD) {
            style = new TextFieldStyle(style);
            if (!SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
                this.disableOpaque(c);
            }
        } else if (region == Region.TEXT_PANE) {
            if (!SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
                this.disableOpaque(c);
            }
        } else if (region == Region.TOGGLE_BUTTON) {
            this.componentPropertyStore.storeComponentProperty(c, "BUTTON_MARGIN");
        } else if (region == Region.TOOL_BAR) {
            this.componentPropertyStore.storeComponentProperty(c, "OPAQUE");
            style = new ToolBarStyle(style);
        } else if (region == Region.TOOL_BAR_SEPARATOR) {
            this.componentPropertyStore.storeComponentProperty(c, "OPAQUE");
            this.componentPropertyStore.storeComponentProperty(c, "TOOLBAR_SEPARATOR_SIZE");
            style = ToolBarSeparatorStyle.getStyle(style, c, region);
        } else if (region == Region.TOOL_TIP) {
            this.componentPropertyStore.storeComponentProperty(c, "OPAQUE");
        } else if (region == Region.TREE) {
            boolean installed = false;
            PropertyChangeListener[] propertyChangeListenerArray = c.getPropertyChangeListeners();
            int n = 0;
            int n2 = propertyChangeListenerArray.length;
            while (n < n2) {
                PropertyChangeListener l = propertyChangeListenerArray[n];
                if (l.getClass().getName().startsWith(this.getClass().getName())) {
                    installed = true;
                }
                ++n;
            }
            if (!installed) {
                c.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        TreeCellRenderer renderer = ((JTree)evt.getSource()).getCellRenderer();
                        if (evt.getPropertyName().equals("cellRenderer") && renderer != null && !renderer.getClass().getName().startsWith("javax.swing.plaf.synth.Synth") && !(renderer instanceof SyntheticaDefaultTreeCellRenderer)) {
                            JTree tree = (JTree)evt.getSource();
                            StyleFactory.this.componentPropertyStore.removeComponentProperty(tree, "TREE_CELL_RENDERER", tree.getCellRenderer());
                        }
                    }
                });
            }
            this.componentPropertyStore.storeComponentProperty(c, "TREE_CELL_RENDERER");
        } else if (region == Region.PANEL) {
            this.componentPropertyStore.storeComponentProperty(c, "OPAQUE");
        } else if (region == Region.POPUP_MENU) {
            this.componentPropertyStore.storeComponentProperty(c, "OPAQUE");
            this.componentPropertyStore.storeComponentProperty(c, "PROPERTY_CHANGE_LISTENERS");
            style = PopupMenuStyle.getStyle(style, c, region);
        } else if (region != Region.POPUP_MENU_SEPARATOR && region == Region.RADIO_BUTTON) {
            this.componentPropertyStore.storeComponentProperty(c, "MOUSE_LISTENERS");
            final JRadioButton rb = (JRadioButton)c;
            c.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent arg0) {
                    rb.putClientProperty("Synthetica.MOUSE_OVER", true);
                }

                public void mouseExited(MouseEvent arg0) {
                    rb.putClientProperty("Synthetica.MOUSE_OVER", false);
                }
            });
            style = new RadioButtonStyle(style);
        }
        return style;
    }

    private void disableOpaque(JComponent c) {
        this.componentPropertyStore.storeComponentProperty(c, "OPAQUE");
        c.setOpaque(false);
    }

    private void enableOpaque(JComponent c) {
        this.componentPropertyStore.storeComponentProperty(c, "OPAQUE");
        c.setOpaque(true);
    }

    private boolean eventListenerExists(EventListener[] listeners) {
        EventListener[] eventListenerArray = listeners;
        int n = 0;
        int n2 = eventListenerArray.length;
        while (n < n2) {
            EventListener el = eventListenerArray[n];
            if (el.getClass().getName().startsWith(this.getClass().getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void updateToolTipTextForChildren(JComponent c) {
        Component[] componentArray = c.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component comp = componentArray[n];
            ((JComponent)comp).setToolTipText(c.getToolTipText());
            if (comp instanceof JComponent) {
                this.updateToolTipTextForChildren((JComponent)comp);
            }
            ++n;
        }
    }

    private void storeContainerComponentProperties(Container container, String property) {
        Component[] components;
        if (container instanceof JComponent) {
            this.componentPropertyStore.storeComponentProperty(container, property);
        }
        Component[] componentArray = components = container.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c instanceof Container && !(c instanceof Window) && !(c instanceof JRootPane)) {
                this.storeContainerComponentProperties((Container)c, property);
            }
            ++n;
        }
    }

    void restoreAllComponentProperties() {
        this.componentPropertyStore.restoreAllComponentProperties();
        this.componentPropertyStore.cleanerThread.interrupt();
    }

    public void prepareMetalLAFSwitch() {
        this.prepareMetalLAFSwitch = true;
    }

    private void setOpaqueDefault4Metal(JComponent c) {
        if (c instanceof JLabel || c instanceof JInternalFrame || c instanceof JTabbedPane || c instanceof JSeparator || c instanceof JMenu || c instanceof JSlider || c instanceof JPanel && this.isGlassPane((JPanel)c)) {
            c.setOpaque(false);
        } else {
            c.setOpaque(true);
        }
    }

    private boolean isGlassPane(JPanel c) {
        return c.getParent() instanceof JRootPane && ((JRootPane)c.getParent()).getGlassPane() == c;
    }

    public class ComponentPropertyStore {
        private HashSet<ComponentProperty> componentProperties;
        private boolean enabled = true;
        private Thread cleanerThread;

        ComponentPropertyStore() {
            this.reinit();
        }

        void reinit() {
            this.stop();
            this.componentProperties = new HashSet(500);
            this.cleanerThread = new Thread(this){
                final /* synthetic */ ComponentPropertyStore this$1;
                {
                    this.this$1 = componentPropertyStore;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!this.isInterrupted()) {
                        HashSet hashSet = ComponentPropertyStore.access$0(this.this$1);
                        synchronized (hashSet) {
                            Iterator<E> it = ComponentPropertyStore.access$0(this.this$1).iterator();
                            while (it.hasNext()) {
                                ComponentProperty prop = (ComponentProperty)it.next();
                                if (ComponentProperty.access$0(prop).get() != null) continue;
                                it.remove();
                            }
                        }
                        if (this.isInterrupted()) break;
                        try {
                            1.sleep(30000L);
                        }
                        catch (InterruptedException e) {
                            this.interrupt();
                        }
                        if (Frame.getFrames().length <= 0) continue;
                        boolean continuing = false;
                        Frame[] frameArray = Frame.getFrames();
                        int n = 0;
                        int n2 = frameArray.length;
                        while (n < n2) {
                            Frame f = frameArray[n];
                            continuing |= f.isDisplayable();
                            ++n;
                        }
                        if (continuing) continue;
                    }
                    ComponentPropertyStore.access$0(this.this$1).clear();
                }
            };
            this.cleanerThread.setName("cleanerThread");
            this.cleanerThread.setDaemon(true);
            this.cleanerThread.start();
        }

        void stop() {
            if (this.cleanerThread != null) {
                this.cleanerThread.interrupt();
            }
        }

        boolean removeComponentProperty(Component c, String propertyName, Object value) {
            ComponentProperty prop = new ComponentProperty(c, propertyName, value);
            return this.componentProperties.remove(prop);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeComponentProperty(Component c, String propertyName) {
            if (!this.enabled) {
                return;
            }
            Object value = null;
            if (propertyName.equals("OPAQUE")) {
                value = c.isOpaque();
            } else if (propertyName.equals("INSETS")) {
                value = ((JComponent)c).getInsets();
            } else if (propertyName.equals("BORDER")) {
                value = ((JComponent)c).getBorder();
            } else if (propertyName.equals("BUTTON_MARGIN")) {
                value = ((AbstractButton)c).getMargin();
            } else if (propertyName.equals("TOOLBAR_SEPARATOR_SIZE")) {
                value = ((JToolBar.Separator)c).getSeparatorSize();
            } else if (propertyName.equals("TREE_CELL_RENDERER")) {
                value = ((JTree)c).getCellRenderer();
            }
            ComponentProperty prop = new ComponentProperty(c, propertyName, value);
            HashSet<ComponentProperty> hashSet = this.componentProperties;
            synchronized (hashSet) {
                if (!this.componentProperties.contains(prop)) {
                    this.componentProperties.add(prop);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void restoreAllComponentProperties() {
            HashSet<ComponentProperty> hashSet = this.componentProperties;
            synchronized (hashSet) {
                for (ComponentProperty cp : this.componentProperties) {
                    this.restoreComponentProperty(cp);
                }
                this.componentProperties.clear();
            }
            StyleFactory.this.prepareMetalLAFSwitch = false;
        }

        private void restoreComponentProperty(ComponentProperty cp) {
            block15: {
                String propertyName;
                JComponent c;
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        Object value;
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block14: {
                                                        c = (JComponent)cp.component.get();
                                                        if (c == null) {
                                                            return;
                                                        }
                                                        propertyName = cp.propertyName;
                                                        value = cp.value.get();
                                                        if (!propertyName.equals("OPAQUE") || !StyleFactory.this.prepareMetalLAFSwitch) break block14;
                                                        StyleFactory.this.setOpaqueDefault4Metal(c);
                                                        break block15;
                                                    }
                                                    if (!propertyName.equals("INSETS")) break block16;
                                                    Insets insets = (Insets)value;
                                                    c.setBorder(new EmptyBorder(insets));
                                                    break block15;
                                                }
                                                if (!propertyName.equals("BUTTON_MARGIN")) break block17;
                                                Insets insets = (Insets)value;
                                                ((AbstractButton)c).setMargin(insets);
                                                break block15;
                                            }
                                            if (!propertyName.equals("TOOLBAR_SEPARATOR_SIZE")) break block18;
                                            Dimension dimension = (Dimension)value;
                                            if (dimension == null) {
                                                dimension = new Dimension(10, 10);
                                            }
                                            ((JToolBar.Separator)c).setSeparatorSize(dimension);
                                            break block15;
                                        }
                                        if (!propertyName.equals("TREE_CELL_RENDERER")) break block19;
                                        TreeCellRenderer cr = (TreeCellRenderer)value;
                                        ((JTree)c).setCellRenderer(cr);
                                        break block15;
                                    }
                                    if (!propertyName.equals("PROPERTY_CHANGE_LISTENERS")) break block20;
                                    PropertyChangeListener[] listeners = c.getPropertyChangeListeners();
                                    int i = 0;
                                    while (i < listeners.length) {
                                        if (listeners[i].getClass().getName().contains("synthetica")) {
                                            c.removePropertyChangeListener(listeners[i]);
                                        }
                                        ++i;
                                    }
                                    break block15;
                                }
                                if (!propertyName.equals("COMPONENT_LISTENERS")) break block21;
                                ComponentListener[] listeners = c.getComponentListeners();
                                int i = 0;
                                while (i < listeners.length) {
                                    if (listeners[i].getClass().getName().contains("synthetica")) {
                                        c.removeComponentListener(listeners[i]);
                                    }
                                    ++i;
                                }
                                break block15;
                            }
                            if (!propertyName.equals("CONTAINER_LISTENERS")) break block22;
                            ContainerListener[] listeners = c.getContainerListeners();
                            int i = 0;
                            while (i < listeners.length) {
                                if (listeners[i].getClass().getName().contains("synthetica")) {
                                    c.removeContainerListener(listeners[i]);
                                }
                                ++i;
                            }
                            break block15;
                        }
                        if (!propertyName.equals("MOUSE_LISTENERS")) break block23;
                        MouseListener[] listeners = c.getMouseListeners();
                        int i = 0;
                        while (i < listeners.length) {
                            if (listeners[i].getClass().getName().contains("synthetica")) {
                                c.removeMouseListener(listeners[i]);
                            }
                            ++i;
                        }
                        break block15;
                    }
                    if (!propertyName.equals("MOUSE_MOTION_LISTENERS")) break block24;
                    MouseMotionListener[] listeners = c.getMouseMotionListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        if (listeners[i].getClass().getName().contains("synthetica")) {
                            c.removeMouseMotionListener(listeners[i]);
                        }
                        ++i;
                    }
                    break block15;
                }
                if (!propertyName.equals("FOCUS_LISTENERS")) break block15;
                FocusListener[] listeners = c.getFocusListeners();
                int i = 0;
                while (i < listeners.length) {
                    if (listeners[i].getClass().getName().contains("synthetica")) {
                        c.removeFocusListener(listeners[i]);
                    }
                    ++i;
                }
            }
        }

        static /* synthetic */ HashSet access$0(ComponentPropertyStore componentPropertyStore) {
            return componentPropertyStore.componentProperties;
        }
    }

    private class ComponentProperty {
        static final String OPAQUE = "OPAQUE";
        static final String INSETS = "INSETS";
        static final String BORDER = "BORDER";
        static final String BUTTON_MARGIN = "BUTTON_MARGIN";
        static final String TOOLBAR_SEPARATOR_SIZE = "TOOLBAR_SEPARATOR_SIZE";
        static final String PROPERTY_CHANGE_LISTENERS = "PROPERTY_CHANGE_LISTENERS";
        static final String COMPONENT_LISTENERS = "COMPONENT_LISTENERS";
        static final String MOUSE_LISTENERS = "MOUSE_LISTENERS";
        static final String MOUSE_MOTION_LISTENERS = "MOUSE_MOTION_LISTENERS";
        static final String CONTAINER_LISTENERS = "CONTAINER_LISTENERS";
        static final String TREE_CELL_RENDERER = "TREE_CELL_RENDERER";
        static final String FOCUS_LISTENERS = "FOCUS_LISTENERS";
        private WeakReference component;
        private String propertyName;
        private WeakReference value;
        private int componentHashCode;

        ComponentProperty(Component c, String propertyName, Object value) {
            this.component = new WeakReference<Component>(c);
            this.propertyName = propertyName;
            this.value = new WeakReference<Object>(value);
            this.componentHashCode = (String.valueOf(c.hashCode()) + propertyName).hashCode();
        }

        public boolean equals(Object obj) {
            return this.componentHashCode == obj.hashCode();
        }

        public int hashCode() {
            return this.componentHashCode;
        }
    }
}

