/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.PopupFactory;
import de.javasoft.plaf.synthetica.StyleFactory;
import de.javasoft.plaf.synthetica.SyntheticaDefaultLookup;
import de.javasoft.plaf.synthetica.SyntheticaTitledBorder;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import de.javasoft.plaf.synthetica.painter.TreePainter;
import de.javasoft.util.IVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.swing.DefaultLookup;
import sun.swing.plaf.synth.DefaultSynthStyle;

public abstract class SyntheticaLookAndFeel
extends SynthLookAndFeel {
    private static String fontName;
    private static int fontSize;
    private static boolean antiAliasEnabled;
    private static Dimension toolbarSeparatorDimension;
    private static boolean decorated;
    private static boolean extendedFileChooserEnabled;
    private static boolean rememberFileChooserPreferences;
    private static boolean useSystemFileIcons;
    private static boolean defaultsCompatibilityMode;
    private PropertyChangeListener lafChangeListener;
    private UIDefaults orgDefaults;
    private static boolean debug;
    private static final boolean NOSTYLE = false;
    static /* synthetic */ Class class$0;

    static {
        decorated = true;
        extendedFileChooserEnabled = true;
        rememberFileChooserPreferences = true;
        useSystemFileIcons = true;
        defaultsCompatibilityMode = true;
        debug = System.getProperty("synthetica.debug") != null;
    }

    public SyntheticaLookAndFeel(String fileName) throws ParseException {
        long start = System.currentTimeMillis();
        Class<SyntheticaLookAndFeel> clazz = SyntheticaLookAndFeel.class;
        this.load(clazz.getResourceAsStream(fileName), clazz);
        try {
            String syntheticaFileName = "Synthetica.xml";
            this.load(clazz.getResourceAsStream("/" + syntheticaFileName), clazz);
            if (debug) {
                System.out.println("[Info] Found '" + syntheticaFileName + "' configuration file.");
            }
        }
        catch (IllegalArgumentException syntheticaFileName) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String className = this.getClass().getName();
        try {
            String syntheticaFileName = String.valueOf(className.substring(className.lastIndexOf(".") + 1)) + ".xml";
            this.load(clazz.getResourceAsStream("/" + syntheticaFileName), clazz);
            if (debug) {
                System.out.println("[Info] Found '" + syntheticaFileName + "' configuration file.");
            }
        }
        catch (IllegalArgumentException syntheticaFileName) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long stop = System.currentTimeMillis();
        if (System.getProperty("synthetica.loadTime") != null) {
            System.out.println("Time for loading LAF: " + (stop - start) + "ms");
        }
        if (System.getProperty("synthetica.blockLAFChange") != null) {
            System.out.println("LAF switchings will be blocked!");
            this.blockLAFChange();
        }
        if (debug) {
            System.out.println("Synthetica debug mode is enabled!");
        }
    }

    public abstract String getID();

    public abstract String getName();

    public String getDescription() {
        return "Synthetica - the extended Synth Look and Feel.";
    }

    public IVersion getVersion() {
        ResourceBundle rb = this.getResourceBundle(String.valueOf(this.getID()) + "Version");
        final int major = Integer.parseInt(rb.getString("major"));
        final int minor = Integer.parseInt(rb.getString("minor"));
        final int revision = Integer.parseInt(rb.getString("revision"));
        final int build = Integer.parseInt(rb.getString("build"));
        return new IVersion(){

            public int getMajor() {
                return major;
            }

            public int getMinor() {
                return minor;
            }

            public int getRevision() {
                return revision;
            }

            public int getBuild() {
                return build;
            }

            public String toString() {
                return String.valueOf(major) + "." + minor + "." + revision + " Build " + build;
            }
        };
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    public UIDefaults getDefaults() {
        UIDefaults defaults = super.getDefaults();
        return defaults;
    }

    private void addResourceBundleToDefaults(String name, UIDefaults defaults) {
        ResourceBundle resBundle = this.getResourceBundle(name);
        Enumeration<String> enumeration = resBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            String value = resBundle.getString(key);
            defaults.put(key, value);
        }
    }

    public void initialize() {
        PropertyChangeListener l;
        PropertyChangeListener[] listeners;
        super.initialize();
        this.orgDefaults = (UIDefaults)UIManager.getDefaults().clone();
        DefaultLookup.setDefaultLookup(new SyntheticaDefaultLookup());
        StyleFactory styleFactory = new StyleFactory(SyntheticaLookAndFeel.getStyleFactory());
        SynthLookAndFeel.setStyleFactory(styleFactory);
        PopupFactory.install();
        this.lafChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SyntheticaLookAndFeel.this.reinit();
                SyntheticaLookAndFeel.this.installSyntheticaDefaults();
                if (defaultsCompatibilityMode) {
                    SyntheticaLookAndFeel.this.installCompatibilityDefaults();
                }
            }
        };
        PropertyChangeListener[] propertyChangeListenerArray = listeners = UIManager.getPropertyChangeListeners();
        int n = 0;
        int n2 = propertyChangeListenerArray.length;
        while (n < n2) {
            l = propertyChangeListenerArray[n];
            UIManager.removePropertyChangeListener(l);
            ++n;
        }
        UIManager.addPropertyChangeListener(this.lafChangeListener);
        propertyChangeListenerArray = listeners;
        n = 0;
        n2 = propertyChangeListenerArray.length;
        while (n < n2) {
            l = propertyChangeListenerArray[n];
            UIManager.addPropertyChangeListener(l);
            ++n;
        }
    }

    private void reinit() {
        ((MenuPainter)MenuPainter.getInstance()).reinitialize();
        ((TreePainter)TreePainter.getInstance()).reinitialize();
        ((TabbedPanePainter)TabbedPanePainter.getInstance()).reinitialize();
    }

    private void installSyntheticaDefaults() {
        UIDefaults defaults = UIManager.getDefaults();
        defaults.put("HyperlinkUI", "de.javasoft.plaf.synthetica.HyperlinkUI");
        defaults.put("StatusBarUI", "de.javasoft.plaf.synthetica.StatusBarUI");
        defaults.put("LoginPanelUI", "de.javasoft.plaf.synthetica.LoginPanelUI");
        defaults.put("MonthViewUI", "de.javasoft.plaf.synthetica.MonthViewUI");
        defaults.put("swingx/TaskPaneUI", "de.javasoft.plaf.synthetica.TaskPaneUI");
        defaults.put("swingx/TaskPaneContainerUI", "de.javasoft.plaf.synthetica.TaskPaneContainerUI");
        defaults.put("swingx/TipOfTheDayUI", "de.javasoft.plaf.synthetica.TipOfTheDayUI");
        defaults.put("Flexdock.view", "de.javasoft.plaf.synthetica.flexdock.ViewUI");
        defaults.put("Flexdock.titlebar", "de.javasoft.plaf.synthetica.flexdock.TitlebarUI");
        defaults.put("Flexdock.titlebar.button", "de.javasoft.plaf.synthetica.flexdock.ButtonUI");
        this.addResourceBundleToDefaults("synthetica", defaults);
        if (UIManager.getBoolean("Synthetica.window.decoration")) {
            defaults.put("RootPaneUI", "de.javasoft.plaf.synthetica.SyntheticaRootPaneUI");
        } else {
            decorated = false;
        }
        JFrame.setDefaultLookAndFeelDecorated(decorated);
        JDialog.setDefaultLookAndFeelDecorated(decorated);
        extendedFileChooserEnabled = UIManager.getBoolean("Synthetica.extendedFileChooser.enabled");
        SyntheticaLookAndFeel.setExtendedFileChooserEnabled(extendedFileChooserEnabled);
        rememberFileChooserPreferences = UIManager.getBoolean("Synthetica.extendedFileChooser.rememberPreferences");
        useSystemFileIcons = UIManager.getBoolean("Synthetica.extendedFileChooser.useSystemFileIcons");
        UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
        for (Map.Entry entry : lafDefaults.entrySet()) {
            if (defaults.containsKey(entry.getKey())) continue;
            defaults.put(entry.getKey(), entry.getValue());
        }
    }

    private void installCompatibilityDefaults() {
        UIDefaults defaults = UIManager.getDefaults();
        this.initSystemColorDefaults(UIManager.getDefaults());
        Object[] uiDefaults = new Object[]{"FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F5", "refresh", "ENTER", "approveSelection"}), "List.selectionForeground", new ColorUIResource(Color.white), "SplitPane.dividerSize", 8, "List.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(defaults.getColor("Synthetica.list.focusCellHighlightBorder.color")), "Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(defaults.getColor("Synthetica.table.focusCellHighlightBorder.color")), "Table.scrollPaneBorder", new BorderUIResource.LineBorderUIResource(defaults.getColor("Synthetica.table.scrollPane.border.color")), "TitledBorder.border", new BorderUIResource(new SyntheticaTitledBorder()), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "HOME", "selectFirstColumn", "shift HOME", "selectFirstColumnExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRow", "END", "selectLastColumn", "shift END", "selectLastColumnExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRow", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollLeftExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollRightExtendSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ESCAPE", "cancel", "F2", "startEditing", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "Table.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift KP_RIGHT", "selectPreviousColumnExtendSelection", "shift RIGHT", "selectPreviousColumnChangeLead", "shift KP_RIGHT", "selectPreviousColumnChangeLead", "LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl shift LEFT", "selectNextColumnExtendSelection", "ctrl shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl LEFT", "selectNextColumnChangeLead", "ctrl KP_LEFT", "selectNextColumnChangeLead", "ctrl PAGE_UP", "scrollRightChangeSelection", "ctrl PAGE_DOWN", "scrollLeftChangeSelection", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection"}), "controlLtHighlight", new ColorUIResource(Color.WHITE), "controlHighlight", new ColorUIResource(Color.LIGHT_GRAY), "controlShadow", new ColorUIResource(Color.DARK_GRAY), "controlDkShadow", new ColorUIResource(Color.BLACK)};
        defaults.putDefaults(uiDefaults);
        SynthStyle ss = null;
        SynthContext sc = null;
        SynthStyleFactory ssf = SyntheticaLookAndFeel.getStyleFactory();
        String[] inKeys = null;
        String[] keys = null;
        Font font = null;
        JButton button = new JButton();
        ss = ssf.getStyle(button, Region.BUTTON);
        sc = new SynthContext(button, Region.BUTTON, ss, 1);
        font = ss.getFont(sc);
        defaults.put("Button.font", font);
        JComboBox cb = new JComboBox();
        ss = ssf.getStyle(cb, Region.COMBO_BOX);
        sc = new SynthContext(cb, Region.COMBO_BOX, ss, 1024);
        Color cbBackground = ss.getColor(sc, ColorType.BACKGROUND);
        defaults.put("ComboBox.background", cbBackground);
        Color cbForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("ComboBox.foreground", cbForeground);
        defaults.put("ComboBox.font", ss.getFont(sc));
        JLabel label = new JLabel();
        ss = ssf.getStyle(label, Region.LABEL);
        sc = new SynthContext(label, Region.LABEL, ss, 1024);
        font = ss.getFont(sc);
        defaults.put("Label.font", font);
        defaults.put("JXMonthView.font", font);
        Color labelForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("Label.foreground", labelForeground);
        JPanel panel = new JPanel();
        ss = ssf.getStyle(panel, Region.PANEL);
        sc = new SynthContext(panel, Region.PANEL, ss, 1024);
        Color panelBackground = ss.getColor(sc, ColorType.BACKGROUND);
        defaults.put("Panel.background", panelBackground);
        defaults.put("SplitPane.background", panelBackground);
        defaults.put("Label.background", panelBackground);
        defaults.put("ColorChooser.swatchesDefaultRecentColor", panelBackground);
        defaults.put("control", panelBackground);
        Color panelForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("Panel.foreground", panelForeground);
        font = ss.getFont(sc);
        defaults.put("Panel.font", font);
        defaults.put("TitledBorder.font", font);
        JList list = new JList();
        ss = ssf.getStyle(list, Region.LIST);
        sc = new SynthContext(list, Region.LIST, ss, 1024);
        Color listBackground = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("List.background", listBackground);
        Color listForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("List.foreground", listForeground);
        sc = new SynthContext(list, Region.LIST, ss, 512);
        listBackground = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("List.selectionBackground", listBackground);
        listForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("List.selectionForeground", listForeground);
        JTable table = new JTable();
        ss = ssf.getStyle(table, Region.TABLE_HEADER);
        sc = new SynthContext(table, Region.TABLE_HEADER, ss, 1024);
        Color tableHeaderBackground = ss.getColor(sc, ColorType.BACKGROUND);
        defaults.put("TableHeader.background", tableHeaderBackground);
        Color tableHeaderForeground = ss.getColor(sc, ColorType.FOREGROUND);
        defaults.put("TableHeader.foreground", tableHeaderForeground);
        ss = ssf.getStyle(table, Region.TABLE);
        sc = new SynthContext(table, Region.TABLE, ss, 1024);
        defaults.put("Table.gridColor", ss.get(sc, "Table.gridColor"));
        Color tableBackground = ss.getColor(sc, ColorType.BACKGROUND);
        defaults.put("Table.background", tableBackground);
        Color tableForeground = ss.getColor(sc, ColorType.FOREGROUND);
        defaults.put("Table.foreground", tableForeground);
        sc = new SynthContext(table, Region.TABLE, ss, 512);
        tableBackground = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("Table.selectionBackground", tableBackground);
        tableForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("Table.selectionForeground", tableForeground);
        JTree tree = new JTree();
        ss = ssf.getStyle(tree, Region.TREE);
        font = ((DefaultSynthStyle)ss).getFont(tree, Region.TREE, 1);
        defaults.put("Tree.font", font);
        sc = new SynthContext(tree, Region.TREE, ss, 1024);
        keys = new String[]{"Tree.expandedIcon", "Tree.collapsedIcon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        defaults.put("Tree.rowHeight", ss.get(sc, "Tree.rowHeight"));
        defaults.put("Tree.leftChildIndent", ss.get(sc, "Tree.leftChildIndent"));
        defaults.put("Tree.rightChildIndent", ss.get(sc, "Tree.rightChildIndent"));
        ss = ssf.getStyle(tree, Region.TREE_CELL);
        sc = new SynthContext(tree, Region.TREE_CELL, ss, 1024);
        defaults.put("Tree.textForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("Tree.textBackground", ss.getColor(sc, ColorType.TEXT_BACKGROUND));
        sc = new SynthContext(tree, Region.TREE_CELL, ss, 512);
        defaults.put("Tree.selectionForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("Tree.selectionBackground", ss.getColor(sc, ColorType.TEXT_BACKGROUND));
        defaults.put("Tree.hash", defaults.get("Synthetica.tree.line.color.vertical"));
        JInternalFrame iFrame = new JInternalFrame();
        ss = ssf.getStyle(iFrame, Region.INTERNAL_FRAME_TITLE_PANE);
        Color iFrameForeground = ((DefaultSynthStyle)ss).getColor(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, 512, ColorType.FOREGROUND);
        defaults.put("InternalFrame.activeTitleForeground", iFrameForeground);
        iFrameForeground = ((DefaultSynthStyle)ss).getColor(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, 1024, ColorType.FOREGROUND);
        defaults.put("InternalFrame.inactiveTitleForeground", iFrameForeground);
        Color iFrameBackground = ((DefaultSynthStyle)ss).getColor(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, 512, ColorType.BACKGROUND);
        defaults.put("InternalFrame.activeTitleBackground", iFrameBackground);
        defaults.put("activeCaption", iFrameBackground);
        iFrameBackground = ((DefaultSynthStyle)ss).getColor(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, 1024, ColorType.BACKGROUND);
        defaults.put("InternalFrame.inactiveTitleBackground", iFrameBackground);
        defaults.put("inactiveCaption", iFrameBackground);
        sc = new SynthContext(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, ss, 1024);
        inKeys = new String[]{"InternalFrameTitlePane.closeIcon", "InternalFrameTitlePane.maximizeIcon", "InternalFrameTitlePane.minimizeIcon", "InternalFrameTitlePane.iconifyIcon"};
        keys = new String[]{"InternalFrame.closeIcon", "InternalFrame.maximizeIcon", "InternalFrame.minimizeIcon", "InternalFrame.iconifyIcon"};
        this.putIcons2Defaults(defaults, inKeys, keys, ss, sc);
        ss = ssf.getStyle(iFrame, Region.INTERNAL_FRAME);
        sc = new SynthContext(iFrame, Region.INTERNAL_FRAME, ss, 1024);
        keys = new String[]{"InternalFrame.icon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        JMenu menu = new JMenu();
        ss = ssf.getStyle(menu, Region.MENU);
        sc = new SynthContext(menu, Region.MENU, ss, 1024);
        defaults.put("MenuItem.background", ss.getColor(sc, ColorType.BACKGROUND));
        JOptionPane oPane = new JOptionPane();
        ss = ssf.getStyle(oPane, Region.OPTION_PANE);
        sc = new SynthContext(oPane, Region.OPTION_PANE, ss, 1024);
        keys = new String[]{"OptionPane.informationIcon", "OptionPane.questionIcon", "OptionPane.warningIcon", "OptionPane.errorIcon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        JCheckBox checkBox = new JCheckBox();
        ss = ssf.getStyle(checkBox, Region.CHECK_BOX);
        sc = new SynthContext(checkBox, Region.CHECK_BOX, ss, 1024);
        keys = new String[]{"CheckBox.icon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        JRadioButton radioButton = new JRadioButton();
        ss = ssf.getStyle(radioButton, Region.RADIO_BUTTON);
        sc = new SynthContext(radioButton, Region.RADIO_BUTTON, ss, 1024);
        keys = new String[]{"RadioButton.icon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        JTabbedPane tPane = new JTabbedPane();
        ss = ssf.getStyle(tPane, Region.TABBED_PANE_TAB_AREA);
        sc = new SynthContext(tPane, Region.TABBED_PANE_TAB_AREA, ss, 1024);
        defaults.put("TabbedPane.tabAreaInsets", ss.getInsets(sc, null));
        ss = ssf.getStyle(tPane, Region.TABBED_PANE_TAB);
        sc = new SynthContext(tPane, Region.TABBED_PANE_TAB, ss, 1024);
        defaults.put("TabbedPane.tabInsets", ss.getInsets(sc, null));
        ss = ssf.getStyle(tPane, Region.TABBED_PANE_TAB);
        sc = new SynthContext(tPane, Region.TABBED_PANE_TAB, ss, 512);
        defaults.put("TabbedPane.selectedTabPadInsets", ss.getInsets(sc, null));
        ss = ssf.getStyle(tPane, Region.TABBED_PANE_CONTENT);
        sc = new SynthContext(tPane, Region.TABBED_PANE_CONTENT, ss, 1024);
        defaults.put("TabbedPane.contentBorderInsets", ss.getInsets(sc, null));
        defaults.put("TabbedPane.shadow", Color.GRAY);
        JTextField tf = new JTextField();
        defaults.put("TextField.border", tf.getBorder());
        ss = ssf.getStyle(tf, Region.TEXT_FIELD);
        sc = new SynthContext(tf, Region.TEXT_FIELD, ss, 1024);
        defaults.put("TextField.foreground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("TextField.background", ss.getColor(sc, ColorType.TEXT_BACKGROUND));
        sc = new SynthContext(tf, Region.TEXT_FIELD, ss, 8);
        defaults.put("TextField.inactiveForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("TextField.inactiveBackground", ss.getColor(sc, ColorType.TEXT_BACKGROUND));
        sc = new SynthContext(tf, Region.TEXT_FIELD, ss, 512);
        defaults.put("TextField.selectionForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("TextField.selectionBackground", ss.getColor(sc, ColorType.TEXT_BACKGROUND));
        defaults.put("textHighlight", ss.getColor(sc, ColorType.TEXT_BACKGROUND));
        JToolTip tt = new JToolTip();
        sc = new SynthContext(tt, Region.TOOL_TIP, ss, 1024);
        ss = ssf.getStyle(tt, Region.TOOL_TIP);
        defaults.put("ToolTip.font", ss.getFont(sc));
        defaults.put("ToolTip.foreground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("ToolTip.background", ss.getColor(sc, ColorType.BACKGROUND));
        defaults.put("ColumnHeaderRenderer.upIcon", SyntheticaLookAndFeel.makeIcon(this.getClass(), defaults.getString("Synthetica.arrow.up")));
        defaults.put("ColumnHeaderRenderer.downIcon", SyntheticaLookAndFeel.makeIcon(this.getClass(), defaults.getString("Synthetica.arrow.down")));
    }

    private void putIcons2Defaults(UIDefaults defaults, String[] inKeys, String[] keys, SynthStyle ss, SynthContext sc) {
        int i = 0;
        while (i < inKeys.length) {
            Icon icon = ss.getIcon(sc, inKeys[i]);
            defaults.put(keys[i], icon);
            ++i;
        }
    }

    public void uninitialize() {
        ((StyleFactory)SynthLookAndFeel.getStyleFactory()).uninitialize();
        UIDefaults defaults = UIManager.getDefaults();
        defaults.clear();
        for (Map.Entry es : this.orgDefaults.entrySet()) {
            defaults.put(es.getKey(), es.getValue());
        }
        UIManager.removePropertyChangeListener(this.lafChangeListener);
        super.uninitialize();
    }

    private void blockLAFChange() {
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object newLAF = event.getNewValue();
                if (!(newLAF instanceof SyntheticaLookAndFeel)) {
                    try {
                        UIManager.setLookAndFeel(SyntheticaLookAndFeel.this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static void setFont(String name, int size) {
        fontName = name;
        fontSize = size;
    }

    public static String getFontName() {
        return fontName;
    }

    public static int getFontSize() {
        return fontSize;
    }

    public static boolean getAntiAliasEnabled() {
        return antiAliasEnabled;
    }

    public static void setAntiAliasEnabled(boolean value) {
        antiAliasEnabled = value;
    }

    public static void setWindowsDecorated(boolean decorated) {
        SyntheticaLookAndFeel.decorated = decorated;
    }

    public static boolean getExtendedFileChooserEnabled() {
        return extendedFileChooserEnabled;
    }

    public static void setExtendedFileChooserEnabled(boolean value) {
        extendedFileChooserEnabled = value;
        if (extendedFileChooserEnabled) {
            UIManager.getDefaults().put("FileChooserUI", "de.javasoft.plaf.synthetica.filechooser.SyntheticaFileChooserUI");
        } else {
            UIManager.getDefaults().put("FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI");
        }
    }

    public static boolean getRememberFileChooserPreferences() {
        return rememberFileChooserPreferences;
    }

    public static void setRememberFileChooserPreferences(boolean value) {
        rememberFileChooserPreferences = value;
    }

    public static boolean getUseSystemFileIcons() {
        return useSystemFileIcons;
    }

    public static void setUseSystemFileIcons(boolean value) {
        useSystemFileIcons = value;
    }

    public static void setDefaultsCompatibilityMode(boolean value) {
        defaultsCompatibilityMode = value;
    }

    public static boolean getDefaultsCompatibilityMode() {
        return defaultsCompatibilityMode;
    }

    public static void setToolbarSeparatorDimension(Dimension dim) {
        toolbarSeparatorDimension = dim;
    }

    public static Dimension getToolbarSeparatorDimension() {
        return toolbarSeparatorDimension;
    }

    private ResourceBundle getResourceBundle(String name) {
        return ResourceBundle.getBundle("de/javasoft/plaf/synthetica/resourceBundles/" + name);
    }

    public IVersion getSyntheticaVersion() {
        return new Version();
    }

    public static Object get(String propertyKey, String propertyName, String componentName, boolean fallback) {
        String pKey = propertyKey;
        char delimiter = '.';
        int i = propertyKey.length();
        while (i > -1) {
            StringBuilder key = new StringBuilder("Synthetica.");
            propertyKey = propertyKey.substring(0, i);
            key.append(propertyKey);
            if (propertyName != null) {
                key.append(delimiter);
                key.append(propertyName);
            }
            if (componentName != null) {
                key.append(delimiter);
                key.append(componentName);
            }
            if (UIManager.get(key.toString()) != null || !fallback) {
                return UIManager.get(key.toString());
            }
            i = propertyKey.lastIndexOf(delimiter);
            if (i != -1 || componentName == null) continue;
            componentName = null;
            propertyKey = pKey;
            i = propertyKey.length();
        }
        return null;
    }

    public static String getString(String propertyKey, String propertyName, String componentName, boolean fallback) {
        return (String)SyntheticaLookAndFeel.get(propertyKey, propertyName, componentName, fallback);
    }

    public static Insets getInsets(String propertyKey, String propertyName, String componentName, boolean fallback) {
        return (Insets)SyntheticaLookAndFeel.get(propertyKey, propertyName, componentName, fallback);
    }

    public static int getInt(String propertyKey, String propertyName, String componentName, boolean fallback, int defaultValue) {
        Object o = SyntheticaLookAndFeel.get(propertyKey, propertyName, componentName, fallback);
        return o != null ? (Integer)o : defaultValue;
    }

    public static Object get(String key, Component c) {
        String name = c.getName();
        if (name == null) {
            return UIManager.get(key);
        }
        Object o = UIManager.get(String.valueOf(key) + "." + name);
        if (o != null) {
            return o;
        }
        return UIManager.get(key);
    }

    public static boolean getBoolean(String key, Component c) {
        Object o = SyntheticaLookAndFeel.get(key, c);
        return o != null ? (Boolean)o : false;
    }

    public static int getInt(String key, Component c) {
        return SyntheticaLookAndFeel.getInt(key, c, 0);
    }

    public static int getInt(String key, Component c, int defaultValue) {
        Object o = SyntheticaLookAndFeel.get(key, c);
        return o != null ? (Integer)o : defaultValue;
    }

    public static Insets getInsets(String key, Component c) {
        return (Insets)SyntheticaLookAndFeel.get(key, c);
    }

    public static String getString(String key, Component c) {
        return (String)SyntheticaLookAndFeel.get(key, c);
    }

    public static Color getColor(String key, Component c) {
        return (Color)SyntheticaLookAndFeel.get(key, c);
    }

    public static boolean isOpaque(JComponent c) {
        boolean opaque;
        boolean bl = opaque = c.getClientProperty("Synthetica.opaque") == null ? true : (Boolean)c.getClientProperty("Synthetica.opaque");
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
            opaque = c.isOpaque();
        }
        return opaque;
    }

    public static void setChildrenOpaque(Container container, boolean opaque) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.setOpaque(opaque);
                jc.putClientProperty("Synthetica.opaque", opaque);
                SyntheticaLookAndFeel.setChildrenOpaque(jc, opaque);
            }
            ++n;
        }
    }

    public static void setChildrenName(Container container, String oldName, String newName) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (oldName.equals(c.getName())) {
                c.setName(newName);
            }
            if (c instanceof Container) {
                SyntheticaLookAndFeel.setChildrenName((Container)c, oldName, newName);
            }
            ++n;
        }
    }

    public static Component findComponent(String name, Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component cc;
            Component c = componentArray[n];
            if (name.equals(c.getName())) {
                return c;
            }
            if (c instanceof Container && (cc = SyntheticaLookAndFeel.findComponent(name, (Container)c)) != null) {
                return cc;
            }
            ++n;
        }
        return null;
    }

    public static boolean popupHasIcons(JPopupMenu popup) {
        Component[] componentArray = popup.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c instanceof JMenuItem && ((JMenuItem)c).getIcon() != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean popupHasCheckRadio(JPopupMenu popup) {
        Component[] componentArray = popup.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c instanceof JCheckBoxMenuItem || c instanceof JRadioButtonMenuItem) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean popupHasCheckRadioWithIcon(JPopupMenu popup) {
        Component[] componentArray = popup.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            JMenuItem mi;
            Component c = componentArray[n];
            if ((c instanceof JCheckBoxMenuItem || c instanceof JRadioButtonMenuItem) && (mi = (JMenuItem)c).getIcon() != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private class Version
    implements IVersion {
        private int major;
        private int minor;
        private int revision;
        private int build;

        public Version() {
            ResourceBundle rb = SyntheticaLookAndFeel.this.getResourceBundle("SyntheticaStandardLookAndFeelVersion");
            this.major = Integer.parseInt(rb.getString("major"));
            this.minor = Integer.parseInt(rb.getString("minor"));
            this.revision = Integer.parseInt(rb.getString("revision"));
            this.build = Integer.parseInt(rb.getString("build"));
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getRevision() {
            return this.revision;
        }

        public int getBuild() {
            return this.build;
        }

        public String toString() {
            return String.valueOf(this.major) + "." + this.minor + "." + this.revision + " Build " + this.build;
        }
    }
}

