/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.util.java2d.DropShadow;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaTitlePane
extends JPanel {
    private static final long serialVersionUID = -6164225719742333375L;
    private JRootPane rootPane;
    private BasicRootPaneUI rootPaneUI;
    private Window window;
    private Frame frame;
    private Dialog dialog;
    private JButton menuButton;
    private JLabel titleLabel;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private JPopupMenu systemMenu;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private WindowListener windowListener;
    private PropertyChangeListener propertyChangeListener;
    private boolean selected = true;

    public SyntheticaTitlePane(JRootPane root, BasicRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        Container parent = this.rootPane.getParent();
        Window window = this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window instanceof Frame) {
            this.frame = (Frame)this.window;
        } else if (this.window instanceof Dialog) {
            this.dialog = (Dialog)this.window;
        }
        if (SyntheticaLookAndFeel.get("Synthetica.rootPane.titlePane.opaque", this.window) != null) {
            this.setOpaque(SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.opaque", this.window));
        }
        int xGap = 4;
        Border titleBorder = BorderFactory.createEmptyBorder(3, 0, 4, 0);
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createHorizontalStrut(xGap));
        this.closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SyntheticaTitlePane.this.close();
            }
        };
        int decorationStyle = this.rootPane.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.iconifyAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SyntheticaTitlePane.this.iconify();
                }
            };
            this.restoreAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SyntheticaTitlePane.this.restore();
                }
            };
            this.maximizeAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SyntheticaTitlePane.this.maximize();
                }
            };
            this.menuButton = this.createTitlePaneButton();
            this.menuButton.setIcon(this.getFrameIcon());
            this.window.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("iconImage".equals(evt.getPropertyName())) {
                        SyntheticaTitlePane.this.menuButton.setIcon(SyntheticaTitlePane.this.getFrameIcon());
                    }
                }
            });
            this.systemMenu = new JPopupMenu();
            this.addMenuItems(this.systemMenu);
            this.menuButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SyntheticaTitlePane.this.systemMenu.show(SyntheticaTitlePane.this, 0, SyntheticaTitlePane.this.getHeight());
                }
            });
            this.add(this.menuButton);
            this.add(Box.createHorizontalStrut(xGap));
        }
        this.titleLabel = this.getTitle() != null ? new JLabel(" ") : new JLabel("");
        this.titleLabel.setBorder(titleBorder);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.add(this.titleLabel);
        this.add(Box.createHorizontalGlue());
        this.createButtons();
        if (decorationStyle == 1 && this.dialog == null) {
            this.add(Box.createHorizontalStrut(xGap));
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(Box.createHorizontalStrut(xGap));
        }
        this.add(this.closeButton);
        this.add(Box.createHorizontalStrut(xGap));
        this.installListeners();
        this.setComponentsActiveState(this.window.isActive());
        if (this.frame != null && this.frame.getIconImage() == null) {
            this.frame.setIconImage(((ImageIcon)this.getFrameIcon()).getImage());
        }
        this.updateState();
    }

    private void installListeners() {
        this.windowListener = new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (SyntheticaTitlePane.this.rootPane.getWindowDecorationStyle() == 1 && SyntheticaTitlePane.this.dialog == null) {
                    SyntheticaTitlePane.this.updateToggleButton();
                    SyntheticaTitlePane.this.updateState();
                }
            }

            public void windowStateChanged(WindowEvent e) {
                SyntheticaTitlePane.this.updateToggleButton();
                SyntheticaTitlePane.this.updateState();
            }

            public void windowActivated(WindowEvent ev) {
                SyntheticaTitlePane.this.setActive(true);
                SyntheticaTitlePane.this.selected = true;
            }

            public void windowDeactivated(WindowEvent ev) {
                SyntheticaTitlePane.this.setActive(false);
                SyntheticaTitlePane.this.selected = false;
            }
        };
        this.window.addWindowListener(this.windowListener);
        this.window.addWindowStateListener((WindowStateListener)((Object)this.windowListener));
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                String name = pce.getPropertyName();
                if ("title".equals(name)) {
                    SyntheticaTitlePane.this.titleLabel.setText(SyntheticaTitlePane.this.getTitle());
                } else if ("resizable".equals(name)) {
                    boolean resizable = (Boolean)pce.getNewValue();
                    SyntheticaTitlePane.this.toggleButton.setEnabled(resizable);
                    SyntheticaTitlePane.this.systemMenu.removeAll();
                    SyntheticaTitlePane.this.addMenuItems(SyntheticaTitlePane.this.systemMenu);
                }
            }
        };
        this.window.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void uninstallListeners() {
        this.window.removeWindowListener(this.windowListener);
        this.window.removePropertyChangeListener(this.propertyChangeListener);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private String getTitle() {
        if (this.frame != null) {
            return this.frame.getTitle();
        }
        if (this.dialog != null) {
            return this.dialog.getTitle();
        }
        return null;
    }

    private Icon getFrameIcon() {
        Image image = this.frame != null ? this.frame.getIconImage() : null;
        Icon icon = null;
        if (image != null) {
            icon = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.menuButton.useOriginalImageSize", this.window) ? new ImageIcon(image) : new ImageIcon(image.getScaledInstance(16, 16, 4));
        } else {
            SynthStyle ss = SynthLookAndFeel.getStyle(this.rootPane, Region.ROOT_PANE);
            SynthContext sc = new SynthContext(this.rootPane, Region.ROOT_PANE, ss, 1024);
            icon = ss.getIcon(sc, "RootPane.icon");
        }
        return icon;
    }

    private void setActive(boolean active) {
        this.setComponentsActiveState(active);
        this.getRootPane().repaint();
    }

    private void setComponentsActiveState(boolean active) {
        JInternalFrame c = new JInternalFrame();
        SynthStyle ss = SynthLookAndFeel.getStyleFactory().getStyle(c, Region.INTERNAL_FRAME_TITLE_PANE);
        int state = 1024;
        if (active) {
            state = 512;
        }
        SynthContext sc = new SynthContext(c, Region.INTERNAL_FRAME_TITLE_PANE, ss, state);
        Font font = ss.getFont(sc);
        font = font.deriveFont(font.getStyle(), font.getSize());
        this.titleLabel.setFont(font);
        Color fg = ss.getColor(sc, ColorType.FOREGROUND);
        fg = new Color(fg.getRGB());
        this.titleLabel.setForeground(fg);
        this.closeButton.putClientProperty("paintActive", active);
        if (this.rootPane.getWindowDecorationStyle() == 1 && this.dialog == null) {
            this.iconifyButton.putClientProperty("paintActive", active);
            this.toggleButton.putClientProperty("paintActive", active);
        }
    }

    private boolean isFrameResizable() {
        return this.frame != null && this.frame.isResizable();
    }

    private boolean isFrameMaximized() {
        return this.frame != null && (this.frame.getExtendedState() & 6) == 6;
    }

    private boolean isSelected() {
        return this.window == null ? true : this.window.isActive();
    }

    private void addMenuItems(JPopupMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        mi.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.restoreButtonText", this.window));
        mi.setMnemonic('R');
        mi.setEnabled(this.isFrameResizable());
        mi = menu.add(this.iconifyAction);
        mi.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.minimizeButtonText", this.window));
        mi.setMnemonic('n');
        mi.setEnabled(this.frame != null);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
            mi.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.maximizeButtonText", this.window));
            mi.setMnemonic('x');
            mi.setEnabled(this.isFrameResizable());
        }
        menu.addSeparator();
        mi = menu.add(this.closeAction);
        mi.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.closeButtonText", this.window));
        mi.setMnemonic('C');
    }

    private JButton createTitlePaneButton() {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        return button;
    }

    private void createButtons() {
        MouseAdapter listener = new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                JButton b = (JButton)evt.getSource();
                String name = "Synthetica." + b.getName() + "Icon.hover";
                b.setIcon((Icon)b.getClientProperty(name));
            }

            public void mouseExited(MouseEvent evt) {
                JButton b = (JButton)evt.getSource();
                String name = "Synthetica." + b.getName() + "Icon";
                b.setIcon((Icon)b.getClientProperty(name));
            }
        };
        SynthStyle ss = SynthLookAndFeel.getStyle(this.rootPane, Region.ROOT_PANE);
        SynthContext sc = new SynthContext(this.rootPane, Region.ROOT_PANE, ss, 1024);
        Icon closeIcon = ss.getIcon(sc, "RootPane.closeIcon");
        Icon iconifyIcon = ss.getIcon(sc, "RootPane.iconifyIcon");
        Icon maximizeIcon = ss.getIcon(sc, "RootPane.maximizeIcon");
        Icon minimizeIcon = ss.getIcon(sc, "RootPane.minimizeIcon");
        sc = new SynthContext(this.rootPane, Region.ROOT_PANE, ss, 2);
        Icon closeIconHover = ss.getIcon(sc, "RootPane.closeIcon");
        Icon iconifyIconHover = ss.getIcon(sc, "RootPane.iconifyIcon");
        Icon maximizeIconHover = ss.getIcon(sc, "RootPane.maximizeIcon");
        Icon minimizeIconHover = ss.getIcon(sc, "RootPane.minimizeIcon");
        this.closeButton = this.createTitlePaneButton();
        this.closeButton.setName("close");
        this.closeButton.putClientProperty("Synthetica.closeIcon", closeIcon);
        this.closeButton.putClientProperty("Synthetica.closeIcon.hover", closeIconHover);
        this.closeButton.setAction(this.closeAction);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(closeIcon);
        this.closeButton.addMouseListener(listener);
        if (this.rootPane.getWindowDecorationStyle() == 1 && this.dialog == null) {
            this.iconifyButton = this.createTitlePaneButton();
            this.iconifyButton.setName("iconify");
            this.iconifyButton.putClientProperty("Synthetica.iconifyIcon", iconifyIcon);
            this.iconifyButton.putClientProperty("Synthetica.iconifyIcon.hover", iconifyIconHover);
            this.iconifyButton.setAction(this.iconifyAction);
            this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
            this.iconifyButton.setIcon(iconifyIcon);
            this.iconifyButton.addMouseListener(listener);
            this.toggleButton = this.createTitlePaneButton();
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon", maximizeIcon);
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon.hover", maximizeIconHover);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon", minimizeIcon);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon.hover", minimizeIconHover);
            this.updateToggleButton();
            this.toggleButton.addMouseListener(listener);
        }
    }

    private void updateToggleButton() {
        Icon icon = null;
        if (!this.isFrameMaximized()) {
            this.toggleButton.setAction(this.maximizeAction);
            this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
            this.toggleButton.setName("maximize");
            icon = (Icon)this.toggleButton.getClientProperty("Synthetica.maximizeIcon");
        } else {
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.getAccessibleContext().setAccessibleName("Restore");
            this.toggleButton.setName("minimize");
            icon = (Icon)this.toggleButton.getClientProperty("Synthetica.minimizeIcon");
        }
        this.toggleButton.setIcon(icon);
        this.toggleButton.setEnabled(this.isFrameResizable());
    }

    public void paintComponent(Graphics g) {
        int tx;
        String title;
        super.paintComponent(g);
        String imagePath = "Synthetica.rootPane.titlePane.background";
        if (this.isSelected()) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, this.window);
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.background.insets", this.window);
        int xPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.background.horizontalTiled", this.window)) {
            xPolicy = 1;
        }
        int yPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.background.verticalTiled", this.window)) {
            yPolicy = 1;
        }
        ImagePainter iPainter = null;
        if (imagePath != null) {
            iPainter = new ImagePainter(g, 0, 0, this.getWidth(), this.getHeight(), imagePath, insets, insets, xPolicy, yPolicy);
            iPainter.draw();
        }
        imagePath = "Synthetica.rootPane.titlePane.background.light";
        if (this.isSelected()) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        if ((imagePath = SyntheticaLookAndFeel.getString(imagePath, this.window)) != null) {
            iPainter = new ImagePainter(g, 0, 0, this.getWidth(), this.getHeight(), imagePath, insets, insets, 0, yPolicy);
            iPainter.draw();
        }
        if ((title = this.getTitle()) == null || title.length() == 0) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.titleLabel.getFont());
        int th = fm.getHeight();
        int tw = fm.stringWidth(title);
        int n = tx = this.menuButton != null ? this.menuButton.getWidth() + 8 : 4;
        if (title.startsWith("W")) {
            ++tx;
        }
        int ty = (this.getSize().height - th) / 2;
        JInternalFrame iFrame = new JInternalFrame();
        SynthStyle ss = SynthLookAndFeel.getStyle(iFrame, Region.INTERNAL_FRAME_TITLE_PANE);
        int state = 1024;
        if (this.selected) {
            state = 512;
        }
        SynthContext sc = new SynthContext(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, ss, state);
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.dropShadow", this.window) && this.selected) {
            BufferedImage image = new BufferedImage(tw, th, 2);
            Graphics2D g2 = image.createGraphics();
            g2.setFont(this.titleLabel.getFont());
            ((Graphics)g2).drawString(title, 0, fm.getAscent());
            g2.dispose();
            DropShadow ds = new DropShadow(image);
            ds.setDistance(SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.distance", this.window, -5));
            if (SyntheticaLookAndFeel.getColor("Synthetica.rootPane.titlePane.dropShadow.color", this.window) != null) {
                ds.setShadowColor(SyntheticaLookAndFeel.getColor("Synthetica.rootPane.titlePane.dropShadow.color", this.window));
            }
            if (SyntheticaLookAndFeel.get("Synthetica.rootPane.titlePane.dropShadow.highQuality", this.window) != null) {
                ds.setQuality(SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.dropShadow.highQuality", this.window));
            }
            ds.paintShadow(g, tx, ty);
        }
        g.setColor(ss.getColor(sc, ColorType.FOREGROUND));
        g.setFont(this.titleLabel.getFont());
        ss.getGraphicsUtils(sc).paintText(sc, g, title, tx, ty, -1);
    }

    private void close() {
        this.window.dispatchEvent(new WindowEvent(this.window, 201));
    }

    private void iconify() {
        int state = this.frame.getExtendedState();
        this.frame.setExtendedState(state | 1);
        this.updateState();
    }

    void maximize() {
        int state = this.frame.getExtendedState();
        ((SyntheticaRootPaneUI)this.rootPaneUI).setMaximizedBounds(this.frame);
        this.frame.setExtendedState(state | 6);
        this.updateState();
    }

    void restore() {
        int state = this.frame.getExtendedState();
        if ((state & 1) == 1) {
            this.frame.setExtendedState(state ^ 1);
        } else if ((state & 6) == 6) {
            this.frame.setExtendedState(state ^ 6);
        }
        this.updateState();
    }

    private void updateState() {
        if (this.frame == null) {
            return;
        }
        switch (this.frame.getExtendedState()) {
            case 6: {
                this.restoreAction.setEnabled(true);
                this.maximizeAction.setEnabled(false);
                this.iconifyAction.setEnabled(true);
                break;
            }
            case 1: {
                this.restoreAction.setEnabled(true);
                this.maximizeAction.setEnabled(true);
                this.iconifyAction.setEnabled(false);
                break;
            }
            default: {
                this.restoreAction.setEnabled(false);
                this.maximizeAction.setEnabled(true);
                this.iconifyAction.setEnabled(true);
            }
        }
    }
}

