/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.filechooser;

import de.javasoft.io.FileProperties;
import de.javasoft.io.FileUtils;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.filechooser.FileOperationDialog;
import de.javasoft.plaf.synthetica.filechooser.FilePropertiesDialog;
import de.javasoft.plaf.synthetica.filechooser.SyntheticaFileChooserUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.awt.shell.ShellFolder;
import sun.security.action.GetPropertyAction;
import sun.swing.plaf.synth.DefaultSynthStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticaFileChooserUI
extends BasicFileChooserUI
implements ActionListener {
    private static final int LIST_VIEW = 0;
    private static final int TABLE_VIEW = 1;
    private static final int TREE_VIEW = 2;
    private JButton newFolderButton;
    private JComboBox directoryComboBox;
    private JLabel lookInLabel;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel controlButtonPanel;
    private JTextField fileNameTextField;
    private FilePane filePane;
    private boolean readOnly;
    private HashSet<File> cutBuffer = new HashSet();
    private HashSet<File> copyBuffer = new HashSet();
    private boolean useSystemFileIcons = SyntheticaLookAndFeel.getUseSystemFileIcons();
    private boolean directoryChooser = false;

    public SyntheticaFileChooserUI(JFileChooser fileChooser) {
        super(fileChooser);
    }

    protected SyntheticaFileChooserUI(JFileChooser fileChooser, boolean directoryChooser) {
        super(fileChooser);
        this.directoryChooser = directoryChooser;
        if (directoryChooser) {
            fileChooser.setFileSelectionMode(1);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaFileChooserUI((JFileChooser)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (SyntheticaLookAndFeel.getRememberFileChooserPreferences() && !this.directoryChooser) {
            String title = "";
            Frame[] frames = Frame.getFrames();
            int i = 0;
            while (i < frames.length) {
                Frame frame = frames[i];
                if (frame instanceof JFrame) {
                    title = frame.getTitle() != null ? frame.getTitle() : "";
                    break;
                }
                ++i;
            }
            int maxLen = title.length() > 50 ? 50 : title.length();
            String path = title.substring(0, maxLen);
            final Preferences sysPrefs = Preferences.userRoot().node(String.valueOf(path) + "." + "SyntheticaFileChooser");
            final JFileChooser fc = this.getFileChooser();
            new Thread(){

                public void run() {
                    Dialog dialog = null;
                    while ((dialog = SyntheticaFileChooserUI.this.getDialog()) == null || !dialog.isShowing()) {
                        try {
                            17.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    int xPos = sysPrefs.getInt("xPos", dialog.getLocation().x);
                    int yPos = sysPrefs.getInt("yPos", dialog.getLocation().y);
                    int width = sysPrefs.getInt("width", dialog.getSize().width);
                    int height = sysPrefs.getInt("height", dialog.getSize().height);
                    GraphicsConfiguration gc = dialog.getGraphicsConfiguration();
                    Rectangle r = gc.getBounds();
                    if (xPos < r.x || xPos + width > r.x + r.width || yPos < r.y || yPos + height > r.y + r.height) {
                        xPos = dialog.getLocation().x;
                        yPos = dialog.getLocation().y;
                        width = dialog.getSize().width;
                        height = dialog.getSize().height;
                    }
                    dialog.setBounds(xPos, yPos, width, height);
                    SyntheticaFileChooserUI.this.filePane.setView(sysPrefs.getInt("view", SyntheticaFileChooserUI.this.filePane.getView()));
                    SyntheticaFileChooserUI.this.filePane.sortColumn = sysPrefs.getInt("sortColumn", SyntheticaFileChooserUI.this.filePane.sortColumn);
                    SyntheticaFileChooserUI.this.filePane.sortOrder = sysPrefs.getInt("sortOrder", SyntheticaFileChooserUI.this.filePane.sortOrder);
                    File dir = new File(sysPrefs.get("directory" + fc.getDialogType(), fc.getCurrentDirectory().getAbsolutePath()));
                    fc.setCurrentDirectory(dir);
                    SyntheticaFileChooserUI.this.getDialog().addWindowListener(new WindowAdapter(this, sysPrefs, fc){
                        final /* synthetic */ 17 this$1;
                        private final /* synthetic */ Preferences val$sysPrefs;
                        private final /* synthetic */ JFileChooser val$fc;
                        {
                            this.this$1 = var1_1;
                            this.val$sysPrefs = preferences;
                            this.val$fc = jFileChooser;
                        }

                        public void windowClosed(WindowEvent e) {
                            Dialog dialog = SyntheticaFileChooserUI.access$8(17.access$0(this.this$1));
                            int xPos = dialog.getLocation().x;
                            int yPos = dialog.getLocation().y;
                            int width = dialog.getSize().width;
                            int height = dialog.getSize().height;
                            this.val$sysPrefs.putInt("xPos", xPos);
                            this.val$sysPrefs.putInt("yPos", yPos);
                            this.val$sysPrefs.putInt("width", width);
                            this.val$sysPrefs.putInt("height", height);
                            this.val$sysPrefs.putInt("view", FilePane.access$23(SyntheticaFileChooserUI.access$2(17.access$0(this.this$1))));
                            this.val$sysPrefs.putInt("sortColumn", FilePane.access$2(SyntheticaFileChooserUI.access$2(17.access$0(this.this$1))));
                            this.val$sysPrefs.putInt("sortOrder", FilePane.access$4(SyntheticaFileChooserUI.access$2(17.access$0(this.this$1))));
                            this.val$sysPrefs.put("directory" + this.val$fc.getDialogType(), this.val$fc.getCurrentDirectory().getAbsolutePath());
                        }
                    });
                }

                static /* synthetic */ SyntheticaFileChooserUI access$0(17 var0) {
                    return var0.SyntheticaFileChooserUI.this;
                }
            }.start();
        }
    }

    @Override
    public void installComponents(final JFileChooser fc) {
        Component c;
        if (this.directoryChooser) {
            fc.setDialogTitle(UIManager.getString("DirectoryChooser.title"));
        }
        int xGap = 10;
        int yGap = 10;
        Locale locale = fc.getLocale();
        fc.setLayout(new BorderLayout(0, yGap));
        fc.setBorder(new EmptyBorder(yGap, xGap, yGap, xGap));
        JPanel northPanel = new JPanel(new BorderLayout(xGap, 0));
        this.lookInLabel = new JLabel(UIManager.getString((Object)"FileChooser.lookInLabelText", locale));
        this.lookInLabel.setDisplayedMnemonic(UIManager.getInt("FileChooser.lookInLabelMnemonic"));
        northPanel.add((Component)this.lookInLabel, "West");
        this.directoryComboBox = new JComboBox();
        final DirectoryComboBoxModel directoryComboBoxModel = new DirectoryComboBoxModel();
        this.directoryComboBox.setModel(directoryComboBoxModel);
        this.directoryComboBox.setRenderer(new DefaultListCellRenderer(){
            IndentIcon ii;
            {
                this.ii = new IndentIcon();
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setText("");
                    return this;
                }
                File directory = (File)value;
                this.setText(fc.getName(directory));
                if (SyntheticaFileChooserUI.this.useSystemFileIcons) {
                    FileSystemView fsv = FileSystemView.getFileSystemView();
                    this.ii.icon = fsv.getSystemIcon(directory);
                }
                if (this.ii.icon == null || !SyntheticaFileChooserUI.this.useSystemFileIcons) {
                    this.ii.icon = SyntheticaFileChooserUI.this.getFileChooser().getIcon(directory);
                }
                this.ii.depth = directoryComboBoxModel.getDepth(index);
                this.setIcon(this.ii);
                return this;
            }
        });
        this.directoryComboBox.addActionListener(this);
        this.directoryComboBox.setActionCommand("directoryComboBox.select");
        this.directoryComboBox.setMaximumRowCount(15);
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        northPanel.add(this.directoryComboBox);
        Box iconButtonPanel = new Box(2);
        iconButtonPanel.add(Box.createHorizontalStrut(xGap));
        boolean paintBorder = UIManager.getBoolean("Synthetica.extendedFileChooser.actionButtons.paintBorder");
        JButton upFolderButton = new JButton(this.upFolderIcon);
        upFolderButton.setToolTipText(UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale));
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            upFolderButton.setMargin(new Insets(0, 0, 0, 0));
            if (!paintBorder) {
                upFolderButton.setBorderPainted(false);
            }
        } else {
            upFolderButton.setMargin(new Insets(2, 2, 2, 2));
        }
        upFolderButton.addActionListener(this);
        upFolderButton.setActionCommand("upFolderAction");
        iconButtonPanel.add(upFolderButton);
        JButton goHomeButton = new JButton(this.homeFolderIcon);
        goHomeButton.setToolTipText(UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale));
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            goHomeButton.setMargin(new Insets(0, 0, 0, 0));
            if (!paintBorder) {
                goHomeButton.setBorderPainted(false);
            }
        } else {
            goHomeButton.setMargin(new Insets(2, 2, 2, 2));
        }
        goHomeButton.addActionListener(this);
        goHomeButton.setActionCommand("goHomeAction");
        iconButtonPanel.add(goHomeButton);
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        if (!this.readOnly) {
            this.newFolderButton = new JButton(this.newFolderIcon);
            this.newFolderButton.setToolTipText(UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale));
            if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
                this.newFolderButton.setMargin(new Insets(0, 0, 0, 0));
                if (!paintBorder) {
                    this.newFolderButton.setBorderPainted(false);
                }
            } else {
                this.newFolderButton.setMargin(new Insets(2, 2, 2, 2));
            }
            this.newFolderButton.addActionListener(this);
            this.newFolderButton.setActionCommand("newFolderAction");
            iconButtonPanel.add(this.newFolderButton);
        }
        if (!this.directoryChooser) {
            iconButtonPanel.add(Box.createHorizontalStrut(xGap * 2));
        }
        ButtonGroup viewButtonGroup = new ButtonGroup();
        final JToggleButton listViewButton = new JToggleButton(this.listViewIcon);
        listViewButton.setToolTipText(UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", locale));
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            listViewButton.setMargin(new Insets(0, 0, 0, 0));
            if (!paintBorder) {
                listViewButton.setBorderPainted(false);
            }
        } else {
            listViewButton.setMargin(new Insets(2, 2, 2, 2));
        }
        listViewButton.addActionListener(this);
        listViewButton.setActionCommand("view.listAction");
        viewButtonGroup.add(listViewButton);
        if (!this.directoryChooser) {
            iconButtonPanel.add(listViewButton);
        }
        final JToggleButton detailsViewButton = new JToggleButton(this.detailsViewIcon);
        detailsViewButton.setToolTipText(UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", locale));
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            detailsViewButton.setMargin(new Insets(0, 0, 0, 0));
            if (!paintBorder) {
                detailsViewButton.setBorderPainted(false);
            }
        } else {
            detailsViewButton.setMargin(new Insets(2, 2, 2, 2));
        }
        detailsViewButton.addActionListener(this);
        detailsViewButton.setActionCommand("view.detailsAction");
        viewButtonGroup.add(detailsViewButton);
        if (!this.directoryChooser) {
            iconButtonPanel.add(detailsViewButton);
        }
        northPanel.add((Component)iconButtonPanel, "East");
        fc.add((Component)northPanel, "North");
        this.filePane = new FilePane();
        this.filePane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("SET_VIEW")) {
                    int view = (Integer)evt.getNewValue();
                    if (view == 0) {
                        listViewButton.setSelected(true);
                    } else if (view == 1) {
                        detailsViewButton.setSelected(true);
                    }
                }
            }
        });
        if (this.directoryChooser) {
            this.filePane.setView(2);
        } else {
            this.filePane.setView(0);
        }
        fc.addPropertyChangeListener(this.filePane);
        fc.add((Component)this.filePane, "Center");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        fc.add((Component)this.getAccessoryPanel(), "After");
        JPanel southPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, yGap / 2, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JLabel fileNameLabel = new JLabel(UIManager.getString((Object)"FileChooser.fileNameLabelText", locale));
        if (this.directoryChooser) {
            fileNameLabel.setText(UIManager.getString((Object)"DirectoryChooser.directoryNameLabelText", locale));
        }
        fileNameLabel.setBorder(new EmptyBorder(0, 0, 0, xGap));
        southPanel.add((Component)fileNameLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.fileNameTextField = new JTextField();
        southPanel.add((Component)this.fileNameTextField, gbc);
        if (!this.directoryChooser) {
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            JLabel filesOfTypeLabel = new JLabel(UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale));
            filesOfTypeLabel.setBorder(new EmptyBorder(0, 0, 0, xGap));
            southPanel.add((Component)filesOfTypeLabel, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            JComboBox<Object> filterComboBox = new JComboBox<Object>();
            filterComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value != null && value instanceof FileFilter) {
                        this.setText(((FileFilter)value).getDescription());
                    }
                    if (isSelected) {
                        this.setOpaque(true);
                    } else {
                        this.setOpaque(false);
                    }
                    return this;
                }
            });
            FilterComboBoxModel filterComboBoxModel = new FilterComboBoxModel();
            filterComboBox.setModel(filterComboBoxModel);
            fc.addPropertyChangeListener(filterComboBoxModel);
            southPanel.add(filterComboBox, gbc);
        }
        gbc.insets = new Insets(yGap * 2, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.approveButton = this.directoryChooser ? new JButton(UIManager.getString("DirectoryChooser.approveButtonText")) : new JButton(this.getApproveButtonText(fc));
        this.cancelButton = new JButton(this.cancelButtonText);
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        SpringLayout layout = new SpringLayout();
        this.controlButtonPanel = new JPanel(layout);
        this.controlButtonPanel.add(this.approveButton);
        this.controlButtonPanel.add(this.cancelButton);
        layout.putConstraint("East", (Component)this.cancelButton, 0, "East", (Component)this.controlButtonPanel);
        layout.putConstraint("East", (Component)this.approveButton, -xGap, "West", (Component)this.cancelButton);
        Spring maxWidth = Spring.constant(0);
        Component[] componentArray = this.controlButtonPanel.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            c = componentArray[n];
            maxWidth = Spring.max(maxWidth, layout.getConstraints(c).getWidth());
            ++n;
        }
        componentArray = this.controlButtonPanel.getComponents();
        n = 0;
        n2 = componentArray.length;
        while (n < n2) {
            c = componentArray[n];
            SpringLayout.Constraints constraints = layout.getConstraints(c);
            constraints.setWidth(maxWidth);
            ++n;
        }
        this.controlButtonPanel.setPreferredSize(this.cancelButton.getPreferredSize());
        this.controlButtonPanel.setMinimumSize(this.cancelButton.getPreferredSize());
        southPanel.add((Component)this.controlButtonPanel, gbc);
        fc.add((Component)southPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String actionCommand = evt.getActionCommand();
        if (actionCommand.startsWith("directoryComboBox.select")) {
            this.directoryComboBox.hidePopup();
            this.getFileChooser().setCurrentDirectory((File)this.directoryComboBox.getSelectedItem());
        } else if (actionCommand.startsWith("upFolderAction")) {
            this.getChangeToParentDirectoryAction().actionPerformed(evt);
        } else if (actionCommand.startsWith("goHomeAction")) {
            this.getGoHomeAction().actionPerformed(evt);
        } else if (actionCommand.startsWith("newFolderAction")) {
            this.filePane.newCreatedFile = true;
            this.getNewFolderAction().actionPerformed(evt);
        } else if (actionCommand.startsWith("view.")) {
            if (actionCommand.endsWith("listAction")) {
                this.filePane.setView(0);
            } else if (actionCommand.endsWith("detailsAction")) {
                this.filePane.setView(1);
            } else if (actionCommand.endsWith("treeAction")) {
                this.filePane.setView(2);
            }
        } else if (actionCommand.startsWith("approveAction")) {
            this.getApproveSelectionAction().actionPerformed(new ActionEvent(this, 0, ""));
        } else if (actionCommand.startsWith("orderBy.")) {
            if (this.filePane == null) {
                return;
            }
            if (actionCommand.endsWith("nameAction")) {
                if (this.filePane.sortColumn == 0 && this.filePane.sortOrder == 1) {
                    return;
                }
                this.filePane.sortColumn = 0;
            } else if (actionCommand.endsWith("sizeAction")) {
                if (this.filePane.sortColumn == 1 && this.filePane.sortOrder == 1) {
                    return;
                }
                this.filePane.sortColumn = 1;
            } else if (actionCommand.endsWith("dateAction")) {
                if (this.filePane.sortColumn == 3 && this.filePane.sortOrder == 1) {
                    return;
                }
                this.filePane.sortColumn = 3;
            }
            this.filePane.sortOrder = 1;
            this.filePane.detailsTableSortModel.sort();
            this.filePane.viewPanel.repaint();
            if (this.filePane.view == 2) {
                this.rescanCurrentDirectory(this.getFileChooser());
            }
        } else if (actionCommand.startsWith("refreshAction")) {
            this.rescanCurrentDirectory(this.getFileChooser());
        } else if (actionCommand.startsWith("cutAction")) {
            this.fillFileBuffer(this.cutBuffer);
            this.copyBuffer.clear();
            this.filePane.clearSelection();
            this.filePane.repaint();
        } else if (actionCommand.startsWith("copyAction")) {
            this.fillFileBuffer(this.copyBuffer);
            if (!this.cutBuffer.isEmpty()) {
                this.cutBuffer.clear();
                this.filePane.repaint();
            }
        } else if (actionCommand.startsWith("pasteAction")) {
            HashSet fileBuffer;
            int fileOperation = 0;
            if (!this.cutBuffer.isEmpty()) {
                fileBuffer = (HashSet)this.cutBuffer.clone();
                fileOperation = 2;
            } else {
                fileBuffer = (HashSet)this.copyBuffer.clone();
                fileOperation = 1;
            }
            final File currentDirectory = this.getFileChooser().getCurrentDirectory();
            final FileOperationDialog dialog = new FileOperationDialog(this.getDialog(), fileOperation);
            final boolean moveOperation = fileOperation == 2;
            dialog.setVisible(true);
            new Thread(){

                public void run() {
                    Iterator it = fileBuffer.iterator();
                    while (it.hasNext()) {
                        File source = (File)it.next();
                        File destination = new File(currentDirectory, source.getName());
                        if (!source.exists()) {
                            it.remove();
                            continue;
                        }
                        if (!SyntheticaFileChooserUI.this.cutBuffer.isEmpty() && source.equals(destination)) {
                            it.remove();
                            continue;
                        }
                        if (source.equals(destination)) {
                            int copyNumber = 0;
                            while (destination.exists()) {
                                String copyNumberString = ++copyNumber == 1 ? "" : "(" + copyNumber + ") ";
                                String copyString = UIManager.getString((Object)"FileChooser.copyAction.copyFilename", SyntheticaFileChooserUI.this.getFileChooser().getLocale());
                                String filename = MessageFormat.format(copyString, copyNumberString, source.getName());
                                destination = new File(destination.getParentFile(), filename);
                            }
                        }
                        try {
                            boolean abort;
                            boolean bl = abort = !FileUtils.copy(source, destination, true, true, SyntheticaFileChooserUI.this.copyBuffer.isEmpty(), dialog);
                            if (!abort) continue;
                            break;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    dialog.dispose();
                    SwingUtilities.invokeLater(new Runnable(this, moveOperation, fileBuffer){
                        final /* synthetic */ 22 this$1;
                        private final /* synthetic */ boolean val$moveOperation;
                        private final /* synthetic */ HashSet val$fileBuffer;
                        {
                            this.this$1 = var1_1;
                            this.val$moveOperation = bl;
                            this.val$fileBuffer = hashSet;
                        }

                        public void run() {
                            if (FilePane.access$22(SyntheticaFileChooserUI.access$2(22.access$0(this.this$1))) == 2 && this.val$moveOperation) {
                                HashSet<File> refreshDirs = new HashSet<File>();
                                for (File f : this.val$fileBuffer) {
                                    refreshDirs.add(f.getParentFile());
                                }
                                for (File f : refreshDirs) {
                                    TreePath path = FilePane.access$19(SyntheticaFileChooserUI.access$2(22.access$0(this.this$1)), f);
                                    FilePane.FileNode.access$0((FilePane.FileNode)path.getLastPathComponent());
                                    ((DefaultTreeModel)FilePane.access$0(SyntheticaFileChooserUI.access$2(22.access$0(this.this$1))).getModel()).nodeStructureChanged((TreeNode)path.getLastPathComponent());
                                }
                            }
                            22.access$0(this.this$1).rescanCurrentDirectory(22.access$0(this.this$1).getFileChooser());
                        }
                    });
                }

                static /* synthetic */ SyntheticaFileChooserUI access$0(22 var0) {
                    return var0.SyntheticaFileChooserUI.this;
                }
            }.start();
            if (!this.cutBuffer.isEmpty()) {
                this.cutBuffer.clear();
            }
        } else if (actionCommand.startsWith("deleteAction")) {
            if (this.readOnly || this.filePane.isSelectionEmpty()) {
                return;
            }
            String confirmMessage = UIManager.getString("FileChooser.deleteAction.confirmMessage");
            String confirmDialogTitle = UIManager.getString("FileChooser.deleteAction.confirmDialogTitle");
            JOptionPane opane = new JOptionPane();
            SynthStyle style = SynthLookAndFeel.getStyleFactory().getStyle(opane, Region.OPTION_PANE);
            SynthContext sc = new SynthContext(opane, Region.OPTION_PANE, style, 1024);
            Icon stopIcon = ((DefaultSynthStyle)style).getIcon(sc, "OptionPane.stopIcon");
            int result = JOptionPane.showConfirmDialog(this.getFileChooser(), confirmMessage, confirmDialogTitle, 2, 3, stopIcon);
            if (result != 0) {
                return;
            }
            final HashSet<File> deleteBuffer = new HashSet<File>();
            this.fillFileBuffer(deleteBuffer);
            final FileOperationDialog dialog = new FileOperationDialog(this.getDialog(), 3);
            dialog.setVisible(true);
            new Thread(){

                public void run() {
                    Iterator it = deleteBuffer.iterator();
                    while (it.hasNext()) {
                        boolean abort;
                        File file = (File)it.next();
                        boolean bl = abort = !FileUtils.delete(file, true, dialog);
                        if (abort) break;
                        it.remove();
                    }
                    dialog.dispose();
                    SwingUtilities.invokeLater(new Runnable(this){
                        final /* synthetic */ 24 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (FilePane.access$22(SyntheticaFileChooserUI.access$2(24.access$0(this.this$1))) == 2 && !24.access$0(this.this$1).getFileChooser().getCurrentDirectory().exists()) {
                                File currentDir = 24.access$0(this.this$1).getFileChooser().getCurrentDirectory().getParentFile();
                                24.access$0(this.this$1).getFileChooser().setSelectedFile(currentDir);
                                24.access$0(this.this$1).getFileChooser().setCurrentDirectory(currentDir);
                            }
                            24.access$0(this.this$1).rescanCurrentDirectory(24.access$0(this.this$1).getFileChooser());
                        }
                    });
                }

                static /* synthetic */ SyntheticaFileChooserUI access$0(24 var0) {
                    return var0.SyntheticaFileChooserUI.this;
                }
            }.start();
        } else if (actionCommand.startsWith("propertiesAction")) {
            if (this.filePane.isSelectionEmpty()) {
                return;
            }
            final HashSet<File> buffer = new HashSet<File>();
            this.fillFileBuffer(buffer);
            final FilePropertiesDialog dialog = new FilePropertiesDialog(this.getDialog());
            final FileProperties props = new FileProperties();
            dialog.setVisible(true);
            new Thread(){

                public void run() {
                    for (File file : buffer) {
                        boolean abort = false;
                        try {
                            abort = !FileUtils.determineProperties(props, file, true, dialog);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (abort) break;
                    }
                    dialog.refresh();
                }
            }.start();
        } else if (actionCommand.startsWith("renameAction")) {
            if (this.filePane.view == 2) {
                this.filePane.tree.startEditingAtPath(this.filePane.tree.getSelectionModel().getSelectionPath());
            }
            this.filePane.editFileName();
        }
    }

    private Dialog getDialog() {
        Container parent = this.getFileChooser().getParent();
        while (parent != null) {
            if (parent instanceof Dialog) {
                return (Dialog)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private synchronized void fillFileBuffer(Collection<File> buffer) {
        buffer.clear();
        if (this.filePane.view == 2) {
            TreePath[] treePathArray = this.filePane.tree.getSelectionModel().getSelectionPaths();
            int n = 0;
            int n2 = treePathArray.length;
            while (n < n2) {
                TreePath path = treePathArray[n];
                FilePane.FileNode node = (FilePane.FileNode)path.getLastPathComponent();
                buffer.add(node.getFile());
                ++n;
            }
        } else {
            ListSelectionModel selected = this.filePane.list.getSelectionModel();
            FilePane.DetailsTableSortModel model = this.filePane.detailsTableSortModel;
            int i = 0;
            while (i < model.getRowCount()) {
                File file = (File)model.getValueAt(i, 0);
                if (selected.isSelectedIndex(i)) {
                    buffer.add(file);
                }
                ++i;
            }
        }
    }

    @Override
    public void setFileName(String filename) {
        this.fileNameTextField.setText(filename);
    }

    @Override
    public String getFileName() {
        return this.fileNameTextField.getText();
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String s = evt.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    SyntheticaFileChooserUI.this.doSelectedFileChanged(evt);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    SyntheticaFileChooserUI.this.doSelectedFilesChanged(evt);
                } else if (s.equals("directoryChanged")) {
                    SyntheticaFileChooserUI.this.doDirectoryChanged(evt);
                } else if (!s.equals("fileFilterChanged")) {
                    if (s.equals("fileSelectionChanged")) {
                        SyntheticaFileChooserUI.this.doFileSelectionModeChanged(evt);
                    } else if (s.equals("AccessoryChangedProperty")) {
                        SyntheticaFileChooserUI.this.doAccessoryChanged(evt);
                    } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                        SyntheticaFileChooserUI.this.doApproveButtonTextChanged(evt);
                    } else if (s.equals("DialogTypeChangedProperty")) {
                        SyntheticaFileChooserUI.this.doDialogTypeChanged(evt);
                    } else if (!s.equals("ApproveButtonMnemonicChangedProperty")) {
                        if (s.equals("ControlButtonsAreShownChangedProperty")) {
                            if (SyntheticaFileChooserUI.this.getFileChooser().getControlButtonsAreShown()) {
                                SyntheticaFileChooserUI.this.controlButtonPanel.setVisible(true);
                            } else {
                                SyntheticaFileChooserUI.this.controlButtonPanel.setVisible(false);
                            }
                        } else if (s.equals("componentOrientation")) {
                            ComponentOrientation o = (ComponentOrientation)evt.getNewValue();
                            JFileChooser cc = (JFileChooser)evt.getSource();
                            if (o != (ComponentOrientation)evt.getOldValue()) {
                                cc.applyComponentOrientation(o);
                            }
                        } else if (s != "FileChooser.useShellFolder" && s.equals("ancestor") && evt.getOldValue() == null) {
                            evt.getNewValue();
                        }
                    }
                }
            }
        };
    }

    private void doSelectedFileChanged(PropertyChangeEvent evt) {
        File file = (File)evt.getNewValue();
        if (file != null) {
            JFileChooser fc = this.getFileChooser();
            if (this.directoryChooser) {
                this.setFileName(file.getPath());
            } else if (fc.isDirectorySelectionEnabled() || !file.isDirectory()) {
                this.setFileName(file.getName());
            }
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent evt) {
        File[] files = (File[])evt.getNewValue();
        if (files != null && files.length > 1) {
            StringBuilder fileName = new StringBuilder();
            int i = 0;
            while (i < files.length) {
                fileName.append("\"");
                fileName.append(files[i].getName());
                fileName.append("\" ");
                ++i;
            }
            this.setFileName(fileName.toString().trim());
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent evt) {
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (!this.readOnly) {
            if (currentDirectory.canWrite()) {
                this.newFolderButton.setEnabled(true);
            } else {
                this.newFolderButton.setEnabled(false);
            }
        }
        ((DirectoryComboBoxModel)this.directoryComboBox.getModel()).addItem(currentDirectory);
        final TreePath treePath = this.filePane.getPath(currentDirectory);
        boolean calledFromSelection = false;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = 0;
        int n2 = stackTraceElementArray.length;
        while (n < n2) {
            StackTraceElement ste = stackTraceElementArray[n];
            if (ste.toString().contains("setSelectedFile")) {
                calledFromSelection = true;
                break;
            }
            ++n;
        }
        if (this.filePane.tree.getSelectionPath() == null || treePath != null && !treePath.equals(this.filePane.tree.getSelectionPath()) && !calledFromSelection) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SyntheticaFileChooserUI.this.filePane.tree.setSelectionPath(treePath);
                    SyntheticaFileChooserUI.this.filePane.tree.scrollPathToVisible(treePath);
                }
            });
        }
        if (this.directoryChooser && currentDirectory != null) {
            this.setFileName(currentDirectory.getPath());
        }
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent evt) {
    }

    private void doAccessoryChanged(PropertyChangeEvent evt) {
        if (this.getAccessoryPanel() == null) {
            return;
        }
        JComponent accessory = (JComponent)evt.getOldValue();
        if (accessory != null) {
            this.getAccessoryPanel().remove(accessory);
        }
        if ((accessory = (JComponent)evt.getNewValue()) != null) {
            this.getAccessoryPanel().add((Component)accessory, "Center");
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent evt) {
        JFileChooser fc = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
    }

    private void doDialogTypeChanged(PropertyChangeEvent evt) {
        JFileChooser fc = this.getFileChooser();
        this.doApproveButtonTextChanged(evt);
        if (fc.getDialogType() == 0) {
            this.lookInLabel.setText(UIManager.getString((Object)"FileChooser.lookInLabelText", fc.getLocale()));
        } else if (fc.getDialogType() == 1) {
            this.lookInLabel.setText(UIManager.getString((Object)"FileChooser.saveInLabelText", fc.getLocale()));
        }
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
        File rescanDir = this.getFileChooser().getCurrentDirectory();
        TreePath path = this.filePane.getPath(rescanDir);
        ((FilePane.FileNode)path.getLastPathComponent()).prepareForUpdateChildren();
        ((DefaultTreeModel)this.filePane.tree.getModel()).nodeStructureChanged((TreeNode)path.getLastPathComponent());
    }

    private class IndentIcon
    implements Icon {
        private Icon icon = null;
        private int depth = 0;
        private int indent = 10;

        IndentIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * this.indent, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * this.indent;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    private class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private ArrayList<File> directories = new ArrayList();
        private ArrayList<Integer> depths = new ArrayList();
        private File selectedDirectory = null;

        public DirectoryComboBoxModel() {
            File dir = SyntheticaFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            this.depths.clear();
            File[] baseFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders");
            this.directories.addAll((Collection<File>)Arrays.asList(baseFolders));
            try {
                directory = directory.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                directory = ShellFolder.getShellFolder(directory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File f = directory;
            ArrayList<File> path = new ArrayList<File>();
            do {
                path.add(f);
            } while ((f = f.getParentFile()) != null);
            ArrayList<File> dirList = new ArrayList<File>();
            int i = 0;
            while (i < path.size()) {
                f = (File)path.get(i);
                if (this.directories.contains(f)) {
                    for (File dir : this.directories) {
                        if (dir.equals(f)) {
                            int j = i;
                            while (j >= 0) {
                                dirList.add((File)path.get(j));
                                this.depths.add(new Integer(path.size() - 1 - j));
                                --j;
                            }
                            continue;
                        }
                        dirList.add(dir);
                        File parent = dir;
                        int parents = 0;
                        while ((parent = parent.getParentFile()) != null) {
                            ++parents;
                        }
                        this.depths.add(new Integer(parents));
                    }
                    break;
                }
                ++i;
            }
            this.directories = dirList;
            this.setSelectedItem(directory);
        }

        public int getDepth(int index) {
            return index >= 0 && index < this.depths.size() ? this.depths.get(index) : 0;
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int index) {
            return this.directories.get(index);
        }
    }

    private class FilePane
    extends JPanel
    implements PropertyChangeListener {
        private static final int LIST_WIDTH = 400;
        private static final int LIST_HEIGHT = 205;
        private static final int COLUMN_FILE = 0;
        private static final int COLUMN_FILESIZE = 1;
        private static final int COLUMN_FILETYPE = 2;
        private static final int COLUMN_FILEDATE = 3;
        private static final int COLUMN_FILEATTR = 4;
        private static final int COLUMN_COLCOUNT = 5;
        private int[] COLUMN_WIDTHS;
        private static final int ASCENDING = 1;
        private static final int DESCENDING = -1;
        private int sortColumn;
        private int sortOrder;
        private int view;
        private JPanel viewPanel;
        private JPanel listPanel;
        private JPanel tablePanel;
        private JPanel treePanel;
        private JList list;
        private JTable table;
        private JTree tree;
        private DetailsTableSortModel detailsTableSortModel;
        private String fileSizeHeaderText;
        private File editFile;
        private JTextField editTextField;
        private boolean newCreatedFile;
        private int editX;
        private int editIndex;
        String[] columnNames;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;

        public FilePane() {
            super(new BorderLayout());
            this.COLUMN_WIDTHS = new int[]{175, 60, 100, 100, 30};
            this.sortColumn = 0;
            this.sortOrder = 1;
            this.view = -1;
            this.editX = 20;
            this.editIndex = -1;
            this.editTextField = new JTextField();
            this.editTextField.addFocusListener(new FocusListener(this){
                final /* synthetic */ FilePane this$1;
                {
                    this.this$1 = filePane;
                }

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    FilePane.access$18(this.this$1);
                }
            });
            this.editTextField.addKeyListener(new KeyListener(this){
                final /* synthetic */ FilePane this$1;
                {
                    this.this$1 = filePane;
                }

                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\u001b') {
                        FilePane.access$17(this.this$1);
                    } else if (e.getKeyChar() == '\n') {
                        FilePane.access$18(this.this$1);
                    }
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            this.listPanel = this.createListPanel();
            this.tablePanel = this.createTablePanel();
            this.treePanel = this.createTreePanel();
            this.viewPanel = new JPanel(new BorderLayout());
            this.add(this.viewPanel);
            SyntheticaFileChooserUI.this.getFileChooser().registerKeyboardAction(SyntheticaFileChooserUI.this, "deleteAction", KeyStroke.getKeyStroke(127, 0), 1);
        }

        private void setView(int viewType) {
            if (this.view == viewType) {
                return;
            }
            this.firePropertyChange("SET_VIEW", this.view, viewType);
            this.view = viewType;
            this.viewPanel.removeAll();
            if (this.view == 0) {
                this.viewPanel.add(this.listPanel);
            } else if (this.view == 1) {
                this.viewPanel.add(this.tablePanel);
            } else if (this.view == 2) {
                this.viewPanel.add(this.treePanel);
            }
            this.setInheritPopupMenu(this.viewPanel, true);
            SyntheticaFileChooserUI.this.actionPerformed(new ActionEvent(this, 0, "orderBy.nameAction"));
            this.revalidate();
            this.viewPanel.repaint();
        }

        private int getView() {
            return this.view;
        }

        private void setInheritPopupMenu(Container container, boolean b) {
            int n = container.getComponentCount();
            if (container instanceof JComponent) {
                ((JComponent)container).setInheritsPopupMenu(b);
            }
            int i = 0;
            while (i < n) {
                this.setInheritPopupMenu((Container)container.getComponent(i), b);
                ++i;
            }
        }

        public JPanel createListPanel() {
            JPanel p = new JPanel(new BorderLayout());
            JFileChooser fileChooser = SyntheticaFileChooserUI.this.getFileChooser();
            this.list = new JList();
            this.list.setCellRenderer(new ListRenderer());
            this.list.setLayoutOrientation(1);
            this.list.setVisibleRowCount(-1);
            this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
                final /* synthetic */ FilePane this$1;
                {
                    this.this$1 = filePane;
                }

                public void valueChanged(ListSelectionEvent evt) {
                    File selectedFile = (File)FilePane.access$11(this.this$1).getSelectedValue();
                    if (selectedFile != null) {
                        TreePath treePath = FilePane.access$19(this.this$1, selectedFile);
                        FilePane.access$0(this.this$1).setSelectionPath(treePath);
                        FilePane.access$0(this.this$1).scrollPathToVisible(treePath);
                    }
                    if (((ListSelectionModel)evt.getSource()).isSelectionEmpty()) {
                        FilePane.access$6(this.this$1, -1);
                    }
                }
            });
            this.list.setModel(new ListModel(this){
                final /* synthetic */ FilePane this$1;
                {
                    this.this$1 = filePane;
                }

                public int getSize() {
                    return FilePane.access$14(this.this$1).getRowCount();
                }

                public Object getElementAt(int index) {
                    return FilePane.access$14(this.this$1).getValueAt(index, 0);
                }

                public void addListDataListener(ListDataListener l) {
                    FilePane.access$25(this.this$1).getModel().addListDataListener(l);
                }

                public void removeListDataListener(ListDataListener l) {
                    FilePane.access$25(this.this$1).getModel().removeListDataListener(l);
                }
            });
            this.list.addMouseListener(new FilePaneMouseListener(this.list));
            this.list.addListSelectionListener(((BasicFileChooserUI)fileChooser.getUI()).createListSelectionListener(fileChooser));
            this.list.setSelectionMode(0);
            this.list.addKeyListener(new FileSelectHandler());
            JScrollPane scrollPane = new JScrollPane(this.list);
            p.setPreferredSize(new Dimension(400, 205));
            p.add((Component)scrollPane, "Center");
            return p;
        }

        public JPanel createTablePanel() {
            JPanel p = new JPanel(new BorderLayout());
            JFileChooser fileChooser = SyntheticaFileChooserUI.this.getFileChooser();
            Locale locale = fileChooser.getLocale();
            String fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", locale);
            this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", locale);
            String fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", locale);
            String fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", locale);
            String fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", locale);
            this.columnNames = new String[]{fileNameHeaderText, this.fileSizeHeaderText, fileTypeHeaderText, fileDateHeaderText, fileAttrHeaderText};
            this.table = new JTable();
            this.detailsTableSortModel = new DetailsTableSortModel(new DetailsTableModel(fileChooser));
            this.table.setSelectionModel(this.list.getSelectionModel());
            this.table.setModel(this.detailsTableSortModel);
            this.table.setComponentOrientation(fileChooser.getComponentOrientation());
            this.table.setShowGrid(false);
            this.table.setIntercellSpacing(new Dimension(0, 0));
            int rowHeight = this.table.getRowHeight();
            Icon icon = null;
            FileSystemView fsv = FileSystemView.getFileSystemView();
            icon = fsv.getSystemIcon(fsv.getHomeDirectory());
            if (rowHeight <= icon.getIconHeight()) {
                this.table.setRowHeight(icon.getIconHeight() + 1);
            }
            this.table.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.table));
            this.table.getTableHeader().addMouseListener(new FilePaneMouseListener(this.table));
            TableColumnModel columnModel = this.table.getColumnModel();
            TableColumn[] columns = new TableColumn[5];
            int i = 0;
            while (i < 5) {
                columns[i] = columnModel.getColumn(i);
                columns[i].setPreferredWidth(this.COLUMN_WIDTHS[i]);
                ++i;
            }
            String osName = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (osName == null || !osName.startsWith("Windows")) {
                columnModel.removeColumn(columns[2]);
                columnModel.removeColumn(columns[4]);
            }
            DetailsTableCellRenderer cellRenderer = new DetailsTableCellRenderer(fileChooser);
            this.table.setDefaultRenderer(File.class, cellRenderer);
            this.table.setDefaultRenderer(Long.class, cellRenderer);
            this.table.setDefaultRenderer(Date.class, cellRenderer);
            this.table.setDefaultRenderer(Object.class, cellRenderer);
            columns[0].setCellEditor(new DefaultCellEditor(this.editTextField));
            this.table.addMouseListener(new FilePaneMouseListener(this.table));
            this.table.addKeyListener(new FileSelectHandler());
            JScrollPane scrollpane = new JScrollPane(this.table);
            scrollpane.setComponentOrientation(fileChooser.getComponentOrientation());
            scrollpane.getViewport().setBackground(this.table.getBackground());
            p.add((Component)scrollpane, "Center");
            return p;
        }

        public JPanel createTreePanel() {
            JPanel p = new JPanel(new BorderLayout());
            JFileChooser fc = SyntheticaFileChooserUI.this.getFileChooser();
            this.tree = new JTree();
            this.tree.setEditable(true);
            FileNode root = new FileNode(fc.getFileSystemView().getRoots()[0]);
            this.tree.setModel(new DefaultTreeModel(root));
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.setCellEditor(new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.tree.getCellRenderer(), new FileCellEditor(new JTextField())));
            this.tree.getCellEditor().addCellEditorListener(new CellEditorListener(this){
                final /* synthetic */ FilePane this$1;
                {
                    this.this$1 = filePane;
                }

                public void editingStopped(ChangeEvent evt) {
                    FileCellEditor editor = (FileCellEditor)evt.getSource();
                    String filename = editor.getDelegateValue();
                    FilePane.access$20(this.this$1).setText(filename);
                    FilePane.access$21(this.this$1, ((FileNode)FilePane.access$0(this.this$1).getSelectionPath().getLastPathComponent()).getFile());
                    File file = FilePane.access$18(this.this$1);
                    TreePath path = FilePane.access$19(SyntheticaFileChooserUI.access$2(FilePane.access$25(this.this$1)), file);
                    FileNode.access$0((FileNode)path.getLastPathComponent());
                    ((DefaultTreeModel)FilePane.access$0(SyntheticaFileChooserUI.access$2(FilePane.access$25(this.this$1))).getModel()).nodeStructureChanged((TreeNode)path.getLastPathComponent());
                }

                public void editingCanceled(ChangeEvent evt) {
                }
            });
            this.tree.setVisibleRowCount(-1);
            this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(this, fc){
                final /* synthetic */ FilePane this$1;
                private final /* synthetic */ JFileChooser val$fc;
                {
                    this.this$1 = filePane;
                    this.val$fc = jFileChooser;
                }

                public void valueChanged(TreeSelectionEvent evt) {
                    File newDir;
                    if (FilePane.access$0(this.this$1).getSelectionPath() == null || FilePane.access$22(this.this$1) != 2) {
                        return;
                    }
                    File file = ((FileNode)FilePane.access$0(this.this$1).getSelectionPath().getLastPathComponent()).getFile();
                    File oldDir = this.val$fc.getCurrentDirectory();
                    File file2 = newDir = file.isDirectory() && FilePane.access$22(this.this$1) == 2 ? file : file.getParentFile();
                    if (!file.equals(this.val$fc.getSelectedFile())) {
                        this.val$fc.setSelectedFile(file);
                        if (!oldDir.equals(this.val$fc.getCurrentDirectory())) {
                            FilePane.access$14(this.this$1).addTableModelListener(new TableModelListener(this, file){
                                final /* synthetic */ 10 this$2;
                                private final /* synthetic */ File val$file;
                                {
                                    this.this$2 = var1_1;
                                    this.val$file = file;
                                }

                                public void tableChanged(TableModelEvent e) {
                                    FilePane.access$14(10.access$0(this.this$2)).removeTableModelListener(this);
                                    SwingUtilities.invokeLater(new Runnable(this, this.val$file){
                                        final /* synthetic */ 11 this$3;
                                        private final /* synthetic */ File val$file;
                                        {
                                            this.this$3 = var1_1;
                                            this.val$file = file;
                                        }

                                        public void run() {
                                            FilePane.access$11(10.access$0(11.access$0(this.this$3))).setSelectedValue(this.val$file, true);
                                        }
                                    });
                                }

                                static /* synthetic */ 10 access$0(11 var0) {
                                    return var0.this$2;
                                }
                            });
                        } else {
                            FilePane.access$11(this.this$1).setSelectedValue(file, true);
                        }
                    }
                    if (!oldDir.equals(newDir)) {
                        this.val$fc.setCurrentDirectory(newDir);
                    }
                }

                static /* synthetic */ FilePane access$0(10 var0) {
                    return var0.this$1;
                }
            });
            this.tree.addMouseListener(new FilePaneMouseListener(this.list));
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.addKeyListener(new FileSelectHandler());
            JScrollPane scrollPane = new JScrollPane(this.tree);
            p.setPreferredSize(new Dimension(400, 205));
            p.add((Component)scrollPane, "Center");
            return p;
        }

        private TreePath getPath(File file) {
            FileNode root = (FileNode)this.tree.getModel().getRoot();
            if (root.getFile().equals(file)) {
                return new TreePath(root);
            }
            TreePath parentPath = this.getPath(FileSystemView.getFileSystemView().getParentDirectory(file));
            FileNode parentNode = (FileNode)parentPath.getLastPathComponent();
            Enumeration enumeration = parentNode.children();
            while (enumeration.hasMoreElements()) {
                FileNode child = (FileNode)enumeration.nextElement();
                if (!child.getFile().equals(file)) continue;
                return parentPath.pathByAddingChild(child);
            }
            return null;
        }

        public boolean isSelectionEmpty() {
            if (this.view == 2) {
                return this.tree.getSelectionModel().isSelectionEmpty();
            }
            return this.list.getSelectionModel().isSelectionEmpty();
        }

        public void clearSelection() {
            this.tree.getSelectionModel().clearSelection();
            this.list.getSelectionModel().clearSelection();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("MultiSelectionEnabledChangedProperty")) {
                if (SyntheticaFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    this.list.setSelectionMode(2);
                    this.table.setSelectionMode(2);
                } else {
                    this.list.setSelectionMode(0);
                    this.table.setSelectionMode(0);
                }
            }
        }

        private void editFileName() {
            if (this.editIndex < 0) {
                return;
            }
            this.editFile = (File)this.detailsTableSortModel.getValueAt(this.editIndex, 0);
            File currentDir = SyntheticaFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (!currentDir.canWrite() || !this.editFile.canWrite() || SyntheticaFileChooserUI.this.readOnly || SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().isFileSystemRoot(this.editFile)) {
                this.cancelEditFileName();
                return;
            }
            Rectangle r = null;
            if (this.view == 0) {
                r = this.list.getCellBounds(this.editIndex, this.editIndex);
                this.list.add(this.editTextField);
            }
            ComponentOrientation orientation = this.list.getComponentOrientation();
            this.editTextField.setComponentOrientation(orientation);
            if (this.view == 0) {
                if (orientation.isLeftToRight()) {
                    this.editTextField.setBounds(this.editX + r.x, r.y, r.width - this.editX, r.height);
                } else {
                    this.editTextField.setBounds(r.x, r.y, r.width - this.editX, r.height);
                }
            } else if (this.view == 1) {
                this.table.editCellAt(this.editIndex, this.table.convertColumnIndexToView(0));
            }
            this.editTextField.setText(this.editFile.getName());
            this.editTextField.requestFocus();
            this.editTextField.selectAll();
            SyntheticaFileChooserUI.this.getFileChooser().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "NO_ACTION");
            this.table.getActionMap().put("NO_ACTION_KEY", new AbstractAction(this){
                final /* synthetic */ FilePane this$1;
                {
                    this.this$1 = filePane;
                }

                public void actionPerformed(ActionEvent e) {
                }
            });
            this.table.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "NO_ACTION_KEY");
        }

        private File applyEditFileName() {
            String newDisplayName;
            if (this.editFile == null) {
                return null;
            }
            JFileChooser fc = SyntheticaFileChooserUI.this.getFileChooser();
            String displayName = fc.getName(this.editFile);
            String fileName = this.editFile.getName();
            String newFileName = newDisplayName = this.editTextField.getText().trim();
            File newFile = this.editFile;
            if (!newDisplayName.equals(displayName)) {
                int l2;
                int l1 = fileName.length();
                if (l1 > (l2 = displayName.length()) && fileName.charAt(l2) == '.') {
                    newFileName = String.valueOf(newDisplayName) + fileName.substring(l2);
                }
                FileSystemView fsv = fc.getFileSystemView();
                newFile = fsv.createFileObject(this.editFile.getParentFile(), newFileName);
                TreePath treePath = this.getPath(this.editFile);
                if (!newFile.exists() && this.editFile.renameTo(newFile)) {
                    File selected = this.editFile.equals(this.list.getSelectedValue()) ? newFile : this.list.getSelectedValue();
                    SyntheticaFileChooserUI.this.getModel().validateFileCache();
                    this.tree.getModel().valueForPathChanged(treePath, newFile);
                    new Thread(this, selected){
                        final /* synthetic */ FilePane this$1;
                        private final /* synthetic */ Object val$selected;
                        {
                            this.this$1 = filePane;
                            this.val$selected = object;
                        }

                        public void run() {
                            try {
                                Thread.sleep(350L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            SwingUtilities.invokeLater(new Runnable(this, this.val$selected){
                                final /* synthetic */ 14 this$2;
                                private final /* synthetic */ Object val$selected;
                                {
                                    this.this$2 = var1_1;
                                    this.val$selected = object;
                                }

                                public void run() {
                                    FilePane.access$11(14.access$0(this.this$2)).setSelectedValue(this.val$selected, true);
                                }
                            });
                        }

                        static /* synthetic */ FilePane access$0(14 var0) {
                            return var0.this$1;
                        }
                    }.start();
                }
            }
            this.cancelEditFileName();
            return newFile;
        }

        private void cancelEditFileName() {
            this.editIndex = -1;
            if (this.editFile == null) {
                return;
            }
            this.editFile = null;
            if (this.view == 0) {
                this.list.remove(this.editTextField);
            } else {
                this.table.editingCanceled(new ChangeEvent(this.table));
            }
            this.repaint();
            SyntheticaFileChooserUI.this.getFileChooser().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelSelection");
            this.table.getActionMap().remove("NO_ACTION_KEY");
        }

        public JPopupMenu getComponentPopupMenu() {
            JPopupMenu popupMenu = SyntheticaFileChooserUI.this.getFileChooser().getComponentPopupMenu();
            if (popupMenu != null) {
                return popupMenu;
            }
            Locale locale = SyntheticaFileChooserUI.this.getFileChooser().getLocale();
            JFileChooser fc = SyntheticaFileChooserUI.this.getFileChooser();
            File currentDir = fc.getCurrentDirectory();
            String approveText = "";
            if (fc.getDialogType() == 0) {
                approveText = UIManager.getString((Object)"FileChooser.contextMenu.open", locale);
            } else if (fc.getDialogType() == 1) {
                approveText = UIManager.getString((Object)"FileChooser.contextMenu.save", locale);
            }
            JMenuItem approveItem = new JMenuItem("<html><b>" + approveText + "</b>");
            approveItem.addActionListener(SyntheticaFileChooserUI.this);
            approveItem.setActionCommand("approveAction");
            if (fc.getSelectedFile() == null && !SyntheticaFileChooserUI.this.isDirectorySelected()) {
                approveItem.setEnabled(false);
            } else if (fc.getDialogType() != 0 && SyntheticaFileChooserUI.this.isDirectorySelected()) {
                approveItem.setEnabled(false);
            }
            JRadioButtonMenuItem listViewItem = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.listView", locale));
            if (this.view == 0) {
                listViewItem.setSelected(true);
            }
            listViewItem.addActionListener(SyntheticaFileChooserUI.this);
            listViewItem.setActionCommand("view.listAction");
            JRadioButtonMenuItem tableViewItem = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.detailsView", locale));
            if (this.view == 1) {
                tableViewItem.setSelected(true);
            }
            tableViewItem.addActionListener(SyntheticaFileChooserUI.this);
            tableViewItem.setActionCommand("view.detailsAction");
            JMenu viewMenu = new JMenu(UIManager.getString((Object)"FileChooser.contextMenu.view", locale));
            viewMenu.add(listViewItem);
            viewMenu.add(tableViewItem);
            JRadioButtonMenuItem orderByNameItem = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.orderByName", locale));
            orderByNameItem.addActionListener(SyntheticaFileChooserUI.this);
            orderByNameItem.setActionCommand("orderBy.nameAction");
            if (this.sortColumn == 0) {
                orderByNameItem.setSelected(true);
            }
            JRadioButtonMenuItem orderBySizeItem = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.orderBySize", locale));
            orderBySizeItem.addActionListener(SyntheticaFileChooserUI.this);
            orderBySizeItem.setActionCommand("orderBy.sizeAction");
            if (this.sortColumn == 1) {
                orderBySizeItem.setSelected(true);
            }
            JRadioButtonMenuItem orderByDateItem = new JRadioButtonMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.orderByDate", locale));
            orderByDateItem.addActionListener(SyntheticaFileChooserUI.this);
            orderByDateItem.setActionCommand("orderBy.dateAction");
            if (this.sortColumn == 3) {
                orderByDateItem.setSelected(true);
            }
            JMenu orderByMenu = new JMenu(UIManager.getString((Object)"FileChooser.contextMenu.orderBy", locale));
            orderByMenu.add(orderByNameItem);
            orderByMenu.add(orderBySizeItem);
            orderByMenu.add(orderByDateItem);
            JMenuItem refreshItem = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.refresh", locale));
            refreshItem.addActionListener(SyntheticaFileChooserUI.this);
            refreshItem.setActionCommand("refreshAction");
            JMenuItem newFolderItem = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.newFolder", locale));
            newFolderItem.addActionListener(SyntheticaFileChooserUI.this);
            newFolderItem.setActionCommand("newFolderAction");
            if (!currentDir.canWrite()) {
                newFolderItem.setEnabled(false);
            }
            JMenuItem cutItem = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.cut", locale));
            cutItem.addActionListener(SyntheticaFileChooserUI.this);
            cutItem.setActionCommand("cutAction");
            if (this.isSelectionEmpty()) {
                cutItem.setEnabled(false);
            }
            JMenuItem copyItem = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.copy", locale));
            copyItem.addActionListener(SyntheticaFileChooserUI.this);
            copyItem.setActionCommand("copyAction");
            if (this.isSelectionEmpty()) {
                copyItem.setEnabled(false);
            }
            JMenuItem pasteItem = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.paste", locale));
            pasteItem.addActionListener(SyntheticaFileChooserUI.this);
            pasteItem.setActionCommand("pasteAction");
            if (SyntheticaFileChooserUI.this.cutBuffer.isEmpty() && SyntheticaFileChooserUI.this.copyBuffer.isEmpty() || !currentDir.canWrite()) {
                pasteItem.setEnabled(false);
            }
            JMenuItem deleteItem = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.delete", locale));
            deleteItem.addActionListener(SyntheticaFileChooserUI.this);
            deleteItem.setActionCommand("deleteAction");
            if (this.isSelectionEmpty() || !currentDir.canWrite()) {
                deleteItem.setEnabled(false);
            }
            JMenuItem renameItem = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.rename", locale));
            renameItem.addActionListener(SyntheticaFileChooserUI.this);
            renameItem.setActionCommand("renameAction");
            if (fc.getSelectedFile() == null && !SyntheticaFileChooserUI.this.isDirectorySelected() || !currentDir.canWrite()) {
                renameItem.setEnabled(false);
            }
            JMenuItem propertiesItem = new JMenuItem(UIManager.getString((Object)"FileChooser.contextMenu.properties", locale));
            propertiesItem.addActionListener(SyntheticaFileChooserUI.this);
            propertiesItem.setActionCommand("propertiesAction");
            if (this.isSelectionEmpty()) {
                propertiesItem.setEnabled(false);
            }
            JPopupMenu contextMenu = new JPopupMenu();
            if (fc.getDialogType() != 2) {
                contextMenu.add(approveItem);
                contextMenu.addSeparator();
            }
            if (!SyntheticaFileChooserUI.this.directoryChooser) {
                contextMenu.add(viewMenu);
                contextMenu.addSeparator();
            }
            if (!SyntheticaFileChooserUI.this.directoryChooser) {
                contextMenu.add(orderByMenu);
            }
            contextMenu.add(refreshItem);
            contextMenu.addSeparator();
            if (!SyntheticaFileChooserUI.this.readOnly) {
                contextMenu.add(newFolderItem);
                contextMenu.addSeparator();
                contextMenu.add(cutItem);
                contextMenu.add(copyItem);
                contextMenu.add(pasteItem);
                contextMenu.addSeparator();
                contextMenu.add(deleteItem);
                contextMenu.add(renameItem);
                contextMenu.addSeparator();
            }
            contextMenu.add(propertiesItem);
            return contextMenu;
        }

        private ImageIcon createBrightIcon(Icon icon) {
            BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(null, bi.getGraphics(), 0, 0);
            ImageIcon ii = new ImageIcon(bi);
            ii = new ImageIcon(this.createImage(new FilteredImageSource(bi.getSource(), new RGBImageFilter(this){
                final /* synthetic */ FilePane this$1;
                {
                    this.this$1 = filePane;
                }

                public int filterRGB(int x, int y, int rgb) {
                    return 0x60FFFFFF & rgb;
                }
            })));
            bi.getGraphics().dispose();
            return ii;
        }

        static /* synthetic */ File access$18(FilePane filePane) {
            return filePane.applyEditFileName();
        }

        static /* synthetic */ JTextField access$20(FilePane filePane) {
            return filePane.editTextField;
        }

        static /* synthetic */ void access$21(FilePane filePane, File file) {
            filePane.editFile = file;
        }

        private class FileCellEditor
        extends DefaultCellEditor {
            public FileCellEditor(JTextField textField) {
                super(textField);
            }

            public Object getCellEditorValue() {
                return ((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile();
            }

            public String getDelegateValue() {
                return (String)this.delegate.getCellEditorValue();
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private FileSystemView fsv = FileSystemView.getFileSystemView();

            ListRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                File file = (File)value;
                String fileName = SyntheticaFileChooserUI.this.getFileChooser().getName(file);
                this.setText(fileName);
                Icon icon = null;
                icon = SyntheticaFileChooserUI.this.useSystemFileIcons ? this.fsv.getSystemIcon(file) : SyntheticaFileChooserUI.this.getFileChooser().getIcon(file);
                this.setIcon(icon);
                if (SyntheticaFileChooserUI.this.cutBuffer.contains(file)) {
                    this.setIcon(FilePane.this.createBrightIcon(icon));
                }
                return this;
            }
        }

        private class DetailsTableCellRenderer
        extends DefaultTableCellRenderer {
            private DateFormat dateFormat;

            DetailsTableCellRenderer(JFileChooser fc) {
                this.dateFormat = DateFormat.getDateTimeInstance(3, 3, fc.getLocale());
            }

            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
            }

            public Insets getInsets(Insets i) {
                i = super.getInsets(i);
                i.left += 4;
                i.right += 4;
                return i;
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (column == table.convertColumnIndexToView(FilePane.this.sortColumn)) {
                    this.setBackground(UIManager.getColor("Synthetica.fileChooser.tableView.sortColumnColor"));
                } else {
                    this.setBackground(Color.WHITE);
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }

            public void setValue(Object value) {
                this.setIcon(null);
                this.setHorizontalAlignment(2);
                if (value instanceof File) {
                    File file = (File)value;
                    String fileName = SyntheticaFileChooserUI.this.getFileChooser().getName(file);
                    this.setText(fileName);
                    Icon icon = null;
                    if (SyntheticaFileChooserUI.this.useSystemFileIcons) {
                        FileSystemView fsv = FileSystemView.getFileSystemView();
                        icon = fsv.getSystemIcon(file);
                    } else {
                        icon = SyntheticaFileChooserUI.this.getFileChooser().getIcon(file);
                    }
                    this.setIcon(icon);
                    if (SyntheticaFileChooserUI.this.cutBuffer.contains(value)) {
                        this.setIcon(FilePane.this.createBrightIcon(icon));
                    }
                } else if (value instanceof Date) {
                    this.setText(value == null ? "" : this.dateFormat.format((Date)value));
                } else if (value instanceof Long) {
                    long size = (Long)value;
                    if (size == -1L) {
                        this.setText("");
                        return;
                    }
                    String len = "0";
                    if ((size /= 1024L) < 1024L) {
                        if (size == 0L) {
                            size = 1L;
                        }
                        NumberFormat nf = NumberFormat.getInstance(SyntheticaFileChooserUI.this.getFileChooser().getLocale());
                        len = String.valueOf(nf.format(size)) + " KB";
                    } else {
                        NumberFormat nf = NumberFormat.getInstance(SyntheticaFileChooserUI.this.getFileChooser().getLocale());
                        len = String.valueOf(nf.format(size /= 1024L)) + " MB";
                    }
                    this.setHorizontalAlignment(4);
                    this.setText(len);
                } else {
                    super.setValue(value);
                }
            }
        }

        private class TreeRenderer
        extends DefaultTreeCellRenderer {
            private FileSystemView fsv = FileSystemView.getFileSystemView();

            TreeRenderer() {
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                File file = ((FileNode)value).getFile();
                this.setText(this.fsv.getSystemDisplayName(file));
                this.setIcon(this.getIcon(file));
                return this;
            }

            public Icon getLeafIcon() {
                if (FilePane.this.tree.getSelectionPath() == null) {
                    return super.getLeafIcon();
                }
                return this.getIcon(((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile());
            }

            public Icon getOpenIcon() {
                if (FilePane.this.tree.getSelectionPath() == null) {
                    return super.getOpenIcon();
                }
                return this.getIcon(((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile());
            }

            public Icon getClosedIcon() {
                if (FilePane.this.tree.getSelectionPath() == null) {
                    return super.getClosedIcon();
                }
                return this.getIcon(((FileNode)FilePane.this.tree.getSelectionPath().getLastPathComponent()).getFile());
            }

            private Icon getIcon(File file) {
                Icon icon = null;
                icon = SyntheticaFileChooserUI.this.useSystemFileIcons ? this.fsv.getSystemIcon(file) : SyntheticaFileChooserUI.this.getFileChooser().getIcon(file);
                if (SyntheticaFileChooserUI.this.cutBuffer.contains(file)) {
                    icon = FilePane.this.createBrightIcon(icon);
                }
                return icon;
            }
        }

        public class TableHeaderRenderer
        implements TableCellRenderer {
            private final String ARROW_UP = UIManager.getString("Synthetica.fileChooser.tableView.arrowUp");
            private final String ARROW_DOWN = UIManager.getString("Synthetica.fileChooser.tableView.arrowDown");
            private final Color gridColor = UIManager.getColor("Synthetica.tableHeader.gridColor");
            TableCellRenderer renderer;
            static /* synthetic */ Class class$0;

            public TableHeaderRenderer(JTable table) {
                this.renderer = table.getTableHeader().getDefaultRenderer();
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JPanel panel = new JPanel(new BorderLayout());
                JLabel textLabel = new JLabel();
                textLabel.setText(value == null ? "" : value.toString());
                textLabel.setBorder(new EmptyBorder(1, 4, 1, 4));
                textLabel.setFont(table.getTableHeader().getFont());
                textLabel.setForeground(table.getTableHeader().getForeground());
                if (FilePane.this.fileSizeHeaderText.equals(value)) {
                    textLabel.setHorizontalAlignment(4);
                }
                JPanel iconPanel = new JPanel(new BorderLayout());
                iconPanel.setOpaque(false);
                JLabel iconLabel = new JLabel();
                String arrowPath = this.ARROW_UP;
                if (FilePane.this.sortOrder == -1) {
                    arrowPath = this.ARROW_DOWN;
                }
                ImageIcon icon = new ImageIcon(SyntheticaLookAndFeel.class.getResource(arrowPath));
                iconLabel.setIcon(icon);
                if (column == table.convertColumnIndexToView(FilePane.this.sortColumn)) {
                    iconPanel.add(iconLabel);
                }
                JPanel separator = new JPanel();
                separator.setBackground(this.gridColor);
                separator.setPreferredSize(new Dimension(1, separator.getPreferredSize().height));
                if (column != table.getColumnCount() - 1) {
                    iconPanel.add((Component)separator, "East");
                }
                panel.add(textLabel);
                panel.add((Component)iconPanel, "East");
                panel.setOpaque(false);
                if (!(UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel)) {
                    panel.setBorder(new MatteBorder(0, 0, 1, 0, this.gridColor));
                }
                return panel;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DetailsTableSortModel
        extends AbstractTableModel
        implements TableModelListener {
            TableModel model;
            Row[] rows;

            DetailsTableSortModel(TableModel model) {
                this.model = model;
                model.addTableModelListener(this);
                this.reinit();
            }

            public void reinit() {
                this.rows = new Row[this.model.getRowCount()];
                int i = 0;
                while (i < this.rows.length) {
                    this.rows[i] = new Row();
                    this.rows[i].index = i;
                    ++i;
                }
                this.sort();
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                this.reinit();
                File file = ((DetailsTableModel)this.model).newAddedEntry;
                if (file != null && FilePane.this.newCreatedFile) {
                    int i = 0;
                    while (i < this.getRowCount()) {
                        if (file.equals(this.getValueAt(i, 0))) {
                            SyntheticaFileChooserUI.this.filePane.editIndex = i;
                            SyntheticaFileChooserUI.this.filePane.editFileName();
                            break;
                        }
                        ++i;
                    }
                    ((DetailsTableModel)this.model).newAddedEntry = null;
                    FilePane.this.newCreatedFile = false;
                }
            }

            public void sort() {
                Cursor cursor = FilePane.this.table.getTableHeader().getCursor();
                FilePane.this.table.getTableHeader().setCursor(null);
                SyntheticaFileChooserUI.this.getFileChooser().setCursor(Cursor.getPredefinedCursor(3));
                Arrays.sort(this.rows);
                this.fireTableDataChanged();
                SyntheticaFileChooserUI.this.getFileChooser().setCursor(Cursor.getPredefinedCursor(0));
                FilePane.this.table.getTableHeader().setCursor(cursor);
            }

            @Override
            public int getRowCount() {
                return this.model.getRowCount();
            }

            @Override
            public int getColumnCount() {
                return this.model.getColumnCount();
            }

            @Override
            public String getColumnName(int column) {
                return this.model.getColumnName(column);
            }

            @Override
            public Class<?> getColumnClass(int column) {
                return this.model.getColumnClass(column);
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (this.rows.length == 0) {
                    return null;
                }
                return this.model.getValueAt(this.rows[row].index, col);
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                this.model.setValueAt(value, row, col);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return this.model.isCellEditable(row, column);
            }

            private class Row
            implements Comparable {
                public int index;

                Row() {
                }

                public int compareTo(Object obj) {
                    File f1 = (File)DetailsTableSortModel.this.model.getValueAt(this.index, 0);
                    File f2 = (File)DetailsTableSortModel.this.model.getValueAt(((Row)obj).index, 0);
                    if (f1 == null || f2 == null) {
                        return 0;
                    }
                    if (f1.isDirectory() && f2.isFile()) {
                        return -1 * FilePane.this.sortOrder;
                    }
                    if (f1.isFile() && f2.isDirectory()) {
                        return 1 * FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 0) {
                        int i = f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
                        return i * FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 3) {
                        long i = f1.lastModified() - f2.lastModified();
                        return (i < 0L ? 1 : (i > 0L ? -1 : 0)) * FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 1) {
                        long i = f1.length() - f2.length();
                        return (i < 0L ? 1 : (i > 0L ? -1 : 0)) * FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 2) {
                        String s1 = SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(f1);
                        String s2 = SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(f2);
                        return s1.compareTo(s2) * FilePane.this.sortOrder;
                    }
                    if (FilePane.this.sortColumn == 4) {
                        String attr1 = "";
                        try {
                            if (!f1.canWrite()) {
                                attr1 = String.valueOf(attr1) + "R";
                            }
                        }
                        catch (AccessControlException s2) {
                            // empty catch block
                        }
                        if (f1.isHidden()) {
                            attr1 = String.valueOf(attr1) + "H";
                        }
                        String attr2 = "";
                        try {
                            if (!f2.canWrite()) {
                                attr2 = String.valueOf(attr2) + "R";
                            }
                        }
                        catch (AccessControlException accessControlException) {
                            // empty catch block
                        }
                        if (f2.isHidden()) {
                            attr2 = String.valueOf(attr2) + "H";
                        }
                        return attr1.compareTo(attr2) * FilePane.this.sortOrder;
                    }
                    return f1.toString().compareTo(f2.toString()) * FilePane.this.sortOrder;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DetailsTableModel
        extends AbstractTableModel {
            JFileChooser fileChooser;
            File newAddedEntry;
            ListModel listModel;
            static /* synthetic */ Class class$0;
            static /* synthetic */ Class class$1;
            static /* synthetic */ Class class$2;

            DetailsTableModel(JFileChooser fc) {
                this.fileChooser = fc;
                this.listModel = SyntheticaFileChooserUI.this.getModel();
                SyntheticaFileChooserUI.this.getModel().addListDataListener(new ListDataListener(this){
                    final /* synthetic */ DetailsTableModel this$2;
                    {
                        this.this$2 = detailsTableModel;
                    }

                    public void contentsChanged(ListDataEvent e) {
                        this.this$2.fireTableDataChanged();
                    }

                    public void intervalAdded(ListDataEvent e) {
                        this.this$2.newAddedEntry = (File)this.this$2.listModel.getElementAt(e.getIndex0());
                        this.this$2.fireTableDataChanged();
                    }

                    public void intervalRemoved(ListDataEvent e) {
                        this.this$2.fireTableDataChanged();
                    }
                });
            }

            @Override
            public int getRowCount() {
                return this.listModel.getSize();
            }

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public String getColumnName(int column) {
                return FilePane.this.columnNames[column];
            }

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return File.class;
                    }
                    case 3: {
                        return Date.class;
                    }
                    case 1: {
                        return Long.class;
                    }
                }
                return super.getColumnClass(column);
            }

            @Override
            public Object getValueAt(int row, int col) {
                File f = (File)this.listModel.getElementAt(row);
                switch (col) {
                    case 0: {
                        return f;
                    }
                    case 1: {
                        if (!f.exists() || f.isDirectory()) {
                            return new Long(-1L);
                        }
                        return new Long(f.length());
                    }
                    case 2: {
                        if (!f.exists()) {
                            return null;
                        }
                        return this.fileChooser.getFileSystemView().getSystemTypeDescription(f);
                    }
                    case 3: {
                        if (!f.exists() || this.fileChooser.getFileSystemView().isFileSystemRoot(f)) {
                            return null;
                        }
                        long time = f.lastModified();
                        return time == 0L ? null : new Date(time);
                    }
                    case 4: {
                        if (!f.exists() || this.fileChooser.getFileSystemView().isFileSystemRoot(f)) {
                            return null;
                        }
                        String attributes = "";
                        try {
                            if (!f.canWrite()) {
                                attributes = String.valueOf(attributes) + "R";
                            }
                        }
                        catch (AccessControlException accessControlException) {
                            // empty catch block
                        }
                        if (f.isHidden()) {
                            attributes = String.valueOf(attributes) + "H";
                        }
                        return attributes;
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0 && FilePane.this.editFile != null;
            }
        }

        private class FileNode
        extends DefaultMutableTreeNode {
            boolean refresh;
            boolean updateAllowed;

            FileNode(File file) {
                super(file);
                this.refresh = false;
                this.updateAllowed = true;
            }

            public File getFile() {
                return (File)this.userObject;
            }

            public int getChildCount() {
                this.updateChildren();
                return super.getChildCount();
            }

            public Enumeration children() {
                this.updateChildren();
                return super.children();
            }

            public boolean isLeaf() {
                return !((File)this.userObject).isDirectory();
            }

            private void prepareForUpdateChildren() {
                this.refresh = true;
            }

            private void updateChildren() {
                if (this.refresh) {
                    this.refresh = false;
                    this.removeAllChildren();
                    this.children = null;
                }
                if (this.children == null && this.updateAllowed) {
                    File[] files = SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().getFiles(this.getFile(), true);
                    Arrays.sort(files, new Comparator<Object>(this){
                        final /* synthetic */ FileNode this$2;
                        {
                            this.this$2 = fileNode;
                        }

                        public int compare(Object o1, Object o2) {
                            File f1 = (File)o1;
                            File f2 = (File)o2;
                            if (f1 == null || f2 == null) {
                                return 0;
                            }
                            if (f1.isDirectory() && f2.isFile()) {
                                return -1 * FilePane.access$4(FileNode.access$1(this.this$2));
                            }
                            if (f1.isFile() && f2.isDirectory()) {
                                return 1 * FilePane.access$4(FileNode.access$1(this.this$2));
                            }
                            if (FilePane.access$2(FileNode.access$1(this.this$2)) == 0) {
                                int i = f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
                                return i * FilePane.access$4(FileNode.access$1(this.this$2));
                            }
                            if (FilePane.access$2(FileNode.access$1(this.this$2)) == 3) {
                                long i = f1.lastModified() - f2.lastModified();
                                return (i < 0L ? 1 : (i > 0L ? -1 : 0)) * FilePane.access$4(FileNode.access$1(this.this$2));
                            }
                            if (FilePane.access$2(FileNode.access$1(this.this$2)) == 1) {
                                long i = f1.length() - f2.length();
                                return (i < 0L ? 1 : (i > 0L ? -1 : 0)) * FilePane.access$4(FileNode.access$1(this.this$2));
                            }
                            return f1.compareTo(f2);
                        }
                    });
                    boolean dirsOnly = SyntheticaFileChooserUI.this.getFileChooser().getFileSelectionMode() == 1;
                    File[] fileArray = files;
                    int n = 0;
                    int n2 = fileArray.length;
                    while (n < n2) {
                        File f = fileArray[n];
                        if (!dirsOnly || dirsOnly && f.isDirectory()) {
                            this.insert(new FileNode(f), this.children == null ? 0 : this.children.size());
                        }
                        ++n;
                    }
                }
            }

            public String toString() {
                return SyntheticaFileChooserUI.this.getFileChooser().getFileSystemView().getSystemDisplayName(this.getFile());
            }

            static /* synthetic */ FilePane access$1(FileNode fileNode) {
                return fileNode.FilePane.this;
            }
        }

        private class FilePaneMouseListener
        implements MouseListener {
            private MouseListener doubleClickListener;
            private boolean singleClick;
            private final int EDIT_DELAY = 250;

            public FilePaneMouseListener(JList list) {
                this.doubleClickListener = SyntheticaFileChooserUI.this.createDoubleClickListener(SyntheticaFileChooserUI.this.getFileChooser(), list);
            }

            public FilePaneMouseListener(JTable table) {
                this.doubleClickListener = SyntheticaFileChooserUI.this.createDoubleClickListener(SyntheticaFileChooserUI.this.getFileChooser(), FilePane.this.list);
            }

            public void mouseClicked(MouseEvent evt) {
                int index;
                JComponent source = (JComponent)evt.getSource();
                if (source instanceof JList) {
                    index = this.loc2IndexFileList((JList)source, evt.getPoint());
                } else if (source instanceof JTable) {
                    index = ((JTable)source).rowAtPoint(evt.getPoint());
                } else {
                    if (source instanceof JTableHeader) {
                        int column = ((JTableHeader)source).columnAtPoint(evt.getPoint());
                        column = FilePane.this.table.convertColumnIndexToModel(column);
                        if (column == FilePane.this.sortColumn) {
                            if (FilePane.this.sortOrder == 1) {
                                FilePane.this.sortOrder = -1;
                            } else {
                                FilePane.this.sortOrder = 1;
                            }
                        } else {
                            FilePane.this.sortOrder = 1;
                            FilePane.this.sortColumn = column;
                        }
                        FilePane.this.detailsTableSortModel.sort();
                        FilePane.this.viewPanel.repaint();
                        return;
                    }
                    return;
                }
                if (index >= 0 && FilePane.this.list.getSelectionModel().isSelectedIndex(index) && source instanceof JTable) {
                    Rectangle rect = FilePane.this.list.getCellBounds(index, index);
                    evt = new MouseEvent(FilePane.this.list, evt.getID(), evt.getWhen(), evt.getModifiers(), rect.x, rect.y, evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
                }
                if (index >= 0 && SwingUtilities.isLeftMouseButton(evt)) {
                    if (evt.getClickCount() == 1) {
                        this.singleClick = true;
                        if (FilePane.this.editIndex == index && FilePane.this.editFile == null) {
                            new Thread(this){
                                final /* synthetic */ FilePaneMouseListener this$2;
                                {
                                    this.this$2 = filePaneMouseListener;
                                }

                                public void run() {
                                    try {
                                        Thread.sleep(250L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (FilePaneMouseListener.access$0(this.this$2)) {
                                        SwingUtilities.invokeLater(new Runnable(this){
                                            final /* synthetic */ 3 this$3;
                                            {
                                                this.this$3 = var1_1;
                                            }

                                            public void run() {
                                                FilePane.access$7(FilePaneMouseListener.access$1(3.access$0(this.this$3)));
                                            }
                                        });
                                    }
                                }

                                static /* synthetic */ FilePaneMouseListener access$0(3 var0) {
                                    return var0.this$2;
                                }
                            }.start();
                        } else if (FilePane.this.editFile == null) {
                            FilePane.this.editIndex = index;
                        }
                    } else if (evt.getClickCount() != 1) {
                        this.singleClick = false;
                        FilePane.this.cancelEditFileName();
                    }
                }
                this.doubleClickListener.mouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                this.doubleClickListener.mouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                if (evt.getSource() instanceof JList) {
                    this.doubleClickListener.mouseExited(evt);
                }
            }

            public void mousePressed(MouseEvent evt) {
                if (evt.getSource() instanceof JList) {
                    this.doubleClickListener.mousePressed(evt);
                }
            }

            public void mouseReleased(MouseEvent evt) {
                if (evt.getSource() instanceof JList) {
                    this.doubleClickListener.mouseReleased(evt);
                }
            }

            private int loc2IndexFileList(JList list, Point point) {
                int index = list.locationToIndex(point);
                if (index != -1 && !this.pointIsInActualBounds(list, index, point)) {
                    index = -1;
                }
                return index;
            }

            private boolean pointIsInActualBounds(JList list, int index, Point point) {
                ListCellRenderer renderer = list.getCellRenderer();
                ListModel dataModel = list.getModel();
                Object value = dataModel.getElementAt(index);
                Component item = renderer.getListCellRendererComponent(list, value, index, false, false);
                Dimension itemSize = item.getPreferredSize();
                Rectangle cellBounds = list.getCellBounds(index, index);
                if (!item.getComponentOrientation().isLeftToRight()) {
                    cellBounds.x += cellBounds.width - itemSize.width;
                }
                cellBounds.width = itemSize.width;
                cellBounds.height = itemSize.height;
                return cellBounds.contains(point);
            }

            static /* synthetic */ boolean access$0(FilePaneMouseListener filePaneMouseListener) {
                return filePaneMouseListener.singleClick;
            }

            static /* synthetic */ FilePane access$1(FilePaneMouseListener filePaneMouseListener) {
                return filePaneMouseListener.FilePane.this;
            }
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = SyntheticaFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("ChoosableFileFilterChangedProperty")) {
                this.filters = (FileFilter[])evt.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (name.equals("fileFilterChanged")) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                SyntheticaFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                SyntheticaFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return SyntheticaFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            return this.filters.length;
        }

        public Object getElementAt(int index) {
            if (this.filters.length > 0) {
                return this.filters[index];
            }
            return null;
        }
    }

    protected class FileSelectHandler
    implements KeyListener {
        protected FileSelectHandler() {
        }

        public void keyTyped(KeyEvent e) {
            if (e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
                return;
            }
            char c = e.getKeyChar();
            JComponent src = (JComponent)e.getSource();
            int startIndex = -1;
            if (src instanceof JList) {
                startIndex = ((JList)src).getLeadSelectionIndex() + 1;
            } else if (src instanceof JTable) {
                startIndex = ((JTable)src).getSelectedRow() + 1;
            }
            int index = this.getNextFileIndex(src, c, startIndex, Position.Bias.Forward);
            if (index < 0) {
                index = this.getNextFileIndex(src, c, 0, Position.Bias.Forward);
            }
            if (index >= 0) {
                if (src instanceof JList) {
                    ((JList)src).setSelectedIndex(index);
                    ((JList)src).ensureIndexIsVisible(index);
                } else if (src instanceof JTable) {
                    ((JTable)src).setRowSelectionInterval(index, index);
                    ((JTable)src).scrollRectToVisible(((JTable)src).getCellRect(index, 0, true));
                }
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        private int getNextFileIndex(JComponent c, char prefix, int startIndex, Position.Bias bias) {
            int maxIndex = -1;
            if (c instanceof JList) {
                maxIndex = ((JList)c).getModel().getSize();
            } else if (c instanceof JTable) {
                maxIndex = ((JTable)c).getModel().getRowCount();
            }
            if (startIndex < 0 || startIndex >= maxIndex) {
                return -1;
            }
            boolean backwards = bias == Position.Bias.Backward;
            int i = startIndex;
            while (!(backwards ? i < 0 : i >= maxIndex)) {
                Object model;
                String filename = null;
                if (c instanceof JList) {
                    model = ((JList)c).getModel();
                    filename = SyntheticaFileChooserUI.this.getFileChooser().getName((File)model.getElementAt(i));
                } else if (c instanceof JTable) {
                    model = ((JTable)c).getModel();
                    filename = SyntheticaFileChooserUI.this.getFileChooser().getName((File)model.getValueAt(i, 0));
                }
                if (filename.regionMatches(true, 0, String.valueOf(prefix), 0, 1)) {
                    return i;
                }
                i += backwards ? -1 : 1;
            }
            return -1;
        }
    }
}

