/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.lang.reflect.Field;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class ArrowButtonPainter
extends SynthPainter {
    private static SynthPainter instance = new ArrowButtonPainter();

    private ArrowButtonPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintArrowButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JButton arrowButton = (JButton)sc.getComponent();
        String name = arrowButton.getName();
        Container parent = arrowButton.getParent();
        String imagePath = "Synthetica.arrowButton";
        if (name != null && name.startsWith("SplitPaneDivider.")) {
            return;
        }
        if (w <= 12 || h <= 12) {
            Insets sInsets;
            imagePath = String.valueOf(imagePath) + ".8x8.background";
            if ((sc.getComponentState() & 4) > 0) {
                imagePath = String.valueOf(imagePath) + ".pressed";
            } else if ((sc.getComponentState() & 8) > 0) {
                imagePath = String.valueOf(imagePath) + ".disabled";
            } else if ((sc.getComponentState() & 2) > 0) {
                imagePath = String.valueOf(imagePath) + ".hover";
            }
            imagePath = SyntheticaLookAndFeel.getString(imagePath, arrowButton);
            Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.arrowButton.8x8.background.insets", arrowButton);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
            return;
        }
        if (parent instanceof JComboBox || "ComboBox.arrowButton".equals(name)) {
            Insets sInsets;
            imagePath = String.valueOf(imagePath) + ".x.background";
            if ((sc.getComponentState() & 4) > 0) {
                imagePath = String.valueOf(imagePath) + ".pressed";
            } else if ((sc.getComponentState() & 8) > 0) {
                imagePath = String.valueOf(imagePath) + ".disabled";
            } else if ((sc.getComponentState() & 2) > 0) {
                imagePath = String.valueOf(imagePath) + ".hover";
            }
            imagePath = SyntheticaLookAndFeel.getString(imagePath, arrowButton);
            Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.arrowButton.x.background.insets", arrowButton);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
            return;
        }
        int direction = 0;
        try {
            Class<?> clazz = Class.forName("javax.swing.plaf.synth.SynthArrowButton");
            Field field = clazz.getDeclaredField("direction");
            field.setAccessible(true);
            direction = (int)field.getLong(arrowButton);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Insets sInsets = null;
        if (direction == 3 || direction == 7) {
            imagePath = String.valueOf(imagePath) + ".x";
            sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.arrowButton.x.background.insets", arrowButton);
        } else {
            imagePath = String.valueOf(imagePath) + ".y";
            sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.arrowButton.y.background.insets", arrowButton);
        }
        imagePath = String.valueOf(imagePath) + ".background";
        if ((sc.getComponentState() & 4) > 0) {
            imagePath = String.valueOf(imagePath) + ".pressed";
        } else if ((sc.getComponentState() & 8) > 0) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        } else if ((sc.getComponentState() & 2) > 0) {
            imagePath = String.valueOf(imagePath) + ".hover";
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, arrowButton);
        Insets dInsets = sInsets;
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
    }

    public void paintArrowButtonForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int direction) {
        String imagePath = "Synthetica.arrow";
        String size = "";
        if (w < 16 || h < 16) {
            size = ".8x8";
            x += (w - 8) / 2;
            y += (h - 8 + 1) / 2;
            w = 8;
            h = 8;
        } else if (w != 16 || h != 16) {
            x += (w - 16) / 2;
            y += (h - 16 + 1) / 2;
            w = 16;
            h = 16;
        }
        imagePath = String.valueOf(imagePath) + size;
        if (direction == 1) {
            imagePath = String.valueOf(imagePath) + ".up";
        } else if (direction == 5) {
            imagePath = String.valueOf(imagePath) + ".down";
        } else if (direction == 7) {
            imagePath = String.valueOf(imagePath) + ".left";
        } else if (direction == 3) {
            imagePath = String.valueOf(imagePath) + ".right";
        }
        Insets sInsets = new Insets(0, 0, 0, 0);
        Insets dInsets = new Insets(0, 0, 0, 0);
        if ((sc.getComponentState() & 4) > 0) {
            imagePath = String.valueOf(imagePath) + ".pressed";
        } else if ((sc.getComponentState() & 2) > 0) {
            imagePath = String.valueOf(imagePath) + ".hover";
        } else if ((sc.getComponentState() & 8) > 0) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, sc.getComponent());
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
    }
}

