/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComboBox;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class ComboBoxPainter
extends SynthPainter {
    private static SynthPainter instance = new ComboBoxPainter();

    private ComboBoxPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintComboBoxBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        JComboBox cb = (JComboBox)sc.getComponent();
        Color background = cb.getBackground();
        String imagePath = "Synthetica.comboBox.border";
        if (!cb.isEnabled()) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        }
        if (SyntheticaLookAndFeel.isOpaque(cb) && !cb.isEditable() && SyntheticaLookAndFeel.getString(String.valueOf(imagePath) + ".locked", cb) != null && (background == null || background instanceof ColorUIResource)) {
            if (cb.hasFocus()) {
                FocusPainter.paintFocus("focus.comboBox", sc, g, x, y, w, h);
            }
            return;
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, cb);
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.comboBox.border.insets", cb);
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.drawBorder();
        Component c = null;
        if (cb.isEditable()) {
            c = cb.getEditor().getEditorComponent();
        }
        if (cb.hasFocus() || c != null && c.hasFocus()) {
            FocusPainter.paintFocus("focus.comboBox", sc, g, x, y, w, h);
        }
    }

    public void paintComboBoxBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComboBox cb = (JComboBox)sc.getComponent();
        Color background = cb.getBackground();
        if (background instanceof ColorUIResource) {
            background = !cb.isEnabled() ? SyntheticaLookAndFeel.getColor("Synthetica.comboBox.disabledColor", cb) : (cb.isEditable() ? sc.getStyle().getColor(sc, ColorType.BACKGROUND) : SyntheticaLookAndFeel.getColor("Synthetica.comboBox.lockedColor", cb));
        }
        SyntheticaLookAndFeel.setChildrenOpaque(cb, false);
        if (SyntheticaLookAndFeel.isOpaque(cb)) {
            String imagePath = "Synthetica.comboBox.border.locked";
            if (cb.isEnabled() && !cb.isEditable() && SyntheticaLookAndFeel.getString(imagePath, cb) != null && (background == null || background instanceof ColorUIResource)) {
                Insets sInsets;
                imagePath = SyntheticaLookAndFeel.getString(imagePath, cb);
                Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.comboBox.border.insets", cb);
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.draw();
                return;
            }
            String key = "Synthetica.comboBox.border";
            if (!cb.isEnabled()) {
                key = String.valueOf(key) + ".disabled";
            }
            key = String.valueOf(key) + ".opaqueBackground";
            if ((background == null || background instanceof ColorUIResource) && SyntheticaLookAndFeel.getBoolean(key, cb)) {
                Insets sInsets;
                imagePath = "Synthetica.comboBox.border";
                if (!cb.isEnabled()) {
                    imagePath = String.valueOf(imagePath) + ".disabled";
                }
                imagePath = SyntheticaLookAndFeel.getString(imagePath, cb);
                Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.comboBox.border.insets", cb);
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.drawCenter();
                return;
            }
            int arcWidth = SyntheticaLookAndFeel.get("Synthetica.comboBox.border.arcWidth", cb) == null ? 8 : SyntheticaLookAndFeel.getInt("Synthetica.comboBox.border.arcWidth", cb);
            int arcHeight = SyntheticaLookAndFeel.get("Synthetica.comboBox.border.arcHeight", cb) == null ? 8 : SyntheticaLookAndFeel.getInt("Synthetica.comboBox.border.arcHeight", cb);
            Graphics2D g2 = (Graphics2D)g;
            Color color = g2.getColor();
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(background);
            g2.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
            g2.setRenderingHints(rh);
            g2.setColor(color);
            if (cb.isEnabled() && !cb.isEditable() && (sc.getComponentState() & 0x100) > 0 && SyntheticaLookAndFeel.getString(imagePath, cb) != null) {
                Insets sInsets;
                imagePath = SyntheticaLookAndFeel.getString(imagePath, cb);
                Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.comboBox.border.insets", cb);
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.drawBorder();
            }
        }
    }
}

