/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.StyleFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;

class FocusPainter {
    FocusPainter() {
    }

    static void paintFocus(String propertyKey, SynthContext sc, Graphics g, int x, int y, int w, int h) {
        FocusPainter.paintFocus(propertyKey, sc, null, g, x, y, w, h);
    }

    static void paintFocus(String propertyKey, SynthContext sc, String id, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        int state = sc.getComponentState();
        FocusPainter.paintFocus(propertyKey, c, state, id, g, x, y, w, h);
    }

    static void paintFocus(String propertyKey, JComponent c, int state, String id, Graphics g, int x, int y, int w, int h) {
        String name = c.getName();
        String imagePath = SyntheticaLookAndFeel.getString(propertyKey, null, name, true);
        Insets sInsets = SyntheticaLookAndFeel.getInsets(propertyKey, "insets", name, true);
        if (imagePath != null && imagePath.length() > 0) {
            int cycles = SyntheticaLookAndFeel.getInt(propertyKey, "animation.cycles", name, true, -1);
            int delay = SyntheticaLookAndFeel.getInt(propertyKey, "animation.delay", name, true, 60);
            int type = SyntheticaLookAndFeel.getInt(propertyKey, "animation.type", name, true, 3);
            Insets dInsets = sInsets;
            ImagePainter imagePainter = new ImagePainter(c, id, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 1, 1);
            imagePainter.draw();
        }
    }

    static void installFocusListener(Component c) {
        if (!c.isEnabled()) {
            return;
        }
        FocusListener[] focusListenerArray = c.getFocusListeners();
        int n = 0;
        int n2 = focusListenerArray.length;
        while (n < n2) {
            FocusListener l = focusListenerArray[n];
            if (l instanceof RepaintFocusListener) {
                return;
            }
            ++n;
        }
        StyleFactory factory = (StyleFactory)SynthLookAndFeel.getStyleFactory();
        factory.getComponentPropertyStore().storeComponentProperty(c, "FOCUS_LISTENERS");
        c.addFocusListener(new RepaintFocusListener());
    }

    private static class RepaintFocusListener
    implements FocusListener {
        RepaintFocusListener() {
        }

        public void focusGained(FocusEvent evt) {
            this.repaintComponent(evt.getComponent());
        }

        public void focusLost(FocusEvent evt) {
            this.repaintComponent(evt.getComponent());
        }

        private void repaintComponent(Component c) {
            if ("ComboBox.textField".equals(c.getName()) && c.getParent() != null) {
                c.getParent().repaint();
            } else if ("Spinner.formattedTextField".equals(c.getName()) && c.getParent() != null && c.getParent().getParent() != null) {
                c.getParent().getParent().repaint();
            } else if (c.getParent() != null && c.getParent().getParent() != null && c.getParent().getParent() instanceof JScrollPane) {
                JScrollPane sp = (JScrollPane)c.getParent().getParent();
                sp.repaint();
            } else {
                c.repaint();
            }
        }
    }
}

