/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.styles.MenuItemStyle;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class MenuStyle
extends StyleWrapper {
    private static MenuStyle instance = new MenuStyle();

    private MenuStyle() {
    }

    public static MenuStyle getStyle(SynthStyle style, JComponent c, Region region) {
        instance.setStyle(style);
        c.setOpaque(false);
        return instance;
    }

    public Font getFont(SynthContext sc) {
        MenuItemStyle.menuItemHtmlColorCorrection(sc);
        return this.synthStyle.getFont(sc);
    }

    public Color getColor(SynthContext sc, ColorType type) {
        boolean enabled;
        JMenu m = (JMenu)sc.getComponent();
        Boolean b = (Boolean)m.getClientProperty("Synthetica.MOUSE_OVER");
        boolean mouseOver = b == null ? false : b;
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        boolean bl = enabled = (sc.getComponentState() & 1) > 0;
        if (m.isTopLevelMenu() && type.equals(ColorType.TEXT_FOREGROUND)) {
            String colorKey = "Synthetica.menu.toplevel.textColor";
            if (!enabled) {
                colorKey = String.valueOf(colorKey) + ".disabled";
            } else if (selected || mouseOver) {
                colorKey = String.valueOf(colorKey) + ".selected";
            }
            Color color = UIManager.getColor(colorKey);
            if (color != null) {
                return color;
            }
        }
        return this.synthStyle.getColor(sc, type);
    }
}

