/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ToolBarStyle
extends StyleWrapper {
    private LayoutManager orgLayoutManager;
    private Insets orgMargin;
    private HashMap<Integer, Component> orgFillers;
    private HashMap<Component, Float> orgXAlignments;
    private HashMap<Component, Float> orgYAlignments;
    private PropertyChangeListener orientationListener;
    private ContainerListener containerListener;

    public ToolBarStyle(SynthStyle style) {
        this.synthStyle = style;
        this.orgFillers = new HashMap();
        this.orgXAlignments = new HashMap();
        this.orgYAlignments = new HashMap();
    }

    public void installDefaults(SynthContext context) {
        this.synthStyle.installDefaults(context);
        final JToolBar tb = (JToolBar)context.getComponent();
        this.orgLayoutManager = tb.getLayout();
        this.orgMargin = tb.getMargin();
        this.orientationListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals("orientation")) {
                    ToolBarStyle.this.setLayoutManager(tb);
                }
            }
        };
        tb.addPropertyChangeListener(this.orientationListener);
        Component[] components = tb.getComponents();
        int i = 0;
        while (i < components.length) {
            Component c = components[i];
            this.orgXAlignments.put(c, Float.valueOf(c.getAlignmentX()));
            this.orgYAlignments.put(c, Float.valueOf(c.getAlignmentY()));
            if (c instanceof Box.Filler) {
                this.orgFillers.put(i, c);
            }
            ((JComponent)c).setAlignmentX(0.5f);
            ((JComponent)c).setAlignmentY(0.5f);
            ++i;
        }
        this.containerListener = new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                ToolBarStyle.this.orgXAlignments.put(c, Float.valueOf(c.getAlignmentX()));
                ToolBarStyle.this.orgYAlignments.put(c, Float.valueOf(c.getAlignmentY()));
                if (c instanceof Box.Filler) {
                    ToolBarStyle.this.orgFillers.put(tb.getComponents().length - 1, c);
                }
                ((JComponent)c).setAlignmentX(0.5f);
                ((JComponent)c).setAlignmentY(0.5f);
            }

            public void componentRemoved(ContainerEvent e) {
            }
        };
        tb.addContainerListener(this.containerListener);
        this.setLayoutManager(tb);
    }

    public void uninstallDefaults(SynthContext context) {
        this.synthStyle.uninstallDefaults(context);
        JToolBar tb = (JToolBar)context.getComponent();
        tb.removePropertyChangeListener(this.orientationListener);
        tb.removeContainerListener(this.containerListener);
        for (Map.Entry<Integer, Component> entry : this.orgFillers.entrySet()) {
            int index = entry.getKey();
            Component filler = entry.getValue();
            tb.remove(index);
            tb.add(filler, index);
        }
        for (Map.Entry<Serializable, Serializable> entry : this.orgXAlignments.entrySet()) {
            JComponent c = (JComponent)entry.getKey();
            float x = ((Float)entry.getValue()).floatValue();
            c.setAlignmentX(x);
        }
        for (Map.Entry<Serializable, Serializable> entry : this.orgYAlignments.entrySet()) {
            JComponent c = (JComponent)entry.getKey();
            float y = ((Float)entry.getValue()).floatValue();
            c.setAlignmentY(y);
        }
        tb.setMargin(this.orgMargin);
        tb.setLayout(this.orgLayoutManager);
    }

    private void setLayoutManager(JToolBar tb) {
        tb.removeContainerListener(this.containerListener);
        Component[] components = tb.getComponents();
        BoxLayout lm = null;
        if (tb.getOrientation() == 0) {
            lm = new BoxLayout(tb, 2);
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof Box.Filler && this.fillerIsGlue((Box.Filler)components[i])) {
                    tb.remove(components[i]);
                    tb.add(Box.createHorizontalGlue(), i);
                } else if (components[i] instanceof Box.Filler && !this.fillerIsGlue((Box.Filler)components[i])) {
                    tb.remove(components[i]);
                    Component c = this.orgFillers.get(i);
                    Dimension size = c.getPreferredSize();
                    int strut = Math.max(size.width, size.height);
                    tb.add(Box.createHorizontalStrut(strut), i);
                }
                ++i;
            }
            this.setMargin(tb);
            i = 0;
            while (i < components.length) {
                ((JComponent)components[i]).setAlignmentY(0.5f);
                ++i;
            }
        } else {
            lm = new BoxLayout(tb, 3);
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof Box.Filler && this.fillerIsGlue((Box.Filler)components[i])) {
                    tb.remove(components[i]);
                    tb.add(Box.createVerticalGlue(), i);
                } else if (components[i] instanceof Box.Filler && !this.fillerIsGlue((Box.Filler)components[i])) {
                    tb.remove(components[i]);
                    Component c = this.orgFillers.get(i);
                    Dimension size = c.getPreferredSize();
                    int strut = Math.max(size.width, size.height);
                    tb.add(Box.createVerticalStrut(strut), i);
                }
                ++i;
            }
            this.setMargin(tb);
            i = 0;
            while (i < components.length) {
                ((JComponent)components[i]).setAlignmentX(0.5f);
                ++i;
            }
        }
        tb.setLayout(lm);
        tb.addContainerListener(this.containerListener);
    }

    private void setMargin(JToolBar tb) {
        Insets newMargin = null;
        newMargin = tb.getOrientation() == 0 ? UIManager.getInsets("Synthetica.toolBar.margin.horizontal") : UIManager.getInsets("Synthetica.toolBar.margin.vertical");
        if (this.orgMargin != null && newMargin != null) {
            newMargin.bottom += this.orgMargin.bottom;
            newMargin.left += this.orgMargin.left;
            newMargin.top += this.orgMargin.top;
            newMargin.right += this.orgMargin.right;
            tb.setMargin(newMargin);
        }
    }

    private boolean fillerIsGlue(Box.Filler filler) {
        Dimension zeroDim = new Dimension(0, 0);
        return filler.getMinimumSize().equals(zeroDim) && filler.getPreferredSize().equals(zeroDim);
    }
}

