/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Decorator;
import edu.uci.ics.jung.graph.decorators.NumericDecorator;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;

public class BetweennessCentrality
extends AbstractRanker {
    public static final String CENTRALITY = "centrality.BetweennessCentrality";

    public BetweennessCentrality(Graph g) {
        this.initialize(g, true, true);
    }

    public BetweennessCentrality(Graph g, boolean rankNodes) {
        this.initialize(g, rankNodes, true);
    }

    public BetweennessCentrality(Graph g, boolean rankNodes, boolean rankEdges) {
        this.initialize(g, rankNodes, rankEdges);
    }

    protected void computeBetweenness(Graph graph) {
        BetweennessDataDecorator decorator = new BetweennessDataDecorator();
        NumericDecorator bcDecorator = new NumericDecorator(CENTRALITY, UserData.SHARED);
        Set vertices = graph.getVertices();
        UserDataUtils.cleanup(vertices, this.getRankScoreKey());
        UserDataUtils.cleanup(graph.getEdges(), this.getRankScoreKey());
        Iterator vIt = vertices.iterator();
        while (vIt.hasNext()) {
            Vertex s = (Vertex)vIt.next();
            this.initializeData(graph, decorator);
            decorator.data((Element)s).numSPs = 1.0;
            decorator.data((Element)s).distance = 0.0;
            Stack<Vertex> stack = new Stack<Vertex>();
            UnboundedFifoBuffer queue = new UnboundedFifoBuffer();
            queue.add((Object)s);
            while (!queue.isEmpty()) {
                Vertex v = (Vertex)queue.remove();
                stack.push(v);
                Iterator nIt = v.getSuccessors().iterator();
                while (nIt.hasNext()) {
                    Vertex w = (Vertex)nIt.next();
                    if (decorator.data((Element)w).distance < 0.0) {
                        queue.add((Object)w);
                        decorator.data((Element)w).distance = decorator.data((Element)v).distance + 1.0;
                    }
                    if (decorator.data((Element)w).distance != decorator.data((Element)v).distance + 1.0) continue;
                    decorator.data((Element)w).numSPs += decorator.data((Element)v).numSPs;
                    decorator.data((Element)w).predecessors.add(v);
                }
            }
            while (!stack.isEmpty()) {
                Vertex w = (Vertex)stack.pop();
                Iterator v2It = decorator.data((Element)w).predecessors.iterator();
                while (v2It.hasNext()) {
                    Vertex v = (Vertex)v2It.next();
                    double partialDependency = decorator.data((Element)v).numSPs / decorator.data((Element)w).numSPs;
                    decorator.data((Element)v).dependency += (partialDependency *= 1.0 + decorator.data((Element)w).dependency);
                    Edge currentEdge = v.findEdge(w);
                    MutableDouble edgeValue = (MutableDouble)bcDecorator.getValue(currentEdge);
                    edgeValue.add(partialDependency);
                }
                if (w == s) continue;
                MutableDouble bcValue = (MutableDouble)bcDecorator.getValue(w);
                bcValue.add(decorator.data((Element)w).dependency);
            }
        }
        if (PredicateUtils.enforcesEdgeConstraint(graph, Graph.UNDIRECTED_EDGE)) {
            MutableDouble bcValue;
            Iterator v3It = vertices.iterator();
            while (v3It.hasNext()) {
                bcValue = (MutableDouble)bcDecorator.getValue((Vertex)v3It.next());
                bcValue.setDoubleValue(bcValue.doubleValue() / 2.0);
            }
            Iterator eIt = graph.getEdges().iterator();
            while (eIt.hasNext()) {
                bcValue = (MutableDouble)bcDecorator.getValue((Edge)eIt.next());
                bcValue.setDoubleValue(bcValue.doubleValue() / 2.0);
            }
        }
        vIt = vertices.iterator();
        while (vIt.hasNext()) {
            Vertex vertex = (Vertex)vIt.next();
            decorator.removeValue(vertex);
        }
    }

    private void initializeData(Graph g, BetweennessDataDecorator decorator) {
        Iterator vIt = g.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex vertex = (Vertex)vIt.next();
            if (vertex.getUserDatum(CENTRALITY) == null) {
                vertex.addUserDatum(CENTRALITY, new MutableDouble(), UserData.SHARED);
            }
            decorator.setData(new BetweennessData(), vertex);
        }
        Iterator eIt = g.getEdges().iterator();
        while (eIt.hasNext()) {
            Edge e = (Edge)eIt.next();
            if (e.getUserDatum(CENTRALITY) != null) continue;
            e.addUserDatum(CENTRALITY, new MutableDouble(), UserData.SHARED);
        }
    }

    public String getRankScoreKey() {
        return CENTRALITY;
    }

    protected double evaluateIteration() {
        this.computeBetweenness(this.getGraph());
        return 0.0;
    }

    class BetweennessData {
        double distance = -1.0;
        double numSPs = 0.0;
        List predecessors = new ArrayList();
        double dependency = 0.0;

        BetweennessData() {
        }
    }

    class BetweennessDataDecorator
    extends Decorator {
        public BetweennessDataDecorator() {
            super("centrality.BetwennessData", UserData.REMOVE);
        }

        public BetweennessData data(Element udc) {
            return (BetweennessData)udc.getUserDatum(this.getKey());
        }

        public void setData(BetweennessData value, Element udc) {
            udc.setUserDatum(this.getKey(), value, this.getCopyAction());
        }
    }
}

