/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.KPartiteGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgeWeightLabeller;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.KPartiteSparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.predicates.UserDatumVertexPredicate;
import edu.uci.ics.jung.utils.TypedVertexGenerator;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.VertexGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.collections.Predicate;

public class BipartiteGraphReader {
    public static final String PARTITION = "edu.uci.ics.jung.io:Partition";
    public static final UserDatumVertexPredicate PART_A = new UserDatumVertexPredicate("edu.uci.ics.jung.io:Partition", "vertex_ID_A");
    public static final UserDatumVertexPredicate PART_B = new UserDatumVertexPredicate("edu.uci.ics.jung.io:Partition", "vertex_ID_B");
    protected boolean asList;
    protected boolean directed;
    protected boolean parallel;

    public BipartiteGraphReader(boolean asList, boolean directed, boolean parallel) {
        this.asList = asList;
        this.directed = directed;
        this.parallel = parallel;
    }

    public BipartiteGraphReader() {
        this(false, false, false);
    }

    public KPartiteGraph load(Reader reader) throws IOException {
        String curLine;
        LinkedList<UserDatumVertexPredicate> predicates = new LinkedList<UserDatumVertexPredicate>();
        predicates.add(PART_A);
        predicates.add(PART_B);
        KPartiteSparseGraph bg = new KPartiteSparseGraph(predicates, true);
        Collection edge_constraints = bg.getEdgeConstraints();
        if (this.directed) {
            edge_constraints.add(Graph.DIRECTED_EDGE);
        } else {
            edge_constraints.add(Graph.UNDIRECTED_EDGE);
        }
        if (!this.parallel) {
            edge_constraints.add(Graph.NOT_PARALLEL_EDGE);
        }
        TypedVertexGenerator vg = new TypedVertexGenerator(edge_constraints);
        EdgeWeightLabeller ewl = EdgeWeightLabeller.getLabeller(bg);
        BufferedReader br = new BufferedReader(reader);
        while (br.ready() && (curLine = br.readLine()) != null && !curLine.equals("end_of_file")) {
            if (curLine.trim().length() == 0) continue;
            String[] parts = this.asList ? curLine.trim().split("\\s+") : curLine.trim().split("\\s+", 2);
            Vertex v_a = BipartiteGraphReader.getOrCreateVertexByName(bg, vg, parts[0], PART_A);
            int i = 1;
            while (i < parts.length) {
                Vertex v_b;
                Edge e;
                boolean absent;
                boolean bl = absent = (e = v_a.findEdge(v_b = BipartiteGraphReader.getOrCreateVertexByName(bg, vg, parts[i++], PART_B))) == null;
                if (absent || this.parallel) {
                    e = this.directed ? bg.addEdge(new DirectedSparseEdge(v_a, v_b)) : bg.addEdge(new UndirectedSparseEdge(v_a, v_b));
                }
                if (this.parallel) continue;
                if (absent) {
                    ewl.setWeight(e, 1);
                    continue;
                }
                ewl.setWeight(e, ewl.getWeight(e) + 1);
            }
        }
        br.close();
        reader.close();
        return bg;
    }

    private static Vertex getOrCreateVertexByName(Graph bg, VertexGenerator vg, String label, UserDatumVertexPredicate partition) {
        StringLabeller vID_label = StringLabeller.getLabeller(bg, partition);
        Vertex v = vID_label.getVertex(label);
        if (v == null) {
            v = vg.create();
            v.addUserDatum(partition.getKey(), partition.getDatum(), UserData.SHARED);
            bg.addVertex(v);
            try {
                vID_label.setLabel(v, label);
            }
            catch (StringLabeller.UniqueLabelException e1) {
                // empty catch block
            }
        }
        return v;
    }

    public static Predicate getPartition(Vertex v) {
        if (PART_A.evaluate(v)) {
            return PART_A;
        }
        if (PART_B.evaluate(v)) {
            return PART_B;
        }
        throw new IllegalArgumentException("Specified vertex " + v + "is not in any registered partition");
    }

    public void setAsList(boolean asList) {
        this.asList = asList;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isAsList() {
        return this.asList;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isParallel() {
        return this.parallel;
    }
}

