/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.GraphElementAccessor;
import edu.uci.ics.jung.visualization.Layout;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;

public class RadiusGraphElementAccessor
implements GraphElementAccessor {
    protected Layout layout;
    protected double maxDistance;

    public RadiusGraphElementAccessor(Layout l) {
        this(l, Math.sqrt(Double.MAX_VALUE));
    }

    public RadiusGraphElementAccessor(Layout l, double maxDistance) {
        this.maxDistance = maxDistance;
        this.layout = l;
    }

    public Vertex getVertex(double x, double y) {
        return this.getVertex(x, y, this.maxDistance);
    }

    public Vertex getVertex(double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        Vertex closest = null;
        while (true) {
            try {
                Iterator iter = this.layout.getGraph().getVertices().iterator();
                while (iter.hasNext()) {
                    double dy;
                    Vertex v = (Vertex)iter.next();
                    Point2D p = this.layout.getLocation(v);
                    double dx = p.getX() - x;
                    double dist = dx * dx + (dy = p.getY() - y) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        return closest;
    }

    public Edge getEdge(double x, double y) {
        return this.getEdge(x, y, this.maxDistance);
    }

    public Edge getEdge(double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        Edge closest = null;
        while (true) {
            try {
                Iterator iter = this.layout.getGraph().getEdges().iterator();
                while (iter.hasNext()) {
                    double distance2;
                    Edge e = (Edge)iter.next();
                    if (e.numVertices() != 2) continue;
                    Set vertices = e.getIncidentVertices();
                    Iterator vertexIterator = vertices.iterator();
                    Vertex v1 = (Vertex)vertexIterator.next();
                    Vertex v2 = (Vertex)vertexIterator.next();
                    Point2D p1 = this.layout.getLocation(v1);
                    Point2D p2 = this.layout.getLocation(v2);
                    double x1 = p1.getX();
                    double y1 = p1.getY();
                    double x2 = p2.getX();
                    double y2 = p2.getY();
                    if (x1 == x2 && y1 == y2) continue;
                    double b = ((y - y1) * (y2 - y1) + (x - x1) * (x2 - x1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    if (b <= 0.0) {
                        distance2 = (x - x1) * (x - x1) + (y - y1) * (y - y1);
                    } else if (b >= 1.0) {
                        distance2 = (x - x2) * (x - x2) + (y - y2) * (y - y2);
                    } else {
                        double x3 = x1 + b * (x2 - x1);
                        double y3 = y1 + b * (y2 - y1);
                        distance2 = (x - x3) * (x - x3) + (y - y3) * (y - y3);
                    }
                    if (!(distance2 < minDistance)) continue;
                    minDistance = distance2;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        return closest;
    }

    public void setLayout(Layout l) {
        this.layout = l;
    }
}

