/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import jigcell.sbml2.Model;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.UnitDefinition;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public final class Parameter
extends SBaseId {
    private boolean constant;
    private double value;
    private String units;

    public Parameter() {
        this(null, null, Double.NaN);
    }

    public Parameter(Parameter parameter) {
        this(parameter.getId(), parameter.isNameSet() ? parameter.getName() : null);
        this.setConstant(parameter.isConstant());
        this.setValue(parameter.getValue());
        this.setUnits(parameter.getUnits());
    }

    public Parameter(String id, String name) {
        this(id, name, Double.NaN);
    }

    public Parameter(String id, String name, double value) {
        super(id, name);
        this.setValue(value);
        this.setConstant(true);
    }

    public String getUnits() {
        return this.units;
    }

    public UnitDefinition getUnits(Model model) {
        return (UnitDefinition)model.findElementWithId(this.getUnits(), 64);
    }

    public double getValue() {
        return this.value;
    }

    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public boolean isValid(Model model) {
        return super.isValid(model) && this.getUnits(model) != null;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public void setUnits(String units) {
        if (units != null && !Parameter.isValidId(units)) {
            throw new IllegalArgumentException("Invalid SBML identifier.");
        }
        this.units = units;
    }

    public void setUnits(UnitDefinition units) {
        this.setUnits(units == null ? null : units.getId());
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    protected void parse(Attributes attributes) {
        super.parse(attributes);
        if (attributes.getIndex("constant") != -1) {
            this.setConstant(Boolean.valueOf(attributes.getValue("constant")) == Boolean.TRUE);
        }
        this.setUnits(attributes.getValue("units"));
        if (attributes.getIndex("value") != -1) {
            this.setValue(Double.parseDouble(attributes.getValue("value")));
        }
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "parameter");
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        if (!Double.isNaN(this.getValue())) {
            printer.addAttribute("value", String.valueOf(this.getValue()));
        }
        if (!this.isConstant()) {
            printer.addAttribute("constant", "false");
        }
        printer.addAttribute("units", this.getUnits());
        return printer;
    }
}

