/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import jigcell.sbml2.AlgebraicRule;
import jigcell.sbml2.AssignmentRule;
import jigcell.sbml2.Compartment;
import jigcell.sbml2.Event;
import jigcell.sbml2.EventAssignment;
import jigcell.sbml2.FunctionDefinition;
import jigcell.sbml2.KineticLaw;
import jigcell.sbml2.MathElement;
import jigcell.sbml2.Model;
import jigcell.sbml2.ModifierSpeciesReference;
import jigcell.sbml2.Parameter;
import jigcell.sbml2.RateRule;
import jigcell.sbml2.Reaction;
import jigcell.sbml2.Rule;
import jigcell.sbml2.SBMLLevel2Document;
import jigcell.sbml2.SBase;
import jigcell.sbml2.Species;
import jigcell.sbml2.SpeciesReference;
import jigcell.sbml2.StoichiometryMath;
import jigcell.sbml2.Unit;
import jigcell.sbml2.UnitDefinition;
import jigcell.sbml2.XMLElement;
import jigcell.sbml2.XMLReader;
import jigcell.sbml2.jep.JEP;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class SBMLLevel2Reader
extends XMLReader {
    private static final int SBML = 0;
    private static final int ANNOTATIONS = 1;
    private static final int NOTES = 2;
    private static final int RDF = 3;
    private static final int MATH = 4;
    private static final Map elementNameToClass = new HashMap();
    private static final String NAMESPACE_MATHML = "http://www.w3.org/1998/Math/MathML";
    private static final String NAMESPACE_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String NAMESPACE_SBML = "http://www.sbml.org/sbml/level2";
    private final SBMLLevel2Document document;

    public static SBMLLevel2Document read(Reader reader) throws IOException {
        SBMLLevel2Document document = new SBMLLevel2Document();
        SBMLLevel2Reader.read(new SBMLLevel2Reader(document), reader);
        return document;
    }

    @Override
    public void endElement(String namespace, String localName, String qName) throws SAXException {
        if (this.mode == 0 && namespace.equals(NAMESPACE_SBML)) {
            this.endSBMLElement(localName);
        } else if (this.mode == 1) {
            if (localName.equals("annotation") && namespace.equals(NAMESPACE_SBML)) {
                ((SBase)this.peek()).getAnnotations().add(this.endLocalTextElement() + "</annotation>");
            } else {
                this.localText.append("</" + qName + ">");
            }
        } else if (this.mode == 2) {
            if (localName.equals("notes") && namespace.equals(NAMESPACE_SBML)) {
                ((SBase)this.peek()).getNotes().add(this.endLocalTextElement() + "</notes>");
            } else {
                this.localText.append("</" + qName + ">");
            }
        } else if (this.mode == 3) {
            if (localName.equals("RDF") && namespace.equals(NAMESPACE_RDF)) {
                ((SBase)this.peek()).setRDF(this.endLocalTextElement() + "</rdf:RDF>");
            } else {
                this.localText.append("</" + qName + ">");
            }
        } else if (this.mode == 4 && namespace.equals(NAMESPACE_MATHML)) {
            if (localName.equals("math")) {
                this.setTextOfMathElement(this.endLocalTextElement() + "</math:math>\n");
            } else {
                this.localText.append(JEP.isMathMLFunction(localName) ? "<math:" + localName + "/>\n" : "</math:" + localName + ">\n");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.mode == 0 && namespace.equals(NAMESPACE_SBML)) {
            this.startSBMLElement(localName, attributes);
        } else if (this.mode == 2 || this.mode == 1 || this.mode == 3) {
            this.localText.append("<" + qName + SBMLLevel2Reader.createAttributesText(attributes, this.namespacePrefixToURI) + ">");
        } else if (namespace.equals(NAMESPACE_RDF)) {
            if (this.mode != 0 || !localName.equals("RDF")) {
                throw new SAXException("Unexpected RDF tag " + localName + " encountered.");
            }
            this.mode = 3;
            ((SBase)this.peek()).setRDF("<rdf:RDF" + SBMLLevel2Reader.createAttributesText(attributes, this.namespacePrefixToURI) + ">");
        } else {
            if (!namespace.equals(NAMESPACE_MATHML)) throw new SAXException("Found unexpected element [" + namespace + "]" + localName + ".");
            if (this.mode != 4) {
                if (!localName.equals("math")) throw new SAXException("Unexpected MathML tag " + localName + " encountered.");
                this.mode = 4;
                this.localText = new StringBuffer("<math:math>\n");
            } else if (this.mode == 4 && !JEP.isMathMLFunction(localName)) {
                this.localText.append("<math:" + localName + SBMLLevel2Reader.createAttributesText(attributes, null) + ">");
                if (!localName.equals("ci") && !localName.equals("cn")) {
                    this.localText.append("\n");
                }
            }
        }
        this.namespacePrefixToURI.clear();
    }

    private SBMLLevel2Reader(SBMLLevel2Document document) {
        this.document = document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void endSBMLElement(String localName) throws SAXException {
        XMLElement element = this.pop();
        if (localName.equals("algebraicRule")) {
            ((Model)this.peekPastContainer()).addRule((Rule)element);
            return;
        } else if (localName.equals("assignmentRule")) {
            ((Model)this.peekPastContainer()).addRule((Rule)element);
            return;
        } else if (localName.equals("compartment")) {
            ((Model)this.peekPastContainer()).addCompartment((Compartment)element);
            return;
        } else if (localName.equals("event")) {
            ((Model)this.peekPastContainer()).addEvent((Event)element);
            return;
        } else if (localName.equals("eventAssignment")) {
            ((Event)this.peekPastContainer()).getEventAssignment().add((EventAssignment)element);
            return;
        } else if (localName.equals("functionDefinition")) {
            ((Model)this.peekPastContainer()).addFunctionDefinition((FunctionDefinition)element);
            return;
        } else if (localName.equals("kineticLaw")) {
            ((Reaction)this.peek()).setKineticLaw((KineticLaw)element);
            return;
        } else if (localName.equals("modifierSpeciesReference")) {
            XMLElement localElement = this.peek();
            Reaction reaction = (Reaction)this.peekPastContainer();
            if (reaction.getModifiersElement() != localElement) throw new SAXException("ModifierSpeciesReference can only be used in the list of modifiers.");
            reaction.getModifier().add((ModifierSpeciesReference)element);
            return;
        } else if (localName.equals("parameter")) {
            XMLElement localElement = this.peekPastContainer();
            if (localElement instanceof KineticLaw) {
                ((KineticLaw)localElement).getParameter().add((Parameter)element);
                return;
            } else {
                ((Model)localElement).addParameter((Parameter)element);
            }
            return;
        } else if (localName.equals("rateRule")) {
            ((Model)this.peekPastContainer()).addRule((Rule)element);
            return;
        } else if (localName.equals("reaction")) {
            ((Model)this.peekPastContainer()).addReaction((Reaction)element);
            return;
        } else if (localName.equals("species")) {
            ((Model)this.peekPastContainer()).addSpecies((Species)element);
            return;
        } else if (localName.equals("speciesReference")) {
            XMLElement localElement = this.peek();
            Reaction reaction = (Reaction)this.peekPastContainer();
            if (reaction.getReactantsElement() == localElement) {
                reaction.getReactant().add((SpeciesReference)element);
                return;
            } else {
                if (reaction.getProductsElement() != localElement) throw new SAXException("SpeciesReference can only be used in the list of reactants or list of products.");
                reaction.getProduct().add((SpeciesReference)element);
            }
            return;
        } else if (localName.equals("stoichiometryMath")) {
            ((SpeciesReference)this.peek()).setStoichiometryMath((StoichiometryMath)element);
            return;
        } else if (localName.equals("unit")) {
            ((UnitDefinition)this.peekPastContainer()).getUnits().add((Unit)element);
            return;
        } else {
            if (!localName.equals("unitDefinition")) return;
            ((Model)this.peekPastContainer()).addUnitDefinition((UnitDefinition)element);
        }
    }

    private void setTextOfMathElement(String text) throws SAXException {
        XMLElement element = this.peek();
        if (element instanceof MathElement) {
            ((MathElement)((Object)element)).setMath(text);
            return;
        }
        Event event = (Event)this.peekPastContainer();
        if (event.getDelayElement() == element) {
            event.setDelay(text);
        } else if (event.getTriggerElement() == element) {
            event.setTrigger(text);
        } else {
            throw new SAXException("Can only set math for an event when in delay, trigger, or assignment.");
        }
    }

    private void startSBMLElement(String localName, Attributes attributes) throws SAXException {
        SBase element;
        if (localName.equals("notes")) {
            this.mode = 2;
            this.localText = new StringBuffer("<notes" + SBMLLevel2Reader.createAttributesText(attributes, this.namespacePrefixToURI) + ">");
            return;
        }
        if (localName.equals("annotation")) {
            this.mode = 1;
            this.localText = new StringBuffer("<annotation" + SBMLLevel2Reader.createAttributesText(attributes, this.namespacePrefixToURI) + ">");
            return;
        }
        Class elementClass = (Class)elementNameToClass.get(localName);
        if (elementClass != null) {
            try {
                element = (SBase)elementClass.newInstance();
            }
            catch (Exception e) {
                throw (SAXException)new SAXException("Unable to create " + localName + " element.").initCause(e);
            }
        } else if (localName.equals("delay")) {
            element = ((Event)this.peek()).getDelayElement();
        } else if (localName.equals("listOfCompartments")) {
            element = ((Model)this.peek()).getCompartmentsElement();
        } else if (localName.equals("listOfEventAssignments")) {
            element = ((Event)this.peek()).getAssignmentsElement();
        } else if (localName.equals("listOfEvents")) {
            element = ((Model)this.peek()).getEventsElement();
        } else if (localName.equals("listOfFunctionDefinitions")) {
            element = ((Model)this.peek()).getFunctionDefinitionsElement();
        } else if (localName.equals("listOfModifiers")) {
            element = ((Reaction)this.peek()).getModifiersElement();
        } else if (localName.equals("listOfParameters")) {
            XMLElement localElement = this.peek();
            element = localElement instanceof KineticLaw ? ((KineticLaw)localElement).getParameterElement() : ((Model)this.peek()).getParametersElement();
        } else if (localName.equals("listOfProducts")) {
            element = ((Reaction)this.peek()).getProductsElement();
        } else if (localName.equals("listOfReactants")) {
            element = ((Reaction)this.peek()).getReactantsElement();
        } else if (localName.equals("listOfReactions")) {
            element = ((Model)this.peek()).getReactionsElement();
        } else if (localName.equals("listOfRules")) {
            element = ((Model)this.peek()).getRulesElement();
        } else if (localName.equals("listOfSpecies")) {
            element = ((Model)this.peek()).getSpeciesElement();
        } else if (localName.equals("listOfUnitDefinitions")) {
            element = ((Model)this.peek()).getUnitDefinitionsElement();
        } else if (localName.equals("listOfUnits")) {
            element = ((UnitDefinition)this.peek()).getUnitsElement();
        } else if (localName.equals("model")) {
            Model model = new Model();
            this.document.setModel(model);
            element = model;
        } else if (localName.equals("sbml")) {
            element = this.document;
        } else if (localName.equals("trigger")) {
            element = ((Event)this.peek()).getTriggerElement();
        } else {
            throw new SAXException("Found unknown SBML element " + localName + ".");
        }
        element.parse(attributes);
        this.push(element);
    }

    static {
        elementNameToClass.put("algebraicRule", AlgebraicRule.class);
        elementNameToClass.put("assignmentRule", AssignmentRule.class);
        elementNameToClass.put("compartment", Compartment.class);
        elementNameToClass.put("event", Event.class);
        elementNameToClass.put("eventAssignment", EventAssignment.class);
        elementNameToClass.put("functionDefinition", FunctionDefinition.class);
        elementNameToClass.put("kineticLaw", KineticLaw.class);
        elementNameToClass.put("modifierSpeciesReference", ModifierSpeciesReference.class);
        elementNameToClass.put("parameter", Parameter.class);
        elementNameToClass.put("rateRule", RateRule.class);
        elementNameToClass.put("reaction", Reaction.class);
        elementNameToClass.put("species", Species.class);
        elementNameToClass.put("speciesReference", SpeciesReference.class);
        elementNameToClass.put("stoichiometryMath", StoichiometryMath.class);
        elementNameToClass.put("unit", Unit.class);
        elementNameToClass.put("unitDefinition", UnitDefinition.class);
    }
}

