/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import jigcell.sbml2.Model;
import jigcell.sbml2.SBase;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.Species;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public abstract class SimpleSpeciesReference
extends SBase {
    private String species;

    public String getSpecies() {
        return this.species;
    }

    public final Species getSpecies(Model model) {
        return (Species)model.findElementWithId(this.getSpecies(), 32);
    }

    @Override
    public boolean isValid(Model model) {
        return super.isValid(model) && this.getSpecies(model) != null;
    }

    public final void setSpecies(String species) {
        if (species != null && !SBaseId.isValidId(species)) {
            throw new IllegalArgumentException("Invalid SBML identifier.");
        }
        this.species = species;
    }

    public final void setSpecies(Species species) {
        this.setSpecies(species == null ? null : species.getId());
    }

    @Override
    protected void parse(Attributes attributes) {
        super.parse(attributes);
        this.setSpecies(attributes.getValue("species"));
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        printer.addAttribute("species", this.getSpecies());
        return printer;
    }
}

