/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.jep;

import jigcell.sbml2.jep.ASTConstant;
import jigcell.sbml2.jep.ASTElse;
import jigcell.sbml2.jep.ASTElseIfThen;
import jigcell.sbml2.jep.ASTFunNode;
import jigcell.sbml2.jep.ASTIfThen;
import jigcell.sbml2.jep.ASTPiecewise;
import jigcell.sbml2.jep.ASTStart;
import jigcell.sbml2.jep.ASTVarNode;
import jigcell.sbml2.jep.JEP;
import jigcell.sbml2.jep.ParserVisitor;
import jigcell.sbml2.jep.SimpleNode;

public class ParserDumpVisitor
implements ParserVisitor {
    private int indent = 0;
    private StringBuffer sbmlString = new StringBuffer();

    public String getSBMLString() {
        return this.sbmlString.toString();
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        System.out.println(this.indentString() + node + ": acceptor not unimplemented in subclass?");
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    @Override
    public Object visit(ASTPiecewise node, Object data) {
        this.sbmlString.append(this.indentString() + "<math:piecewise>\n");
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        this.sbmlString.append(this.indentString() + "</math:piecewise>\n");
        return data;
    }

    @Override
    public Object visit(ASTStart node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    @Override
    public Object visit(ASTFunNode node, Object data) {
        if (JEP.isMathMLFunction(node.toString())) {
            this.sbmlString.append(this.indentString() + "<math:apply>\n" + this.indentString() + " <math:" + node + "/>\n");
        } else if (node.toString().trim().equals("sqrt")) {
            this.sbmlString.append(this.indentString() + "<math:apply>\n" + this.indentString() + " <math:" + "root" + "/>\n" + this.indentString() + "<math:degree><math:ci>2</math:ci></math:degree>\n");
        } else {
            this.sbmlString.append(this.indentString() + "<math:apply>\n" + this.indentString() + "<math:ci>" + node + "</math:ci>\n");
        }
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        this.sbmlString.append(this.indentString() + "</math:apply>\n");
        return data;
    }

    @Override
    public Object visit(ASTVarNode node, Object data) {
        this.sbmlString.append(this.indentString() + "<math:ci>" + node + "</math:ci>\n");
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    @Override
    public Object visit(ASTConstant node, Object data) {
        this.sbmlString.append(this.indentString() + "<math:cn>" + node + "</math:cn>\n");
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    @Override
    public Object visit(ASTIfThen node, Object data) {
        this.sbmlString.append(this.indentString() + "<math:piece>\n");
        ++this.indent;
        data = node.childrenAcceptReverse(this, data);
        --this.indent;
        this.sbmlString.append(this.indentString() + "</math:piece>\n");
        return data;
    }

    @Override
    public Object visit(ASTElseIfThen node, Object data) {
        this.sbmlString.append(this.indentString() + "<math:piece>\n");
        ++this.indent;
        data = node.childrenAcceptReverse(this, data);
        --this.indent;
        this.sbmlString.append(this.indentString() + "</math:piece>\n");
        return data;
    }

    @Override
    public Object visit(ASTElse node, Object data) {
        this.sbmlString.append(this.indentString() + "<math:otherwise>\n");
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        this.sbmlString.append(this.indentString() + "</math:otherwise>\n");
        return data;
    }

    private String indentString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.indent; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

