/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.squad2;

import jargs.gnu.CmdLineParser;
import org.compbiollab.squad2.AppProperties;
import org.compbiollab.squad2.Log4JConfigurator;
import org.compbiollab.squad2.NonGUI;
import org.enfin.squad.dl.Stdout;
import org.enfin.squad.perturbations.pl.Perturbation_Main;
import org.enfin.squad.pl.GUI;

public class Start {
    public static void main(String[] args) {
        Log4JConfigurator.configureLog4J(AppProperties.LOG4JCONFIG);
        if (args.length == 0) {
            GUI mainWindow = new GUI();
            mainWindow.setVisible(true);
        } else {
            NonGUI commandLineControl;
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option mmlFile = parser.addStringOption("mmlfile");
            CmdLineParser.Option sbmlFile = parser.addStringOption("sbmlfile");
            CmdLineParser.Option feedbackLoops = parser.addStringOption("findloops");
            CmdLineParser.Option perturbation = parser.addStringOption("perturbation");
            CmdLineParser.Option perturbationDisplay = parser.addStringOption("d");
            try {
                parser.parse(args);
            }
            catch (CmdLineParser.IllegalOptionValueException ex) {
                ex.printStackTrace();
            }
            catch (CmdLineParser.UnknownOptionException ex) {
                ex.printStackTrace();
            }
            String mmlFileName = (String)parser.getOptionValue(mmlFile);
            String sbmlFileName = (String)parser.getOptionValue(sbmlFile);
            String findLoopsFileName = (String)parser.getOptionValue(feedbackLoops);
            if (mmlFileName != null) {
                commandLineControl = new NonGUI();
                commandLineControl.loadFileAndRun(mmlFileName);
            } else if (sbmlFileName != null) {
                commandLineControl = new NonGUI();
                commandLineControl.loadFileAndRun(sbmlFileName);
            }
            if (findLoopsFileName != null) {
                commandLineControl = new NonGUI();
                Stdout.vectorOfVectors(commandLineControl.findAllFeedbackLoops(findLoopsFileName));
            }
            if (perturbation != null) {
                if (args.length < 3) {
                    Perturbation_Main.perturbOdeInteractive(null, null);
                } else if (perturbationDisplay != null) {
                    Perturbation_Main.perturbOdeInteractive(args[1], args[2]);
                } else {
                    Perturbation_Main.perturbOde(args[1], args[2]);
                }
            }
        }
    }
}

