/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.bl;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.Coordinates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.enfin.squad.bl.AbstractGraphNode;

public class GraphNode
extends AbstractGraphNode
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    boolean display = true;

    public GraphNode(Vertex node) {
        this.delegate = node;
        this.initializeNode();
    }

    public GraphNode(String name, Double decay, Double gain) {
        this.delegate = new DirectedSparseVertex();
        this.initializeNode();
        this.setName(name);
        this.setInitialDecay(decay, true);
        this.setInitialGain(gain, true);
    }

    private void initializeNode() {
        if (this.delegate.getUserDatum((Object)"decay") == null) {
            this.delegate.addUserDatum((Object)"decay", (Object)1.0, UserData.SHARED);
        }
        if (this.delegate.getUserDatum((Object)"state") == null) {
            this.delegate.addUserDatum((Object)"state", (Object)0.0, UserData.SHARED);
        }
        if (this.delegate.getUserDatum((Object)"visible") == null) {
            this.delegate.addUserDatum((Object)"visible", (Object)true, UserData.SHARED);
        }
        if (this.delegate.getUserDatum((Object)"gain") == null) {
            this.delegate.addUserDatum((Object)"gain", (Object)10.0, UserData.SHARED);
        }
        if (this.delegate.getUserDatum((Object)"initialstate") == null) {
            this.delegate.addUserDatum((Object)"initialstate", (Object)this.getState(), UserData.SHARED);
        }
        if (this.delegate.getUserDatum((Object)"initialgain") == null) {
            this.delegate.addUserDatum((Object)"initialgain", (Object)this.getGain(), UserData.SHARED);
        }
        if (this.delegate.getUserDatum((Object)"initialdecay") == null) {
            this.delegate.addUserDatum((Object)"initialdecay", (Object)this.getDecay(), UserData.SHARED);
        }
    }

    public static ArrayList<AbstractGraphNode> getNodesFromGraph(Graph graph) {
        ArrayList<AbstractGraphNode> nodeList = new ArrayList<AbstractGraphNode>();
        for (Object vrt : graph.getVertices()) {
            nodeList.add(new GraphNode((Vertex)vrt));
        }
        Collections.sort(nodeList, new AbstractGraphNode.NodeSorter());
        return nodeList;
    }

    public static ArrayList<String> getAllNodeNames(List<AbstractGraphNode> nodes) {
        ArrayList<String> names = new ArrayList<String>();
        for (AbstractGraphNode nd : nodes) {
            names.add(nd.getName());
        }
        Collections.sort(names);
        return names;
    }

    @Override
    public void setToInitialState() {
        this.setState(this.getInitialState());
        this.setDecay(this.getInitialDecay());
        this.setGain(this.getInitialGain());
    }

    @Override
    public Coordinates getNodePosition() {
        Object x = this.delegate.getUserDatum((Object)"posx");
        Object y = this.delegate.getUserDatum((Object)"posy");
        if (x != null && y != null) {
            return new Coordinates(Double.parseDouble(x.toString()), Double.parseDouble(y.toString()));
        }
        return null;
    }

    @Override
    public String getName() {
        return this.delegate.getUserDatum((Object)"id").toString();
    }

    @Override
    public Double getGain() {
        if (this.delegate.getUserDatum((Object)"gain") != null && this.delegate.getUserDatum((Object)"gain") != "") {
            return Double.parseDouble(this.delegate.getUserDatum((Object)"gain").toString());
        }
        return 10.0;
    }

    @Override
    public void setGain(Double gn) {
        this.delegate.setUserDatum((Object)"gain", (Object)gn, UserData.SHARED);
    }

    @Override
    public void setName(String nodeName) {
        this.delegate.setUserDatum((Object)"id", (Object)nodeName, UserData.SHARED);
    }

    @Override
    public Double getDecay() {
        if (this.delegate.getUserDatum((Object)"decay") != null && this.delegate.getUserDatum((Object)"decay") != "") {
            return Double.parseDouble(this.delegate.getUserDatum((Object)"decay").toString());
        }
        return 1.0;
    }

    @Override
    public void setDecay(Double decayValue) {
        this.delegate.setUserDatum((Object)"decay", (Object)decayValue, UserData.SHARED);
    }

    @Override
    public boolean isVisible() {
        if (this.getUserDatum("visible") != null) {
            return Boolean.parseBoolean(this.getUserDatum("visible").toString());
        }
        return true;
    }

    @Override
    public void setVisible(boolean displayNode) {
        this.setUserDatum("visible", displayNode, UserData.SHARED);
    }

    @Override
    public Double getState() {
        return Double.parseDouble(this.getUserDatum("state").toString());
    }

    @Override
    public void setState(Double nodeState) {
        this.setUserDatum("state", nodeState, UserData.SHARED);
    }

    @Override
    public void setInitialState(Double inState, boolean resetCurrentState) {
        this.setUserDatum("initialstate", inState, UserData.SHARED);
        if (resetCurrentState) {
            this.setState(inState);
        }
    }

    @Override
    public void setInitialGain(Double inGain, boolean resetCurrentState) {
        this.setUserDatum("initialgain", inGain, UserData.SHARED);
        if (resetCurrentState) {
            this.setGain(inGain);
        }
    }

    @Override
    public void setInitialDecay(Double inDecay, boolean resetCurrentState) {
        this.setUserDatum("initialdecay", inDecay, UserData.SHARED);
        if (resetCurrentState) {
            this.setDecay(inDecay);
        }
    }

    @Override
    public Vertex getVertex() {
        return this.delegate;
    }

    public void setVertex(Vertex vx) {
        this.delegate = vx;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new GraphNode((Vertex)this.delegate.clone());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Double getInitialDecay() {
        return (Double)this.getUserDatum("initialdecay");
    }

    @Override
    public Double getInitialGain() {
        return (Double)this.getUserDatum("initialgain");
    }

    @Override
    public Double getInitialState() {
        return (Double)this.getUserDatum("initialstate");
    }
}

