/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.bl;

import ch.epfl.genysis.genYsis;
import edu.uci.ics.jung.graph.Graph;
import java.io.File;
import java.util.ArrayList;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.NodeValueState;
import org.enfin.squad.dl.NetIO;

public class SteadyStateBDDFinder {
    public static ArrayList<NetworkState> getSteadyStates(String fileName) throws Exception {
        return SteadyStateBDDFinder.genSysToNetworkState(genYsis.findSteadyStates(fileName));
    }

    public static ArrayList<NetworkState> getSteadyStates(Graph gr) throws Exception {
        File tmp = File.createTempFile("SquadTemporaryFile", ".txt");
        NetIO.writeToFile(gr, tmp);
        String genYsisResults = genYsis.findSteadyStates(tmp.getAbsolutePath());
        ArrayList<NetworkState> states = SteadyStateBDDFinder.genSysToNetworkState(genYsisResults);
        tmp.deleteOnExit();
        return states;
    }

    private static ArrayList<NetworkState> genSysToNetworkState(String bddResult) {
        ArrayList<NetworkState> statesList = new ArrayList<NetworkState>();
        try {
            String allSteadyStates = bddResult;
            String[] lines = allSteadyStates.split("\n");
            String[] geneName = lines[0].split("   ");
            for (int i = 1; i < lines.length; ++i) {
                NetworkState nt = new NetworkState("SS-" + i);
                String[] steadyState = lines[i].split("   ");
                if (steadyState.length > geneName.length) {
                    System.out.println("Steady state is a cycle");
                    for (int m = 0; m < steadyState.length / geneName.length; ++m) {
                        System.out.println("State" + m);
                        for (int j = 0; j < geneName.length; ++j) {
                            Double val = Double.parseDouble(steadyState[m * geneName.length + j]);
                            nt.addNode(geneName[j], new NodeValueState(geneName[j], val));
                        }
                    }
                } else {
                    for (int j = 0; j < steadyState.length; ++j) {
                        Double val = Double.parseDouble(steadyState[j]);
                        nt.addNode(geneName[j], new NodeValueState(geneName[j], val));
                    }
                }
                statesList.add(nt);
            }
            statesList.trimToSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statesList;
    }

    public static void main(String[] args) {
        try {
            ArrayList<NetworkState> ntws = SteadyStateBDDFinder.getSteadyStates("samples/Th_v9.net");
            System.out.println(ntws.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

