/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.dl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.Coordinates;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.GraphEdge;
import org.enfin.squad.bl.GraphNode;
import org.enfin.squad.bl.IEdge;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.NodeValueState;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MML2IO {
    protected boolean directed;
    protected boolean undirected;
    private ArrayList<NetworkState> states;
    private StringLabeller mmlLabeller;
    private Graph theGraph;

    public Graph load(String fileName) {
        try {
            File myFile = new File(fileName);
            SAXBuilder sx = new SAXBuilder();
            Document doc = sx.build(myFile.toURI().getPath());
            Element root = doc.getRootElement();
            this.theGraph = this.readGraph(root.getChild("graph"));
            List allNodes = root.getChild("graph").getChild("nodes").getChildren();
            for (Element nd : allNodes) {
                this.readNode(nd);
            }
            List allEdges = root.getChild("graph").getChild("edges").getChildren();
            for (Element ed : allEdges) {
                this.readEdge(ed);
            }
            this.states = this.loadStates(fileName);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new FatalException("An error occured while reasing the STATES attribute of the file, make sure that the tags are well formatted and that all the STATES have different ID's ");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FatalException("An error occured while reasing the STATES attribute of the file, make sure that the tags are well formatted and that all the STATES have different ID's ");
        }
        return this.theGraph;
    }

    public MML2IO() {
    }

    public MML2IO(String fileName) {
        this();
        this.load(fileName);
    }

    private Graph readGraph(Element graphNode) {
        DirectedSparseGraph myGraph = new DirectedSparseGraph();
        this.mmlLabeller = StringLabeller.getLabeller((Graph)myGraph);
        for (Attribute at : graphNode.getAttributes()) {
            myGraph.setUserDatum((Object)at.getName(), (Object)at.getValue(), UserData.SHARED);
        }
        return myGraph;
    }

    private Vertex readNode(Element node) {
        Vertex theNode = this.theGraph.addVertex((Vertex)new SparseVertex());
        String idString = node.getAttributeValue("id");
        try {
            this.mmlLabeller.setLabel(theNode, idString);
        }
        catch (StringLabeller.UniqueLabelException ule) {
            throw new FatalException("Ids must be unique");
        }
        for (Attribute at : node.getAttributes()) {
            theNode.setUserDatum((Object)at.getName(), (Object)at.getValue(), UserData.SHARED);
        }
        return theNode;
    }

    private Edge readEdge(Element edge) {
        String sourceId = edge.getAttribute("source").getValue();
        Vertex sourceVertex = this.mmlLabeller.getVertex(sourceId);
        String targetId = edge.getAttribute("target").getValue();
        Vertex targetVertex = this.mmlLabeller.getVertex(targetId);
        DirectedSparseEdge theEdge = new DirectedSparseEdge(sourceVertex, targetVertex);
        this.theGraph.addEdge((Edge)theEdge);
        for (Attribute at : edge.getAttributes()) {
            theEdge.setUserDatum((Object)at.getName(), (Object)at.getValue(), UserData.SHARED);
        }
        return theEdge;
    }

    public Graph getGraph() {
        return this.theGraph;
    }

    public ArrayList<NetworkState> getStates() {
        return this.states;
    }

    public static void writeToFile(Graph gr, List<NetworkState> networkstates, File fileOut, boolean saveCurrentConfiguration) throws IOException {
        Element root = new Element("mml");
        root.getAttributes().add(new Attribute("level", "2"));
        Document doc = new Document(root);
        root.addContent((Content)new Comment("Modelomics Markup Language (MML) v2.0"));
        Element model = new Element("model");
        Element graph = new Element("graph");
        root.getChildren().add(model);
        root.getChildren().add(graph);
        Element nodes = new Element("nodes");
        Element edges = new Element("edges");
        Element states = new Element("states");
        graph.getChildren().add(nodes);
        graph.getChildren().add(edges);
        graph.getChildren().add(states);
        ArrayList<AbstractGraphNode> listOfNodes = GraphNode.getNodesFromGraph(gr);
        ArrayList<IEdge> listOfEdges = GraphEdge.getIedgesFromGraph(gr);
        Collections.sort(listOfNodes, new AbstractGraphNode.NodeSorter());
        for (AbstractGraphNode nd : listOfNodes) {
            Element newNode = new Element("node");
            newNode.getAttributes().add(new Attribute("id", nd.getName()));
            if (saveCurrentConfiguration) {
                newNode.getAttributes().add(new Attribute("state", nd.getInitialState().toString()));
                newNode.getAttributes().add(new Attribute("decay", nd.getInitialDecay().toString()));
                newNode.getAttributes().add(new Attribute("gain", nd.getInitialGain().toString()));
                newNode.getAttributes().add(new Attribute("visible", String.valueOf(nd.isVisible())));
            } else {
                newNode.getAttributes().add(new Attribute("state", "0"));
                newNode.getAttributes().add(new Attribute("decay", "1"));
                newNode.getAttributes().add(new Attribute("gain", "10"));
                newNode.getAttributes().add(new Attribute("visible", "true"));
            }
            Coordinates pos = nd.getNodePosition();
            if (pos != null) {
                newNode.getAttributes().add(new Attribute("posx", Double.toString(pos.getX())));
                newNode.getAttributes().add(new Attribute("posy", Double.toString(pos.getY())));
            }
            nodes.getChildren().add(newNode);
        }
        for (IEdge ed : listOfEdges) {
            Element newEdge = new Element("edge");
            newEdge.getAttributes().add(new Attribute("id", ed.getDescription().replace(">", "-")));
            newEdge.getAttributes().add(new Attribute("source", ed.getSource()));
            newEdge.getAttributes().add(new Attribute("target", ed.getTarget()));
            newEdge.getAttributes().add(new Attribute("sign", ed.getSign()));
            if (saveCurrentConfiguration) {
                newEdge.getAttributes().add(new Attribute("weight", ed.getWeight().toString()));
            } else {
                newEdge.getAttributes().add(new Attribute("weight", "1"));
            }
            edges.getChildren().add(newEdge);
        }
        if (networkstates != null) {
            for (NetworkState nt : networkstates) {
                Element newState = new Element("state");
                newState.getAttributes().add(new Attribute("id", nt.getId()));
                for (Map.Entry<String, NodeValueState> nodeState : nt.getNodeStates().entrySet()) {
                    if (!(nodeState.getValue().getContinuousValue() > 0.0)) continue;
                    Element newActiveNode = new Element("activenode");
                    newActiveNode.getAttributes().add(new Attribute("id", nodeState.getKey()));
                    newActiveNode.getAttributes().add(new Attribute("statediscrete", nodeState.getValue().getDiscreteValue().toString()));
                    newActiveNode.getAttributes().add(new Attribute("state", nodeState.getValue().getContinuousValue().toString()));
                    newState.getChildren().add(newActiveNode);
                }
                states.getChildren().add(newState);
            }
        }
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            outputter.output(doc, (Writer)new FileWriter(fileOut));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("The mml file could not be created");
        }
    }

    public ArrayList<NetworkState> loadStates(String fileName) {
        try {
            File myFile = new File(fileName);
            SAXBuilder sx = new SAXBuilder();
            Document doc = sx.build(myFile.toURI().getPath());
            Element root = doc.getRootElement();
            if (root.getChild("graph").getChild("states") != null) {
                this.states = new ArrayList();
                List myStates = root.getChild("graph").getChild("states").getChildren();
                for (Element st : myStates) {
                    NetworkState myState = MML2IO.parseState(st);
                    this.states.add(myState);
                }
                if (this.states.size() == 0) {
                    this.states = null;
                }
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.states;
    }

    public static NetworkState parseState(Element stateNode) {
        NetworkState newState = new NetworkState(stateNode.getAttributeValue("id"));
        for (Element el : stateNode.getChildren()) {
            Double valCont;
            Double valDiscrete = valCont = Double.valueOf(Double.parseDouble(el.getAttributeValue("state")));
            if (el.getAttribute("statediscrete") != null) {
                valDiscrete = Double.parseDouble(el.getAttributeValue("statediscrete"));
            }
            String id = el.getAttributeValue("id");
            newState.put(id, new NodeValueState(id, valDiscrete, valCont));
        }
        return newState;
    }

    public List<Graph> loadGraphCollection(String dirName, FilenameFilter filter) {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new FatalException("Parameter dirName must be a directory");
        }
        String[] files = dir.list(filter);
        ArrayList<Graph> graphCollection = new ArrayList<Graph>();
        for (int i = 0; i < files.length; ++i) {
            String currentFile = dirName + File.separatorChar + files[i];
            MML2IO graphmlFile = new MML2IO();
            Graph graph = graphmlFile.load(currentFile);
            graphCollection.add(graph);
        }
        return graphCollection;
    }
}

